# Proselint
Writing is notoriously hard, even for the best writers. Yet there is a tremendous amount of knowledge about the discipline strewn across usage guides, dictionaries, technical manuals, essays, pamphlets, websites, and the hearts and minds of great authors and editors. But poring over Strunk & White hardly makes one a better writer — it turns you into neither Strunk nor White. And nobody has the capacity to apply all the advice from Garner’s Modern American Usage, a 975-page usage guide, to everything they write. In fact, the whole notion that one becomes a better writer by reading advice on writing rests on untenable assumptions about learning and memory. The traditional formats of knowledge about writing are thus essentially inert, waiting to be transformed.

We devised a simple solution: proselint, a linter for prose. (A linter is a computer program that, like a spell checker, scans through a document and analyzes it.)

Proselint places the world's greatest writers and editors by your side, where they whisper suggestions on how to improve your prose. You'll be guided by advice inspired by Bryan Garner, David Foster Wallace, Chuck Palahniuk, Steve Pinker, Mary Norris, Mark Twain, Elmore Leonard, George Orwell, Matthew Butterick, William Strunk, E.B. White, Philip Corbett, Ernest Gowers, and the editorial staff of the world's finest literary magazines and newspapers, among others. Our goal is to aggregate knowledge about best practices in writing and to make that knowledge immediately accessible to all authors in the form of a linter for prose.

This is a live demo. Obviously, you can hover over the underlined text to see what the issue is, then fix it.

# Dates & times
The 1950's were a swell time.
The 50's were a swell time.
Things happened from 1980-1999 and from 240-398 A.D.
March, 2013 was notable in that
In February of 2010, the mayor considered
It's 5 pm somewhere.
It's 12 a.m., time to eat lunch.
It's 11 p.m. at night.

# Consistency
This is a sentence! One space after a period.
This is a sentence.  Two spaces after a period.
This is a sentence?  Two spaces after a period.
This is a sentence. One space after a period.
This is a sentence. One space after a period.
This is a sentence. One space after a period.
This is a sentence. One space after a period.
centre centre center
organize, organized, organizing, organise
recognize, recognise, recognise, recognise

# Symbols
$1000 USD
I hit him over the head with a 2 x 4.

# Venery terms
A bunch of antelopes walked by the road.
A group of emus attacked me.
She swam by a bunch of oysters.

# Mondegreens
They hae slain the Earl o' Moray and Lady Mondegreen.
A girl with colitis goes by.

# Skunked terms
The building is deceptively large.
The project would decimate the fragile wetland wilderness.
Hopefully, one day we will all grow older.

# Links
www.google.com
http://broken.proselint.com
http://news.ycombinator.com

# Hyperbolic language
and so I said PLEASE STOP YELLING
so excited!
so excited!!
so excited!!!
so excited!!!!
really??
and so I said PLEASE STOP YELLING
and so I said PLEASE STOP YELLING okay?
THESE ARE SMALL CAPS at the beginning of a new line.

# Preferred forms
abbreviatable to NASA
academicly superior.
transhipped
an aider and abbeter
it's adducable
let's look for an acquiror
i wonder what tort-feasor means
Get that off of me before I catch on fire!
There are many a person I have met and worked with who simply deride themselves into taking some action
In the meanwhile, he looked loving at the sheep.
Suddenly, I see.

# Mixed metaphors
Get ready: button your seatbelts.
The cream rises to the crop.
The biggest bottleneck is that...

# Illogic and redundancy
he is very smart
approximately about 5 atm machines
atm machine
we associate together
it's blatantly obvious that this obviously works.
a very unique idea
a more perfect union
the surrounding circumstances
he filled a much-needed gap
To coin a phrase from the movie,

# Blowing the punchline
Suddenly, the car came to a stop.
All hell broke loose on the farm.

# Clichés
under the weather
He's a chip off the old block
a quantum leap
Our cutting edge decision-making process will make your life crystal clear.
He's a thought leader.

# Security
John's cc#:
378282246310005
the password is tnoernturpn
my password is long and 'long'
my password is amazing

# Commercialese
inst.
please be advised that

# Archaism
boughten

# Dismissive tone
this obviously works

# Chatspeak
brb
rofl

# Ogilvy's pretension
We'll need to reconceptualize this sentence.

# Airlinese
enplanement
We'll be taking off momentarily.

# Tense present
Save up to 50% or More!
between you and i
I did it on accident
I feel nauseous

# Phrasal adjectives
It was a highly-anticipated event.
The English speaking people speak English.
A big ticket item.
A right wing militia.

# Various misspellings
highfaluting
the statement was inadmissable in court
Nikita Khruschev
I feel innundated with email
Nicknack
He's a shoe-in
Brett Farve and Dwayne Wade are good friends.
The Chronicals of Narnia

# Strunk & White composition & regex checks
I did not pay for the check. Honestly, attention to detail is useful.
I did not pay attention to detail.
I did not pay any attention to detail.

# Typography
(c) 2015
(R) The Corporation
Use ellipsis not three dots...

# Denizen labels
The Manchesterian was a good Brit.
One from Michigan is not a Michiganite but a Michigander.
One from Colorado is not a Coloradoan but a Coloradan.

# Sexism
The lady lawyer handled my case.
John and Mary married. Now they are man and wife.
Chairman Mao was the chairman of the communist party.

# Punctuation
Smith, et. al (2006) said

# Quoted text
John said that I am "very unique."
John knows that I am very unique.
John knows every unique snowflake is cold.

# Metadiscourse
The preceeding discussion

# Narcisism, metadiscourse, latin, and hedging
The 'take-home message' is that
more research is needed
The rest of this article argues that, to a certain degree
in recent years, an increasing number of psychologists have
mutatis mutandis
