package org.jboss.cache.commands.read;

import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.commands.Visitor;

/**
 * Implements functionality defined by {@link org.jboss.cache.Cache#getNode(org.jboss.cache.Fqn)}
 * <p/>
 * This is the equivalent of the old MethodCallDefinitions.getNodeMethodLocal method call from 2.1.x.
 * <p/>
 *
 * @author Mircea.Markus@jboss.com
 * @since 2.2.0
 */
public class GetNodeCommand extends AbstractDataCommand
{
   public static final int METHOD_ID = 31;

   public GetNodeCommand(Fqn fqn)
   {
      this.fqn = fqn;
   }

   public GetNodeCommand()
   {
   }

   /**
    * Retrieves a {@link org.jboss.cache.Node} referenced by the specified Fqn.
    *
    * @param ctx invocation context
    * @return a Node, or null if the Fqn refers to a node that does not exist.
    */
   public Object perform(InvocationContext ctx)
   {
      return dataContainer.peek(fqn);
   }

   public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable
   {
      return visitor.visitGetNodeCommand(ctx, this);
   }

   public int getCommandId()
   {
      return METHOD_ID;
   }
}
