.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP OWNED" "" "2009-09-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP OWNED \- remove database objects owned by a database role

.SH SYNOPSIS
.sp
.nf
DROP OWNED BY \fIname\fR [, ...] [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP OWNED\fR drops all the objects in the current
database that are owned by one of the specified roles. Any
privileges granted to the given roles on objects in the current
database will also be revoked.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of a role whose objects will be dropped, and whose
privileges will be revoked.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the affected objects.
.TP
\fBRESTRICT\fR
Refuse to drop the objects owned by a role if any other database
objects depend on one of the affected objects. This is the default.
.SH "NOTES"
.PP
\fBDROP OWNED\fR is often used to prepare for the
removal of one or more roles. Because \fBDROP OWNED\fR
only affects the objects in the current database, it is usually
necessary to execute this command in each database that contains
objects owned by a role that is to be removed.
.PP
Using the CASCADE option might make the command
recurse to objects owned by other users.
.PP
The REASSIGN OWNED [\fBreassign_owned\fR(l)] command is an alternative that
reassigns the ownership of all the database objects owned by one or
more roles.
.SH "COMPATIBILITY"
.PP
The \fBDROP OWNED\fR statement is a
PostgreSQL extension.
.SH "SEE ALSO"
REASSIGN OWNED [\fBreassign_owned\fR(l)], DROP ROLE [\fBdrop_role\fR(l)]
