.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "COMMENT" "" "2009-02-03" "SQL - Language Statements" "SQL Commands"
.SH NAME
COMMENT \- define or change the comment of an object

.SH SYNOPSIS
.sp
.nf
COMMENT ON
{
  TABLE \fIobject_name\fR |
  COLUMN \fItable_name\fR.\fIcolumn_name\fR |
  AGGREGATE \fIagg_name\fR (\fIagg_type\fR [, ...] ) |
  CAST (\fIsourcetype\fR AS \fItargettype\fR) |
  CONSTRAINT \fIconstraint_name\fR ON \fItable_name\fR |
  CONVERSION \fIobject_name\fR |
  DATABASE \fIobject_name\fR |
  DOMAIN \fIobject_name\fR |
  FUNCTION \fIfunc_name\fR ( [ [ \fIargmode\fR ] [ \fIargname\fR ] \fIargtype\fR [, ...] ] ) |
  INDEX \fIobject_name\fR |
  LARGE OBJECT \fIlarge_object_oid\fR |
  OPERATOR \fIop\fR (\fIleftoperand_type\fR, \fIrightoperand_type\fR) |
  OPERATOR CLASS \fIobject_name\fR USING \fIindex_method\fR |
  OPERATOR FAMILY \fIobject_name\fR USING \fIindex_method\fR |
  [ PROCEDURAL ] LANGUAGE \fIobject_name\fR |
  ROLE \fIobject_name\fR |
  RULE \fIrule_name\fR ON \fItable_name\fR |
  SCHEMA \fIobject_name\fR |
  SEQUENCE \fIobject_name\fR |
  TABLESPACE \fIobject_name\fR |
  TEXT SEARCH CONFIGURATION \fIobject_name\fR |
  TEXT SEARCH DICTIONARY \fIobject_name\fR |
  TEXT SEARCH PARSER \fIobject_name\fR |
  TEXT SEARCH TEMPLATE \fIobject_name\fR |
  TRIGGER \fItrigger_name\fR ON \fItable_name\fR |
  TYPE \fIobject_name\fR |
  VIEW \fIobject_name\fR
} IS \fI'text'\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCOMMENT\fR stores a comment about a database object.
.PP
To modify a comment, issue a new \fBCOMMENT\fR command for the
same object. Only one comment string is stored for each object.
To remove a comment, write NULL in place of the text
string.
Comments are automatically dropped when the object is dropped.
.PP
Comments can be viewed using \fBpsql\fR's 
\fB\\d\fR family of commands.
Other user interfaces to retrieve comments can be built atop
the same built-in functions that \fBpsql\fR uses, namely
\fBobj_description\fR, \fBcol_description\fR,
and \fBshobj_description\fR 
(see in the documentation).
.SH "PARAMETERS"
.TP
\fB\fIobject_name\fB\fR
.TP
\fB\fItable_name.column_name\fB\fR
.TP
\fB\fIagg_name\fB\fR
.TP
\fB\fIconstraint_name\fB\fR
.TP
\fB\fIfunc_name\fB\fR
.TP
\fB\fIop\fB\fR
.TP
\fB\fIrule_name\fB\fR
.TP
\fB\fItrigger_name\fB\fR
The name of the object to be commented. Names of tables,
aggregates, domains, functions, indexes, operators, operator classes,
operator families, sequences, text search objects, types, and views can
be schema-qualified.
.TP
\fB\fIagg_type\fB\fR
An input data type on which the aggregate function operates.
To reference a zero-argument aggregate function, write *
in place of the list of input data types.
.TP
\fB\fIsourcetype\fB\fR
The name of the source data type of the cast.
.TP
\fB\fItargettype\fB\fR
The name of the target data type of the cast.
.TP
\fB\fIargmode\fB\fR
The mode of a function argument: either IN, OUT,
or INOUT. If omitted, the default is IN.
Note that \fBCOMMENT ON FUNCTION\fR does not actually pay
any attention to OUT arguments, since only the input
arguments are needed to determine the function's identity.
So it is sufficient to list the IN and INOUT
arguments.
.TP
\fB\fIargname\fB\fR
The name of a function argument.
Note that \fBCOMMENT ON FUNCTION\fR does not actually pay
any attention to argument names, since only the argument data
types are needed to determine the function's identity.
.TP
\fB\fIargtype\fB\fR
The data type(s) of the function's arguments (optionally 
schema-qualified), if any.
.TP
\fB\fIlarge_object_oid\fB\fR
The OID of the large object.
.TP
\fBPROCEDURAL\fR
This is a noise word.
.TP
\fB\fItext\fB\fR
The new comment, written as a string literal; or NULL
to drop the comment.
.SH "NOTES"
.PP
There is presently no security mechanism for comments: any user
connected to a database can see all the comments for objects in
that database (although only superusers can change comments for
objects that they don't own). For shared objects such as
databases, roles, and tablespaces comments are stored globally
and any user connected to any database can see all the comments
for shared objects. Therefore, don't put security-critical
information in comments.
.SH "EXAMPLES"
.PP
Attach a comment to the table mytable:
.sp
.nf
COMMENT ON TABLE mytable IS 'This is my table.';
.sp
.fi
Remove it again:
.sp
.nf
COMMENT ON TABLE mytable IS NULL;
.sp
.fi
.PP
Some more examples:
.sp
.nf
COMMENT ON AGGREGATE my_aggregate (double precision) IS 'Computes sample variance';
COMMENT ON CAST (text AS int4) IS 'Allow casts from text to int4';
COMMENT ON COLUMN my_table.my_column IS 'Employee ID number';
COMMENT ON CONVERSION my_conv IS 'Conversion to UTF8';
COMMENT ON DATABASE my_database IS 'Development Database';
COMMENT ON DOMAIN my_domain IS 'Email Address Domain';
COMMENT ON FUNCTION my_function (timestamp) IS 'Returns Roman Numeral';
COMMENT ON INDEX my_index IS 'Enforces uniqueness on employee ID';
COMMENT ON LANGUAGE plpython IS 'Python support for stored procedures';
COMMENT ON LARGE OBJECT 346344 IS 'Planning document';
COMMENT ON OPERATOR ^ (text, text) IS 'Performs intersection of two texts';
COMMENT ON OPERATOR - (NONE, text) IS 'This is a prefix operator on text';
COMMENT ON OPERATOR CLASS int4ops USING btree IS '4 byte integer operators for btrees';
COMMENT ON OPERATOR FAMILY integer_ops USING btree IS 'all integer operators for btrees';
COMMENT ON ROLE my_role IS 'Administration group for finance tables';
COMMENT ON RULE my_rule ON my_table IS 'Logs updates of employee records';
COMMENT ON SCHEMA my_schema IS 'Departmental data';
COMMENT ON SEQUENCE my_sequence IS 'Used to generate primary keys';
COMMENT ON TABLE my_schema.my_table IS 'Employee Information';
COMMENT ON TABLESPACE my_tablespace IS 'Tablespace for indexes';
COMMENT ON TEXT SEARCH CONFIGURATION my_config IS 'Special word filtering';
COMMENT ON TEXT SEARCH DICTIONARY swedish IS 'Snowball stemmer for swedish language';
COMMENT ON TEXT SEARCH PARSER my_parser IS 'Splits text into words';
COMMENT ON TEXT SEARCH TEMPLATE snowball IS 'Snowball stemmer';
COMMENT ON TRIGGER my_trigger ON my_table IS 'Used for RI';
COMMENT ON TYPE complex IS 'Complex number data type';
COMMENT ON VIEW my_view IS 'View of departmental costs';
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBCOMMENT\fR command in the SQL standard.
