.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE OPERATOR FAMILY" "" "2008-09-19" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE OPERATOR FAMILY \- define a new operator family

.SH SYNOPSIS
.sp
.nf
CREATE OPERATOR FAMILY \fIname\fR USING \fIindex_method\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE OPERATOR FAMILY\fR creates a new operator family.
An operator family defines a collection of related operator classes,
and perhaps some additional operators and support functions that are
compatible with these operator classes but not essential for the
functioning of any individual index. (Operators and functions that
are essential to indexes should be grouped within the relevant operator
class, rather than being ``loose'' in the operator family.
Typically, single-data-type operators are bound to operator classes,
while cross-data-type operators can be loose in an operator family
containing operator classes for both data types.)
.PP
The new operator family is initially empty. It should be populated
by issuing subsequent \fBCREATE OPERATOR CLASS\fR commands
to add contained operator classes, and optionally
\fBALTER OPERATOR FAMILY\fR commands to add ``loose''
operators and their corresponding support functions.
.PP
If a schema name is given then the operator family is created in the
specified schema. Otherwise it is created in the current schema.
Two operator families in the same schema can have the same name only if they
are for different index methods.
.PP
The user who defines an operator family becomes its owner. Presently,
the creating user must be a superuser. (This restriction is made because
an erroneous operator family definition could confuse or even crash the
server.)
.PP
Refer to in the documentation for further information.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name of the operator family to be created. The name can be
schema-qualified.
.TP
\fB\fIindex_method\fB\fR
The name of the index method this operator family is for.
.SH "COMPATIBILITY"
.PP
\fBCREATE OPERATOR FAMILY\fR is a
PostgreSQL extension. There is no
\fBCREATE OPERATOR FAMILY\fR statement in the SQL
standard.
.SH "SEE ALSO"
ALTER OPERATOR FAMILY [\fBalter_operator_family\fR(l)], DROP OPERATOR FAMILY [\fBdrop_operator_family\fR(l)], CREATE OPERATOR CLASS [\fBcreate_operator_class\fR(l)], ALTER OPERATOR CLASS [\fBalter_operator_class\fR(l)], DROP OPERATOR CLASS [\fBdrop_operator_class\fR(l)]
