.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "NOTIFY" "" "2010-05-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
NOTIFY \- generate a notification

.SH SYNOPSIS
.sp
.nf
NOTIFY \fIname\fR        
.sp
.fi
.SH "DESCRIPTION"
.PP
The \fBNOTIFY\fR command sends a notification event to each
client application that has previously executed
\fBLISTEN \fIname\fB\fR
for the specified notification name in the current database.
.PP
\fBNOTIFY\fR provides a simple form of signal or
interprocess communication mechanism for a collection of processes
accessing the same PostgreSQL database.
Higher-level mechanisms can be built by using tables in the database to
pass additional data (beyond a mere notification name) from notifier to
listener(s).
.PP
The information passed to the client for a notification event includes the notification
name and the notifying session's server process PID. It is up to the
database designer to define the notification names that will be used in a given
database and what each one means.
.PP
Commonly, the notification name is the same as the name of some table in
the database, and the notify event essentially means, ``I changed this table,
take a look at it to see what's new''. But no such association is enforced by
the \fBNOTIFY\fR and \fBLISTEN\fR commands. For
example, a database designer could use several different notification names
to signal different sorts of changes to a single table.
.PP
When \fBNOTIFY\fR is used to signal the occurrence of changes
to a particular table, a useful programming technique is to put the
\fBNOTIFY\fR in a rule that is triggered by table updates.
In this way, notification happens automatically when the table is changed,
and the application programmer can't accidentally forget to do it.
.PP
\fBNOTIFY\fR interacts with SQL transactions in some important
ways. Firstly, if a \fBNOTIFY\fR is executed inside a
transaction, the notify events are not delivered until and unless the
transaction is committed. This is appropriate, since if the transaction
is aborted, all the commands within it have had no
effect, including \fBNOTIFY\fR. But it can be disconcerting if one
is expecting the notification events to be delivered immediately. Secondly, if
a listening session receives a notification signal while it is within a transaction,
the notification event will not be delivered to its connected client until just
after the transaction is completed (either committed or aborted). Again, the
reasoning is that if a notification were delivered within a transaction that was
later aborted, one would want the notification to be undone somehow \(em
but
the server cannot ``take back'' a notification once it has sent it to the client.
So notification events are only delivered between transactions. The upshot of this
is that applications using \fBNOTIFY\fR for real-time signaling
should try to keep their transactions short.
.PP
\fBNOTIFY\fR behaves like Unix signals in one important
respect: if the same notification name is signaled multiple times in quick
succession, recipients may get only one notification event for several executions
of \fBNOTIFY\fR. So it is a bad idea to depend on the number
of notifications received. Instead, use \fBNOTIFY\fR to wake up
applications that need to pay attention to something, and use a database
object (such as a sequence) to keep track of what happened or how many times
it happened.
.PP
It is common for a client that executes \fBNOTIFY\fR
to be listening on the same notification name itself. In that case
it will get back a notification event, just like all the other
listening sessions. Depending on the application logic, this could
result in useless work, for example, reading a database table to
find the same updates that that session just wrote out. It is
possible to avoid such extra work by noticing whether the notifying
session's server process PID (supplied in the
notification event message) is the same as one's own session's
PID (available from \fBlibpq\fR). When they
are the same, the notification event is one's own work bouncing
back, and can be ignored. (Despite what was said in the preceding
paragraph, this is a safe technique.
PostgreSQL keeps self-notifications
separate from notifications arriving from other sessions, so you
cannot miss an outside notification by ignoring your own
notifications.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
Name of the notification to be signaled (any identifier).
.SH "EXAMPLES"
.PP
Configure and execute a listen/notify sequence from
\fBpsql\fR:
.sp
.nf
LISTEN virtual;
NOTIFY virtual;
Asynchronous notification "virtual" received from server process with PID 8448.
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBNOTIFY\fR statement in the SQL
standard.
.SH "SEE ALSO"
LISTEN [\fBlisten\fR(l)], UNLISTEN [\fBunlisten\fR(l)]
