.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER FUNCTION" "" "2009-09-04" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER FUNCTION \- change the definition of a function

.SH SYNOPSIS
.sp
.nf
ALTER FUNCTION \fIname\fR ( [ [ \fIargmode\fR ] [ \fIargname\fR ] \fIargtype\fR [, ...] ] )
    \fIaction\fR [, ... ] [ RESTRICT ]
ALTER FUNCTION \fIname\fR ( [ [ \fIargmode\fR ] [ \fIargname\fR ] \fIargtype\fR [, ...] ] )
    RENAME TO \fInew_name\fR
ALTER FUNCTION \fIname\fR ( [ [ \fIargmode\fR ] [ \fIargname\fR ] \fIargtype\fR [, ...] ] )
    OWNER TO \fInew_owner\fR
ALTER FUNCTION \fIname\fR ( [ [ \fIargmode\fR ] [ \fIargname\fR ] \fIargtype\fR [, ...] ] )
    SET SCHEMA \fInew_schema\fR

where \fIaction\fR is one of:

    CALLED ON NULL INPUT | RETURNS NULL ON NULL INPUT | STRICT
    IMMUTABLE | STABLE | VOLATILE
    [ EXTERNAL ] SECURITY INVOKER | [ EXTERNAL ] SECURITY DEFINER
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER FUNCTION\fR changes the definition of a
function.
.PP
You must own the function to use \fBALTER FUNCTION\fR.
To change a function's schema, you must also have CREATE
privilege on the new schema.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the function's schema. (These restrictions enforce that altering the owner
doesn't do anything you couldn't do by dropping and recreating the function.
However, a superuser can alter ownership of any function anyway.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing function.
.TP
\fB\fIargmode\fB\fR
The mode of an argument: either IN, OUT,
or INOUT. If omitted, the default is IN.
Note that \fBALTER FUNCTION\fR does not actually pay
any attention to OUT arguments, since only the input
arguments are needed to determine the function's identity.
So it is sufficient to list the IN and INOUT
arguments.
.TP
\fB\fIargname\fB\fR
The name of an argument.
Note that \fBALTER FUNCTION\fR does not actually pay
any attention to argument names, since only the argument data
types are needed to determine the function's identity.
.TP
\fB\fIargtype\fB\fR
The data type(s) of the function's arguments (optionally 
schema-qualified), if any.
.TP
\fB\fInew_name\fB\fR
The new name of the function.
.TP
\fB\fInew_owner\fB\fR
The new owner of the function. Note that if the function is
marked SECURITY DEFINER, it will subsequently
execute as the new owner.
.TP
\fB\fInew_schema\fB\fR
The new schema for the function.
.TP
\fBCALLED ON NULL INPUT\fR
.TP
\fBRETURNS NULL ON NULL INPUT\fR
.TP
\fBSTRICT\fR
CALLED ON NULL INPUT changes the function so
that it will be invoked when some or all of its arguments are
null. RETURNS NULL ON NULL INPUT or
STRICT changes the function so that it is not
invoked if any of its arguments are null; instead, a null result
is assumed automatically. See CREATE FUNCTION [\fBcreate_function\fR(l)] for more information.
.TP
\fBIMMUTABLE\fR
.TP
\fBSTABLE\fR
.TP
\fBVOLATILE\fR
Change the volatility of the function to the specified setting.
See CREATE FUNCTION [\fBcreate_function\fR(l)] for details.
.TP
\fB[ EXTERNAL ] SECURITY INVOKER\fR
.TP
\fB[ EXTERNAL ] SECURITY DEFINER\fR
Change whether the function is a security definer or not. The
key word EXTERNAL is ignored for SQL
conformance. See CREATE FUNCTION [\fBcreate_function\fR(l)] for more information about
this capability.
.TP
\fBRESTRICT\fR
Ignored for conformance with the SQL standard.
.SH "EXAMPLES"
.PP
To rename the function sqrt for type
\fBinteger\fR to square_root:
.sp
.nf
ALTER FUNCTION sqrt(integer) RENAME TO square_root;
.sp
.fi
.PP
To change the owner of the function sqrt for type
\fBinteger\fR to joe:
.sp
.nf
ALTER FUNCTION sqrt(integer) OWNER TO joe;
.sp
.fi
.PP
To change the schema of the function sqrt for type
\fBinteger\fR to maths:
.sp
.nf
ALTER FUNCTION sqrt(integer) SET SCHEMA maths;
.sp
.fi
.SH "COMPATIBILITY"
.PP
This statement is partially compatible with the \fBALTER
FUNCTION\fR statement in the SQL standard. The standard allows more
properties of a function to be modified, but does not provide the
ability to rename a function, make a function a security definer,
or change the owner, schema, or volatility of a function. The standard also
requires the RESTRICT key word, which is optional in
PostgreSQL.
.SH "SEE ALSO"
CREATE FUNCTION [\fBcreate_function\fR(l)], DROP FUNCTION [\fBdrop_function\fR(l)]
