.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_execute_plan" "" "2010-03-12" "" "PostgreSQL 8.1.20 Documentation"
.SH NAME
SPI_execute_plan \- execute a plan prepared by SPI_prepare

.SH SYNOPSIS
.sp
.nf
int SPI_execute_plan(void * \fIplan\fR, Datum * \fIvalues\fR, const char * \fInulls\fR,
                     bool \fIread_only\fR, long \fIcount\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_execute_plan\fR executes a plan prepared by
\fBSPI_prepare\fR. \fIread_only\fR and
\fIcount\fR have the same interpretation as in
\fBSPI_execute\fR.
.SH "ARGUMENTS"
.TP
\fBvoid * \fIplan\fB\fR
execution plan (returned by \fBSPI_prepare\fR)
.TP
\fBDatum * \fIvalues\fB\fR
An array of actual parameter values. Must have same length as the
plan's number of arguments.
.TP
\fBconst char * \fInulls\fB\fR
An array describing which parameters are null. Must have same length as
the plan's number of arguments.
n indicates a null value (entry in
\fIvalues\fR will be ignored); a space indicates a
nonnull value (entry in \fIvalues\fR is valid).

If \fInulls\fR is \fBNULL\fR then
\fBSPI_execute_plan\fR assumes that no parameters are
null.
.TP
\fBbool \fIread_only\fB\fR
true for read-only execution
.TP
\fBlong \fIcount\fB\fR
maximum number of rows to process or return
.SH "RETURN VALUE"
.PP
The return value is the same as for \fBSPI_execute\fR,
with the following additional possible error (negative) results:
.TP
\fBSPI_ERROR_ARGUMENT\fR
if \fIplan\fR is \fBNULL\fR or
\fIcount\fR is less than 0
.TP
\fBSPI_ERROR_PARAM\fR
if \fIvalues\fR is \fBNULL\fR and
\fIplan\fR was prepared with some parameters
.PP
.PP
SPI_processed and
SPI_tuptable are set as in
\fBSPI_execute\fR if successful.
.SH "NOTES"
.PP
If one of the objects (a table, function, etc.) referenced by the
prepared plan is dropped during the session then the result of
\fBSPI_execute_plan\fR for this plan will be unpredictable.
