.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "SPI_returntuple" "" "2008-06-08" "" "PostgreSQL 8.1.13 Documentation"
.SH NAME
SPI_returntuple \- prepare to return a tuple as a Datum

.SH SYNOPSIS
.sp
.nf
HeapTupleHeader SPI_returntuple(HeapTuple \fIrow\fR, TupleDesc \fIrowdesc\fR)
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBSPI_returntuple\fR makes a copy of a row in
the upper executor context, returning it in the form of a row type \fBDatum\fR.
The returned pointer need only be converted to \fBDatum\fR via \fBPointerGetDatum\fR
before returning.
.PP
Note that this should be used for functions that are declared to return
composite types. It is not used for triggers; use
\fBSPI_copytuple\fR for returning a modified row in a trigger.
.SH "ARGUMENTS"
.TP
\fBHeapTuple \fIrow\fB\fR
row to be copied
.TP
\fBTupleDesc \fIrowdesc\fB\fR
descriptor for row (pass the same descriptor each time for most
effective caching)
.SH "RETURN VALUE"
.PP
\fBHeapTupleHeader\fR pointing to copied row;
\fBNULL\fR only if
\fIrow\fR or \fIrowdesc\fR is
\fBNULL\fR
