.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "GRANT" "" "2010-10-01" "SQL - Language Statements" "SQL Commands"
.SH NAME
GRANT \- define access privileges

.SH SYNOPSIS
.sp
.nf
GRANT { { SELECT | INSERT | UPDATE | DELETE | RULE | REFERENCES | TRIGGER }
    [,...] | ALL [ PRIVILEGES ] }
    ON [ TABLE ] \fItablename\fR [, ...]
    TO { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { { CREATE | TEMPORARY | TEMP } [,...] | ALL [ PRIVILEGES ] }
    ON DATABASE \fIdbname\fR [, ...]
    TO { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { EXECUTE | ALL [ PRIVILEGES ] }
    ON FUNCTION \fIfuncname\fR ([\fItype\fR, ...]) [, ...]
    TO { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { USAGE | ALL [ PRIVILEGES ] }
    ON LANGUAGE \fIlangname\fR [, ...]
    TO { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { { CREATE | USAGE } [,...] | ALL [ PRIVILEGES ] }
    ON SCHEMA \fIschemaname\fR [, ...]
    TO { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]

GRANT { CREATE | ALL [ PRIVILEGES ] }
    ON TABLESPACE \fItablespacename\fR [, ...]
    TO { \fIusername\fR | GROUP \fIgroupname\fR | PUBLIC } [, ...] [ WITH GRANT OPTION ]
.sp
.fi
.SH "DESCRIPTION"
.PP
The \fBGRANT\fR command gives specific privileges on
an object (table, view, sequence, database, function,
procedural language, schema, or tablespace) to
one or more users or groups of users. These privileges are added
to those already granted, if any.
.PP
The key word PUBLIC indicates that the
privileges are to be granted to all users, including those that may
be created later. PUBLIC may be thought of as an
implicitly defined group that always includes all users.
Any particular user will have the sum
of privileges granted directly to him, privileges granted to any group he
is presently a member of, and privileges granted to
PUBLIC.
.PP
If WITH GRANT OPTION is specified, the recipient
of the privilege may in turn grant it to others. Without a grant
option, the recipient cannot do that. At present, grant options can
only be granted to individual users, not to groups or
PUBLIC.
.PP
There is no need to grant privileges to the owner of an object
(usually the user that created it),
as the owner has all privileges by default. (The owner could,
however, choose to revoke some of his own privileges for safety.)
The right to drop an object, or to alter its definition in any way is
not described by a grantable privilege; it is inherent in the owner,
and cannot be granted or revoked. The owner implicitly has all grant
options for the object, too.
.PP
Depending on the type of object, the initial default privileges may
include granting some privileges to PUBLIC.
The default is no public access for tables, schemas, and tablespaces;
TEMP table creation privilege for databases;
EXECUTE privilege for functions; and
USAGE privilege for languages.
The object owner may of course revoke these privileges. (For maximum
security, issue the \fBREVOKE\fR in the same transaction that
creates the object; then there is no window in which another user
may use the object.)
.PP
The possible privileges are:
.TP
\fBSELECT\fR
Allows SELECT [\fBselect\fR(l)] from
any column of the specified table, view, or sequence.
Also allows the use of
COPY [\fBcopy\fR(l)] TO.
This privilege is also needed to reference existing column values in
UPDATE [\fBupdate\fR(l)] or
DELETE [\fBdelete\fR(l)].
For sequences, this privilege also allows the use of the
\fBcurrval\fR function.
.TP
\fBINSERT\fR
Allows INSERT [\fBinsert\fR(l)] of a new
row into the specified table.
Also allows COPY [\fBcopy\fR(l)] FROM.
.TP
\fBUPDATE\fR
Allows UPDATE [\fBupdate\fR(l)] of any
column of the specified table.
(In practice, any nontrivial \fBUPDATE\fR command will require
SELECT privilege as well, since it must reference table
columns to determine which rows to update, and/or to compute new
values for columns.)
SELECT ... FOR UPDATE
also requires this privilege, in addition to the
SELECT privilege. For sequences, this
privilege allows the use of the \fBnextval\fR and
\fBsetval\fR functions.
.TP
\fBDELETE\fR
Allows DELETE [\fBdelete\fR(l)] of a row
from the specified table.
(In practice, any nontrivial \fBDELETE\fR command will require
SELECT privilege as well, since it must reference table
columns to determine which rows to delete.)
.TP
\fBRULE\fR
Allows the creation of a rule on the table/view. (See the CREATE RULE [\fBcreate_rule\fR(l)] statement.)
.TP
\fBREFERENCES\fR
To create a foreign key constraint, it is
necessary to have this privilege on both the referencing and
referenced tables.
.TP
\fBTRIGGER\fR
Allows the creation of a trigger on the specified table. (See the
CREATE TRIGGER [\fBcreate_trigger\fR(l)] statement.)
.TP
\fBCREATE\fR
For databases, allows new schemas to be created within the database.

For schemas, allows new objects to be created within the schema.
To rename an existing object, you must own the object \fBand\fR
have this privilege for the containing schema.

For tablespaces, allows tables and indexes to be created within the
tablespace, and allows databases to be created that have the tablespace
as their default tablespace. (Note that revoking this privilege
will not alter the placement of existing objects.)
.TP
\fBTEMPORARY\fR
.TP
\fBTEMP\fR
Allows temporary tables to be created while using the specified database.
.TP
\fBEXECUTE\fR
Allows the use of the specified function and the use of any
operators that are implemented on top of the function. This is
the only type of privilege that is applicable to functions.
(This syntax works for aggregate functions, as well.)
.TP
\fBUSAGE\fR
For procedural languages, allows the use of the specified language for
the creation of functions in that language. This is the only type
of privilege that is applicable to procedural languages.

For schemas, allows access to objects contained in the specified
schema (assuming that the objects' own privilege requirements are
also met). Essentially this allows the grantee to ``look up''
objects within the schema.
.TP
\fBALL PRIVILEGES\fR
Grant all of the available privileges at once.
The PRIVILEGES key word is optional in
PostgreSQL, though it is required by
strict SQL.
.PP
The privileges required by other commands are listed on the
reference page of the respective command.
.SH "NOTES"
.PP
The REVOKE [\fBrevoke\fR(l)] command is used
to revoke access privileges.
.PP
When a non-owner of an object attempts to \fBGRANT\fR privileges
on the object, the command will fail outright if the user has no
privileges whatsoever on the object. As long as some privilege is
available, the command will proceed, but it will grant only those
privileges for which the user has grant options. The \fBGRANT ALL
PRIVILEGES\fR forms will issue a warning message if no grant options are
held, while the other forms will issue a warning if grant options for
any of the privileges specifically named in the command are not held.
(In principle these statements apply to the object owner as well, but
since the owner is always treated as holding all grant options, the
cases can never occur.)
.PP
It should be noted that database superusers can access
all objects regardless of object privilege settings. This
is comparable to the rights of root in a Unix system.
As with root, it's unwise to operate as a superuser
except when absolutely necessary.
.PP
If a superuser chooses to issue a \fBGRANT\fR or \fBREVOKE\fR
command, the command is performed as though it were issued by the
owner of the affected object. In particular, privileges granted via
such a command will appear to have been granted by the object owner.
.PP
Currently, PostgreSQL does not support
granting or revoking privileges for individual columns of a table.
One possible workaround is to create a view having just the desired
columns and then grant privileges to that view.
.PP
Use \fBpsql\fR(1)'s \fB\\z\fR command
to obtain information about existing privileges, for example:
.sp
.nf
=> \\z mytable

                        Access privileges for database "lusitania"
 Schema |  Name   | Type  |                     Access privileges
--------+---------+-------+------------------------------------------------------------
 public | mytable | table | {miriam=arwdRxt/miriam,=r/miriam,"group todos=arw/miriam"}
(1 row)
.sp
.fi
The entries shown by \fB\\z\fR are interpreted thus:
.sp
.nf
              =xxxx -- privileges granted to PUBLIC
         uname=xxxx -- privileges granted to a user
   group gname=xxxx -- privileges granted to a group

                  r -- SELECT ("read")
                  w -- UPDATE ("write")
                  a -- INSERT ("append")
                  d -- DELETE
                  R -- RULE
                  x -- REFERENCES
                  t -- TRIGGER
                  X -- EXECUTE
                  U -- USAGE
                  C -- CREATE
                  T -- TEMPORARY
            arwdRxt -- ALL PRIVILEGES (for tables)
                  * -- grant option for preceding privilege

              /yyyy -- user who granted this privilege
.sp
.fi
The above example display would be seen by user miriam after
creating table mytable and doing
.sp
.nf
GRANT SELECT ON mytable TO PUBLIC;
GRANT SELECT, UPDATE, INSERT ON mytable TO GROUP todos;
.sp
.fi
.PP
If the ``Access privileges'' column is empty for a given object,
it means the object has default privileges (that is, its privileges column
is null). Default privileges always include all privileges for the owner,
and may include some privileges for PUBLIC depending on the
object type, as explained above. The first \fBGRANT\fR or
\fBREVOKE\fR on an object
will instantiate the default privileges (producing, for example,
{miriam=arwdRxt/miriam}) and then modify them per the
specified request.
.PP
Notice that the owner's implicit grant options are not marked in the
access privileges display. A * will appear only when
grant options have been explicitly granted to someone.
.SH "EXAMPLES"
.PP
Grant insert privilege to all users on table films:
.sp
.nf
GRANT INSERT ON films TO PUBLIC;
.sp
.fi
.PP
Grant all available privileges to user manuel on view
kinds:
.sp
.nf
GRANT ALL PRIVILEGES ON kinds TO manuel;
.sp
.fi
Note that while the above will indeed grant all privileges if executed by a
superuser or the owner of kinds, when executed by someone
else it will only grant those permissions for which the someone else has
grant options.
.SH "COMPATIBILITY"
.PP
According to the SQL standard, the PRIVILEGES
key word in ALL PRIVILEGES is required. The
SQL standard does not support setting the privileges on more than
one object per command.
.PP
PostgreSQL allows an object owner to revoke his
own ordinary privileges: for example, a table owner can make the table
read-only to himself by revoking his own INSERT, UPDATE, and DELETE
privileges. This is not possible according to the SQL standard. The
reason is that PostgreSQL treats the owner's
privileges as having been granted by the owner to himself; therefore he
can revoke them too. In the SQL standard, the owner's privileges are
granted by an assumed entity ``_SYSTEM''. Not being
``_SYSTEM'', the owner cannot revoke these rights.
.PP
The SQL standard allows setting privileges for individual columns
within a table:
.sp
.nf
GRANT \fIprivileges\fR
    ON \fItable\fR [ ( \fIcolumn\fR [, ...] ) ] [, ...]
    TO { PUBLIC | \fIusername\fR [, ...] } [ WITH GRANT OPTION ]
.sp
.fi
.PP
The SQL standard provides for a USAGE privilege
on other kinds of objects: character sets, collations,
translations, domains.
.PP
The RULE privilege, and privileges on
databases, tablespaces, schemas, languages, and sequences are
PostgreSQL extensions.
.SH "SEE ALSO"
.PP
REVOKE [\fBrevoke\fR(l)]
