.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "REINDEX" "" "2010-03-12" "SQL - Language Statements" "SQL Commands"
.SH NAME
REINDEX \- rebuild indexes

.SH SYNOPSIS
.sp
.nf
REINDEX { DATABASE | TABLE | INDEX } \fIname\fR [ FORCE ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBREINDEX\fR rebuilds an index based on the data
stored in the table, replacing the old copy of the index. There are
two main reasons to use \fBREINDEX\fR:
.TP 0.2i
\(bu
An index has become corrupted, and no longer contains valid
data. Although in theory this should never happen, in
practice indexes may become corrupted due to software bugs or
hardware failures. \fBREINDEX\fR provides a
recovery method.
.TP 0.2i
\(bu
The index in question contains a lot of dead index pages that
are not being reclaimed. This can occur with B-tree indexes in
PostgreSQL under certain access
patterns. \fBREINDEX\fR provides a way to reduce
the space consumption of the index by writing a new version of
the index without the dead pages. See [XRef to ROUTINE-REINDEX] for more information.
.PP
.SH "PARAMETERS"
.TP
\fBDATABASE\fR
Recreate all system indexes of a specified database. Indexes on
user tables are not processed. Also, indexes on shared system
catalogs are skipped except in stand-alone mode (see below).
.TP
\fBTABLE\fR
Recreate all indexes of a specified table. If the table has a
secondary ``TOAST'' table, that is reindexed as well.
.TP
\fBINDEX\fR
Recreate a specified index.
.TP
\fB\fIname\fB\fR
The name of the specific database, table, or index to be
reindexed. Table and index names may be schema-qualified.
.TP
\fBFORCE\fR
This is an obsolete option; it is ignored if specified.
.SH "NOTES"
.PP
If you suspect corruption of an index on a user table, you can
simply rebuild that index, or all indexes on the table, using
\fBREINDEX INDEX\fR or \fBREINDEX
TABLE\fR. Another approach to dealing with a corrupted
user-table index is just to drop and recreate it. This may in fact
be preferable if you would like to maintain some semblance of
normal operation on the table meanwhile. \fBREINDEX\fR
acquires exclusive lock on the table, while \fBCREATE
INDEX\fR only locks out writes not reads of the table.
.PP
Things are more difficult if you need to recover from corruption of
an index on a system table. In this case it's important for the
system to not have used any of the suspect indexes itself.
(Indeed, in this sort of scenario you may find that server
processes are crashing immediately at start-up, due to reliance on
the corrupted indexes.) To recover safely, the server must be started
with the \fB-P\fR option, which prevents it from using
indexes for system catalog lookups.
.PP
One way to do this is to shut down the postmaster and start a stand-alone
PostgreSQL server
with the \fB-P\fR option included on its command line.
Then, \fBREINDEX DATABASE\fR,
\fBREINDEX TABLE\fR, or \fBREINDEX INDEX\fR can be
issued, depending on how much you want to reconstruct. If in
doubt, use \fBREINDEX DATABASE\fR to select
reconstruction of all system indexes in the database. Then quit
the standalone server session and restart the regular server.
See the \fBpostgres\fR(1) reference page for more
information about how to interact with the stand-alone server
interface.
.PP
Alternatively, a regular server session can be started with
\fB-P\fR included in its command line options.
The method for doing this varies across clients, but in all
\fBlibpq\fR-based clients, it is possible to set
the \fBPGOPTIONS\fR environment variable to -P
before starting the client. Note that while this method does not
require locking out other clients, it may still be wise to prevent
other users from connecting to the damaged database until repairs
have been completed.
.PP
If corruption is suspected in the indexes of any of the shared
system catalogs (\fBpg_database\fR,
\fBpg_group\fR, or
\fBpg_shadow\fR), then a standalone server
must be used to repair it. \fBREINDEX\fR will not process
shared catalogs in multiuser mode.
.PP
For all indexes except the shared system catalogs, \fBREINDEX\fR
is crash-safe and transaction-safe. \fBREINDEX\fR is not
crash-safe for shared indexes, which is why this case is disallowed
during normal operation. If a failure occurs while reindexing one
of these catalogs in standalone mode, it will not be possible to
restart the regular server until the problem is rectified. (The
typical symptom of a partially rebuilt shared index is ``index is not
a btree'' errors.)
.PP
Prior to PostgreSQL 7.4, \fBREINDEX
TABLE\fR did not automatically process TOAST tables, and so those had
to be reindexed by separate commands. This is still possible, but
redundant.
.SH "EXAMPLES"
.PP
Recreate the indexes on the table my_table:
.sp
.nf
REINDEX TABLE my_table;
.sp
.fi
.PP
Rebuild a single index:
.sp
.nf
REINDEX INDEX my_index;
.sp
.fi
.PP
Rebuild all system indexes in a particular database, without trusting them
to be valid already:
.sp
.nf
$ \fBexport PGOPTIONS="-P"\fR
$ \fBpsql broken_db\fR
...
broken_db=> REINDEX DATABASE broken_db;
broken_db=> \\q
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBREINDEX\fR command in the SQL standard.
