#!/bin/sh

EXTENSIONS=( "*.hh" "*.h" "*.cpp" "*.cc" "*.ll" "*.yy" )

function scan_directory
{
	for dir in `find "$1" -type d`; do
		# Ignore CVS directories
		if test `expr match "$dir" '.*CVS.*'` -eq 0
		then
			echo -n "Exploring $dir... "
			EXTRA_DIST='$(srcdir)/'"${dir#.*\/}/module.mk"
			FRAGMENT="${dir#.*\/}"
			pgadmin3_SOURCES=""
			SUBDIRS=""
			# Add immediate subdirectories to the SUBDIRS list
			for sub in `find "$dir" -maxdepth 1 -type d`; do
				if test $sub != $dir -a `expr match "$sub" '.*CVS.*'` -eq 0
				then
					SUBDIRS="$SUBDIRS\n"'include $(srcdir)/'"${sub#.*\/}/module.mk"
				fi
			done
			# Extensions to include
			for ext in "${EXTENSIONS[@]}"
			do
				for sub in `find "$dir" -maxdepth 1 -name "$ext"`; do
					pgadmin3_SOURCES="$pgadmin3_SOURCES \\ \n\t"'$(srcdir)/'"${sub#.*\/}"
				done
			done
			# Write module.mk in the current explored directory
			echo '#######################################################################' > $dir/module.mk
			echo '#' >> $dir/module.mk
			echo '# pgAdmin III - PostgreSQL Tools' >> $dir/module.mk
			echo '# $Id: pgadmin.sh,v 1.2 2008/07/03 12:07:59 pgunittest Exp $' >> $dir/module.mk
			echo '# Copyright (C) 2002 - 2008, The pgAdmin Development Team' >> $dir/module.mk
			echo '# This software is released under the Artistic Licence' >> $dir/module.mk
			echo '#' >> $dir/module.mk
			echo '# module.mk - pgadmin/'"$FRAGMENT"'/ Makefile fragment' >> $dir/module.mk
			echo '#' >> $dir/module.mk
			echo '#######################################################################' >> $dir/module.mk
			echo "" >> $dir/module.mk
			echo -e "pgadmin3_SOURCES +=$pgadmin3_SOURCES" >> $dir/module.mk
			echo "" >> $dir/module.mk
			echo -e "EXTRA_DIST += \\" >> $dir/module.mk
			echo -e "\t$EXTRA_DIST" >> $dir/module.mk
			echo -e "$SUBDIRS" >> $dir/module.mk
			echo "done"
		fi
	done	
}

scan_directory "include/pgscript"
scan_directory "pgscript"

# Export files for pgAdmin3

echo "Tarring and gzipping..."
tar --exclude="Makefile*" --exclude="*cvs*" --exclude="config*" \
	--exclude="stamp*" --exclude="CVS" -cvf pgAdmin3.tar \
	pgscript include/pgscript

gzip pgAdmin3.tar
echo "Tarred and gzipped"

echo -n "Deleting module.mk files... "
for src in `find "./" -name "*module.mk"`; do
	rm -f $src
done
echo "done"
