/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.util;

import com.microsoft.util.UtilDataConsumer;
import com.microsoft.util.UtilException;
import com.microsoft.util.UtilPacketizingDataConsumer;
import com.microsoft.util.UtilPagedTempBuffer;
import com.microsoft.util.UtilTempBuffer;
import com.microsoft.util.UtilTransliterator;
import com.microsoft.util.UtilTransliteratorForASCII;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;

public class UtilByteOrderedDataWriter {
    private static String footprint = "$Revision:   1.26  $";
    protected UtilDataConsumer dataConsumerObject;
    private boolean encodeInBigEndian;
    protected UtilTransliterator transliterator;
    protected byte[] staticByteArray;
    private int[] returnedLength;
    private UtilTempBuffer tempBuffer;
    private int _lenBytes;

    public UtilByteOrderedDataWriter(UtilDataConsumer utilDataConsumer) {
        this(utilDataConsumer, new UtilTransliteratorForASCII());
    }

    public UtilByteOrderedDataWriter(UtilDataConsumer utilDataConsumer, UtilTransliterator utilTransliterator) {
        this.dataConsumerObject = utilDataConsumer;
        this.encodeInBigEndian = true;
        this.transliterator = utilTransliterator;
        this.staticByteArray = new byte[256];
        this.returnedLength = new int[1];
    }

    public OutputStream getOutputStream(int n) throws UtilException {
        this._lenBytes = n;
        return new OutputStream(){
            private int totalLen;
            private int writtenSoFar;
            {
                this.totalLen = UtilByteOrderedDataWriter.this._lenBytes;
            }

            public void write(int n) throws IOException {
                if (this.writtenSoFar >= this.totalLen) {
                    throw new IOException();
                }
                try {
                    UtilByteOrderedDataWriter.this.writeInt8(n);
                    ++this.writtenSoFar;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }

            public void write(byte[] byArray, int n, int n2) throws IOException {
                int n3 = this.totalLen - this.writtenSoFar;
                try {
                    if (n2 > n3) {
                        UtilByteOrderedDataWriter.this.writeBytes(byArray, n, n3);
                        this.writtenSoFar = this.totalLen;
                        throw new IOException();
                    }
                    UtilByteOrderedDataWriter.this.writeBytes(byArray, n, n2);
                    this.writtenSoFar += n2;
                }
                catch (UtilException utilException) {
                    throw new IOException();
                }
            }
        };
    }

    public UtilTransliterator getTransliterator() {
        return this.transliterator;
    }

    public boolean isInBigEndian() {
        return this.encodeInBigEndian;
    }

    public void send() throws UtilException {
        this.dataConsumerObject.send();
    }

    private void setStreamWrites(boolean bl) {
        if (this.dataConsumerObject instanceof UtilPacketizingDataConsumer) {
            ((UtilPacketizingDataConsumer)this.dataConsumerObject).setSendPacketWhenFull(bl);
        }
    }

    public void setToBigEndian() {
        this.encodeInBigEndian = true;
    }

    public void setToLittleEndian() {
        this.encodeInBigEndian = false;
    }

    public void setTransliterator(UtilTransliterator utilTransliterator) {
        this.transliterator = utilTransliterator;
    }

    public int writeAsciiStreamWithLength16(InputStream inputStream, int n) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(inputStream, n, this.tempBuffer.getOutputStream());
            int n2 = this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n2;
        }
        int n3 = n * this.transliterator.getMaxBytesPerChar();
        this.writeInt16(n3);
        this.transliterator.encode(inputStream, n, this.getOutputStream(n3));
        this.setStreamWrites(false);
        return n3 + 2;
    }

    public int writeAsciiStreamWithLength32(InputStream inputStream, int n) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(inputStream, n, this.tempBuffer.getOutputStream());
            int n2 = this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n2;
        }
        int n3 = n * this.transliterator.getMaxBytesPerChar();
        this.writeInt32(n3);
        this.transliterator.encode(inputStream, n, this.getOutputStream(n3));
        this.setStreamWrites(false);
        return n3 + 4;
    }

    public int writeBytes(byte[] byArray) throws UtilException {
        if (byArray == null) {
            return 0;
        }
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, byArray.length);
        return byArray.length;
    }

    public int writeBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (byArray == null || n2 <= 0) {
            return 0;
        }
        this.dataConsumerObject.putArrayOfBytes(byArray, n, n2);
        return n2;
    }

    public int writeFillerBytes(byte by, int n) throws UtilException {
        int n2 = n > this.staticByteArray.length ? this.staticByteArray.length : n;
        int n3 = 0;
        while (n3 < n2) {
            this.staticByteArray[n3] = by;
            ++n3;
        }
        int n4 = n;
        while (n4 > 0) {
            n2 = Math.min(n4, this.staticByteArray.length);
            this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n2);
            n4 -= n2;
        }
        return n;
    }

    public int writeIEEE32BitFloat(float f) throws UtilException {
        this.writeInt32(Float.floatToIntBits(f));
        return 4;
    }

    public int writeIEEE64BitDouble(double d) throws UtilException {
        this.writeInt64(Double.doubleToLongBits(d));
        return 8;
    }

    public int writeInt16(int n) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(n >>> 8 & 0xFF);
            this.staticByteArray[1] = (byte)(n & 0xFF);
        } else {
            this.staticByteArray[0] = (byte)(n & 0xFF);
            this.staticByteArray[1] = (byte)(n >>> 8 & 0xFF);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 2);
        return 2;
    }

    public int writeInt32(int n) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(n >>> 24 & 0xFF);
            this.staticByteArray[1] = (byte)(n >>> 16 & 0xFF);
            this.staticByteArray[2] = (byte)(n >>> 8 & 0xFF);
            this.staticByteArray[3] = (byte)(n & 0xFF);
        } else {
            this.staticByteArray[0] = (byte)(n & 0xFF);
            this.staticByteArray[1] = (byte)(n >>> 8 & 0xFF);
            this.staticByteArray[2] = (byte)(n >>> 16 & 0xFF);
            this.staticByteArray[3] = (byte)(n >>> 24 & 0xFF);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 4);
        return 4;
    }

    public int writeInt64(long l) throws UtilException {
        if (this.encodeInBigEndian) {
            this.staticByteArray[0] = (byte)(l >>> 56 & 0xFFL);
            this.staticByteArray[1] = (byte)(l >>> 48 & 0xFFL);
            this.staticByteArray[2] = (byte)(l >>> 40 & 0xFFL);
            this.staticByteArray[3] = (byte)(l >>> 32 & 0xFFL);
            this.staticByteArray[4] = (byte)(l >>> 24 & 0xFFL);
            this.staticByteArray[5] = (byte)(l >>> 16 & 0xFFL);
            this.staticByteArray[6] = (byte)(l >>> 8 & 0xFFL);
            this.staticByteArray[7] = (byte)(l & 0xFFL);
        } else {
            this.staticByteArray[0] = (byte)(l & 0xFFL);
            this.staticByteArray[1] = (byte)(l >>> 8 & 0xFFL);
            this.staticByteArray[2] = (byte)(l >>> 16 & 0xFFL);
            this.staticByteArray[3] = (byte)(l >>> 24 & 0xFFL);
            this.staticByteArray[4] = (byte)(l >>> 32 & 0xFFL);
            this.staticByteArray[5] = (byte)(l >>> 40 & 0xFFL);
            this.staticByteArray[6] = (byte)(l >>> 48 & 0xFFL);
            this.staticByteArray[7] = (byte)(l >>> 56 & 0xFFL);
        }
        this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, 8);
        return 8;
    }

    public int writeInt8(int n) throws UtilException {
        this.dataConsumerObject.putByte((byte)n);
        return 1;
    }

    public int writeReaderWithLength16(Reader reader, int n) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
            int n2 = this.writeStreamWithLength16(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n2;
        }
        int n3 = n * this.transliterator.getMaxBytesPerChar();
        this.writeInt16(n3);
        this.transliterator.encode(reader, n, this.getOutputStream(n3));
        this.setStreamWrites(false);
        return n3 + 2;
    }

    public int writeReaderWithLength32(Reader reader, int n) throws UtilException {
        this.setStreamWrites(true);
        if (!this.transliterator.isFixedBytesPerChar()) {
            if (this.tempBuffer == null) {
                this.tempBuffer = new UtilPagedTempBuffer();
            }
            this.transliterator.encode(reader, n, this.tempBuffer.getOutputStream());
            int n2 = this.writeStreamWithLength32(this.tempBuffer.getInputStream(), (int)this.tempBuffer.getSize());
            this.tempBuffer.truncate();
            return n2;
        }
        int n3 = n * this.transliterator.getMaxBytesPerChar();
        this.writeInt32(n3);
        this.transliterator.encode(reader, n, this.getOutputStream(n3));
        this.setStreamWrites(false);
        return n3 + 4;
    }

    public int writeStreamWithLength16(InputStream inputStream, int n) throws UtilException {
        this.setStreamWrites(true);
        this.writeInt16(n);
        int n2 = n;
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, this.staticByteArray.length);
                int n4 = inputStream.read(this.staticByteArray, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n4);
                n2 -= n4;
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1000, iOException.toString());
        }
        this.setStreamWrites(false);
        return n + 2;
    }

    public int writeStreamWithLength32(InputStream inputStream, int n) throws UtilException {
        this.setStreamWrites(true);
        this.writeInt32(n);
        int n2 = n;
        try {
            while (n2 > 0) {
                int n3 = Math.min(n2, this.staticByteArray.length);
                int n4 = inputStream.read(this.staticByteArray, 0, n3);
                if (n4 == -1) {
                    throw new UtilException(1002);
                }
                this.dataConsumerObject.putArrayOfBytes(this.staticByteArray, 0, n4);
                n2 -= n4;
            }
        }
        catch (IOException iOException) {
            throw new UtilException(1000, iOException.toString());
        }
        this.setStreamWrites(false);
        return n + 4;
    }

    public int writeString(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n;
    }

    public int writeStringWithLength16(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt16(n);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n + 2;
    }

    public int writeStringWithLength32(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt32(n);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n + 4;
    }

    public int writeStringWithLength8(String string) throws UtilException {
        if (string == null) {
            return 0;
        }
        byte[] byArray = this.transliterator.encode(string, this.returnedLength);
        int n = this.returnedLength[0];
        this.writeInt8(n);
        this.dataConsumerObject.putArrayOfBytes(byArray, 0, n);
        return n + 1;
    }
}

