/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.jdbc.vprt;

import com.microsoft.jdbc.vprt.SSLexCharacterClass;
import com.microsoft.jdbc.vprt.SSLexDfaTableHeader;
import com.microsoft.jdbc.vprt.SSLexFinalState;
import com.microsoft.jdbc.vprt.SSLexKeyTable;
import com.microsoft.jdbc.vprt.SSLexLexeme;
import com.microsoft.jdbc.vprt.SSLexSubtable;
import com.microsoft.jdbc.vprt.SSLexTableHeader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Stack;

public class SSLexTable {
    private static String footprint = "$Revision:   1.2  $";
    public int SSLexTableHeaderSize = 36;
    public int SSLexDfaTableHeaderSize = 40;
    public int SSLexDfaKeywordTableHeaderSize = 40;
    public int SSLexDfaClassTableHeaderSize = 12;
    public int SSLexDfaClassTableEntryHeaderSize = 8;
    public Stack m_stack;
    public int m_classes;
    public int m_classMin;
    public int m_classMax;
    public SSLexFinalState[] m_final;
    public SSLexSubtable[] m_subTables;
    public SSLexKeyTable[] m_keyTables;
    public SSLexCharacterClass[] m_charClassTables;
    public final int SSLexStateInvalid = -1;

    public SSLexTable() {
        this.m_stack = new Stack();
    }

    public SSLexTable(String string) throws FileNotFoundException, IOException {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        int n4;
        int n5;
        int n6;
        int n7;
        this.m_classMin = Integer.MAX_VALUE;
        this.m_classMax = -134217726;
        this.m_stack = new Stack();
        byte[] byArray = new byte[512];
        FileInputStream fileInputStream = new FileInputStream(string);
        int n8 = fileInputStream.read(byArray, 0, this.SSLexTableHeaderSize);
        SSLexTableHeader sSLexTableHeader = new SSLexTableHeader();
        sSLexTableHeader.size = this.convertInt(byArray, 0);
        sSLexTableHeader.type = this.convertInt(byArray, 4);
        int n9 = 0;
        while (n9 < sSLexTableHeader.reserved.length) {
            sSLexTableHeader.reserved[n9] = this.convertInt(byArray, n9 * 4 + 8);
            ++n9;
        }
        this.m_subTables = new SSLexSubtable[sSLexTableHeader.size];
        int n10 = 0;
        while (n10 < sSLexTableHeader.size) {
            int n11;
            int n12;
            SSLexDfaTableHeader sSLexDfaTableHeader = new SSLexDfaTableHeader();
            n8 = fileInputStream.read(byArray, 0, this.SSLexDfaTableHeaderSize);
            sSLexDfaTableHeader.type = this.convertInt(byArray, 0);
            sSLexDfaTableHeader.size = this.convertInt(byArray, 4);
            n7 = 0;
            while (n7 < sSLexDfaTableHeader.reserved.length) {
                sSLexDfaTableHeader.reserved[n7] = this.convertInt(byArray, n7 * 4 + 8);
                ++n7;
            }
            byte[] byArray2 = new byte[sSLexDfaTableHeader.size];
            fileInputStream.read(byArray2, 0, sSLexDfaTableHeader.size - this.SSLexDfaTableHeaderSize);
            n6 = this.convertInt(byArray2, 0);
            n5 = this.convertInt(byArray2, 4);
            n4 = this.convertInt(byArray2, 8);
            int n13 = this.convertInt(byArray2, 12);
            n13 -= this.SSLexDfaTableHeaderSize;
            objectArray = new int[n6 * 3];
            n3 = 0;
            n2 = n4 -= this.SSLexDfaTableHeaderSize;
            n = 0;
            while (n < n6) {
                int n14 = this.convertInt(byArray2, n2);
                n3 += this.convertInt(byArray2, n14 -= this.SSLexDfaTableHeaderSize) * 3 + 1;
                n2 += 4;
                ++n;
            }
            int[] nArray = new int[n3];
            n2 = n4;
            int n15 = 0;
            int n16 = 0;
            while (n16 < n6) {
                n12 = this.convertInt(byArray2, n2);
                n3 = this.convertInt(byArray2, n12 -= this.SSLexDfaTableHeaderSize);
                n12 += 4;
                nArray[n15++] = n3;
                n11 = 0;
                while (n11 < n3) {
                    nArray[n15++] = this.convertInt(byArray2, n12);
                    nArray[n15++] = this.convertInt(byArray2, n12 += 4);
                    nArray[n15++] = this.convertInt(byArray2, n12 += 4);
                    n12 += 4;
                    ++n11;
                }
                n2 += 4;
                ++n16;
            }
            n12 = n13;
            n11 = 0;
            int n17 = 0;
            while (n17 < n6) {
                int n18 = n12;
                objectArray[n11++] = (String)this.convertInt(byArray2, n18);
                objectArray[n11++] = (String)this.convertInt(byArray2, n18 += 4);
                objectArray[n11++] = (String)this.convertInt(byArray2, n18 += 4);
                n12 += 28;
                ++n17;
            }
            this.m_subTables[n10] = new SSLexSubtable(n6, nArray, (int[])objectArray);
            ++n10;
        }
        int n19 = sSLexTableHeader.reserved[0];
        if (n19 != 0) {
            this.m_keyTables = new SSLexKeyTable[n19];
        }
        n7 = 0;
        while (n7 < n19) {
            n8 = fileInputStream.read(byArray, 0, this.SSLexDfaKeywordTableHeaderSize);
            int n20 = this.convertInt(byArray, 0);
            n6 = this.convertInt(byArray, 4);
            byte[] byArray3 = new byte[n20];
            n8 = fileInputStream.read(byArray3, 0, n20 - this.SSLexDfaKeywordTableHeaderSize);
            n4 = 0;
            int[] nArray = new int[n6 * 3];
            objectArray = new String[n6];
            n3 = 0;
            while (n3 < n6) {
                String string2;
                n2 = 3 * n3;
                nArray[n2] = this.convertInt(byArray3, n4);
                nArray[n2 + 1] = byArray3[n4 + 4] == 0 ? 0 : 1;
                nArray[n2 + 2] = this.convertInt(byArray3, n4 + 13);
                n = this.convertInt(byArray3, n4 + 5) - this.SSLexDfaKeywordTableHeaderSize;
                n8 = 0;
                int n21 = n;
                while (byArray3[n21] != 0) {
                    ++n8;
                    ++n21;
                }
                objectArray[n3] = string2 = new String(byArray3, n, n8);
                n4 += 41;
                ++n3;
            }
            this.m_keyTables[n7] = new SSLexKeyTable(nArray, (String[])objectArray);
            ++n7;
        }
        this.m_classes = sSLexTableHeader.reserved[1];
        if (this.m_classes != 0) {
            this.m_charClassTables = new SSLexCharacterClass[this.m_classes];
        }
        int n22 = 0;
        while (n22 < this.m_classes) {
            n8 = fileInputStream.read(byArray, 0, this.SSLexDfaClassTableHeaderSize);
            n6 = this.convertInt(byArray, 0);
            n5 = this.convertInt(byArray, 4);
            n4 = this.convertInt(byArray, 8);
            int n23 = n4 * this.SSLexDfaClassTableEntryHeaderSize;
            int n24 = n4 * 2;
            byte[] byArray4 = new byte[n23];
            n8 = fileInputStream.read(byArray4, 0, n23);
            int[] nArray = new int[n24];
            n = 0;
            while (n < n24) {
                nArray[n] = this.convertInt(byArray4, n * 4);
                ++n;
            }
            this.m_charClassTables[n22] = new SSLexCharacterClass(n4, n6, n5, nArray);
            if (n6 < this.m_classMin) {
                this.m_classMin = n6;
            }
            if (n6 > this.m_classMax) {
                this.m_classMax = n6;
            }
            if (n5 < this.m_classMin) {
                this.m_classMax = n5;
            }
            if (n5 > this.m_classMax) {
                this.m_classMax = n5;
            }
            ++n22;
        }
        this.pushSubtable(0);
    }

    public int convertInt(byte[] byArray, int n) {
        return byArray[n + 3] << 24 & 0xFF000000 | byArray[n + 2] << 16 & 0xFF0000 | byArray[n + 1] << 8 & 0xFF00 | byArray[n] & 0xFF;
    }

    public void findKeyword(SSLexLexeme sSLexLexeme) {
        int n = 0;
        int n2 = 0;
        n = this.m_keyTables[0].m_keys.length;
        while (n > n2) {
            int n3 = n2 + (n - n2) / 2;
            String string = this.m_keyTables[0].m_keys[n3];
            String string2 = new String(sSLexLexeme.lexeme());
            int n4 = this.m_keyTables[0].m_index[n3 * 3 + 1] == 1 ? string2.toLowerCase().compareTo(string) : string2.compareTo(string);
            if (n4 < 0) {
                if (n2 == n3) break;
                n = n3;
                continue;
            }
            if (n4 == 0) {
                sSLexLexeme.setToken(this.m_keyTables[0].m_index[n3 * 3]);
                return;
            }
            if (n == n3 + 1) break;
            n2 = n3;
        }
    }

    public void gotoSubtable(int n) {
        this.m_stack.pop();
        this.m_stack.push(this.m_subTables[n]);
    }

    public int lookup(int n, int n2) {
        SSLexSubtable sSLexSubtable = (SSLexSubtable)this.m_stack.peek();
        return sSLexSubtable.lookup(n, n2);
    }

    public SSLexFinalState lookupFinal(int n) {
        SSLexSubtable sSLexSubtable = (SSLexSubtable)this.m_stack.peek();
        return sSLexSubtable.lookupFinal(n);
    }

    public void popSubtable() {
        this.m_stack.pop();
    }

    public void pushSubtable(int n) {
        this.m_stack.push(this.m_subTables[n]);
    }

    boolean translateClass(char[] cArray) {
        char c = cArray[0];
        if (c < this.m_classMin || c > this.m_classMax) {
            return false;
        }
        int n = 0;
        while (n < this.m_classes) {
            if (this.m_charClassTables[n].translate(cArray)) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

