/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.example;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.postgresql.pljava.ResultSetProvider;

public class ComplexReturn
implements ResultSetProvider {
    private final int m_base;
    private final int m_increment;

    public ComplexReturn(int n, int n2) {
        this.m_base = n;
        this.m_increment = n2;
    }

    public boolean assignRowValues(ResultSet resultSet, int n) throws SQLException {
        if (n >= 12) {
            return false;
        }
        resultSet.updateInt(1, this.m_base);
        resultSet.updateInt(2, this.m_base + this.m_increment * n);
        resultSet.updateTimestamp(3, new Timestamp(System.currentTimeMillis()));
        return true;
    }

    public void close() {
    }

    public static ResultSetProvider setReturn(int n, int n2) throws SQLException {
        return new ComplexReturn(n, n2);
    }

    public static boolean complexReturn(int n, int n2, ResultSet resultSet) throws SQLException {
        resultSet.updateInt(1, n);
        resultSet.updateInt(2, n + n2);
        resultSet.updateTimestamp(3, new Timestamp(System.currentTimeMillis()));
        return true;
    }

    public static String makeString(ResultSet resultSet) throws SQLException {
        int n = resultSet.getInt(1);
        int n2 = resultSet.getInt(2);
        Timestamp timestamp = resultSet.getTimestamp(3);
        return "Base = \"" + n + "\", incbase = \"" + n2 + "\", ctime = \"" + timestamp + "\"";
    }
}

