/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.internal;

import java.sql.SQLException;
import java.util.HashMap;
import org.postgresql.pljava.SavepointListener;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.PgSavepoint;

class SubXactListener {
    private static final HashMap s_listeners = new HashMap();

    SubXactListener() {
    }

    static void onAbort(long l, int n, int n2) throws SQLException {
        SavepointListener savepointListener = (SavepointListener)s_listeners.get(new Long(l));
        if (savepointListener != null) {
            savepointListener.onAbort(Backend.getSession(), PgSavepoint.forId(n), PgSavepoint.forId(n2));
        }
    }

    static void onCommit(long l, int n, int n2) throws SQLException {
        SavepointListener savepointListener = (SavepointListener)s_listeners.get(new Long(l));
        if (savepointListener != null) {
            savepointListener.onCommit(Backend.getSession(), PgSavepoint.forId(n), PgSavepoint.forId(n2));
        }
    }

    static void onStart(long l, long l2, int n) throws SQLException {
        SavepointListener savepointListener = (SavepointListener)s_listeners.get(new Long(l));
        if (savepointListener != null) {
            savepointListener.onStart(Backend.getSession(), new PgSavepoint(l2), PgSavepoint.forId(n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addListener(SavepointListener savepointListener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long l = System.identityHashCode(savepointListener);
            if (s_listeners.put(new Long(l), savepointListener) != savepointListener) {
                SubXactListener._register(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeListener(SavepointListener savepointListener) {
        Object object = Backend.THREADLOCK;
        synchronized (object) {
            long l = System.identityHashCode(savepointListener);
            if (s_listeners.remove(new Long(l)) == savepointListener) {
                SubXactListener._unregister(l);
            }
        }
    }

    private static native void _register(long var0);

    private static native void _unregister(long var0);
}

