/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.postgresql.pljava.internal.Backend;
import org.postgresql.pljava.internal.Savepoint;
import org.postgresql.pljava.jdbc.SPIDriver;

public abstract class SPISavepoint
implements java.sql.Savepoint {
    private Savepoint m_internalSavepoint;
    private static final Logger s_log = Logger.getAnonymousLogger();

    SPISavepoint(String string) throws SQLException {
        this.m_internalSavepoint = Savepoint.set(string);
    }

    public void onInvocationExit() throws SQLException {
        if (this.m_internalSavepoint == null) {
            return;
        }
        Connection connection = SPIDriver.getDefault();
        String string = this.m_internalSavepoint.getName();
        if (Backend.isReleaseLingeringSavepoints()) {
            s_log.warning("Releasing savepoint '" + string + "' since its lifespan exceeds that of the function where it was set");
            connection.releaseSavepoint(this);
        } else {
            s_log.warning("Rolling back to savepoint '" + string + "' since its lifespan exceeds that of the function where it was set");
            connection.rollback(this);
        }
    }

    final void release() throws SQLException {
        if (this.m_internalSavepoint != null) {
            this.m_internalSavepoint.release();
            this.m_internalSavepoint = null;
        }
    }

    final void rollback() throws SQLException {
        if (this.m_internalSavepoint != null) {
            this.m_internalSavepoint.rollback();
            this.m_internalSavepoint = null;
        }
    }

    final boolean isActive() {
        return this.m_internalSavepoint != null;
    }

    final String getSPIName() {
        if (this.m_internalSavepoint == null) {
            return "inactive savepoint";
        }
        return this.m_internalSavepoint.getName();
    }
}

