/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.pljava.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import org.postgresql.pljava.internal.Portal;
import org.postgresql.pljava.internal.SPI;
import org.postgresql.pljava.internal.SPITupleTable;
import org.postgresql.pljava.internal.Tuple;
import org.postgresql.pljava.internal.TupleDesc;
import org.postgresql.pljava.jdbc.ReadOnlyResultSet;
import org.postgresql.pljava.jdbc.UnsupportedFeatureException;

public class SPIResultSet
extends ReadOnlyResultSet {
    private final Statement m_statement;
    private final Portal m_portal;
    private final TupleDesc m_tupleDesc;
    private final int m_maxRows;
    private int m_fetchSize;
    private int m_row;
    private Tuple m_currentRow;
    private Tuple m_nextRow;
    private SPITupleTable m_table;
    private int m_tableRow;

    SPIResultSet(Statement statement, Portal portal, int n) throws SQLException {
        this.m_statement = statement;
        this.m_portal = portal;
        this.m_maxRows = n;
        this.m_tupleDesc = portal.getTupleDesc();
        this.m_fetchSize = statement.getFetchSize();
        this.m_row = 0;
        this.m_tableRow = -1;
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    public int getRow() throws SQLException {
        return this.m_row;
    }

    public int getType() throws SQLException {
        return 1003;
    }

    public void afterLast() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public void beforeFirst() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public void close() throws SQLException {
        if (this.m_portal.isValid()) {
            this.m_portal.close();
            this.m_table = null;
            this.m_row = -1;
            this.m_tableRow = -1;
            this.m_currentRow = null;
            this.m_nextRow = null;
        }
    }

    public boolean first() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean isAfterLast() throws SQLException {
        return this.m_row < 0;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.m_row == 0;
    }

    public boolean isFirst() throws SQLException {
        return this.m_row == 1;
    }

    public boolean isLast() throws SQLException {
        return this.m_currentRow != null && this.peekNext() == null;
    }

    public boolean last() throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean next() throws SQLException {
        boolean bl;
        this.m_currentRow = this.peekNext();
        this.m_nextRow = null;
        boolean bl2 = bl = this.m_currentRow != null;
        this.m_row = bl ? ++this.m_row : -1;
        return bl;
    }

    public boolean previous() throws SQLException {
        throw new UnsupportedFeatureException("Reverse positioning");
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new UnsupportedFeatureException("Non forward fetch direction");
        }
    }

    public void setFetchSize(int n) throws SQLException {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal fetch size for ResultSet");
        }
        this.m_fetchSize = n;
    }

    public boolean absolute(int n) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public boolean relative(int n) throws SQLException {
        throw new UnsupportedFeatureException("Cursor positioning");
    }

    public String getCursorName() throws SQLException {
        return this.getPortal().getName();
    }

    public int findColumn(String string) throws SQLException {
        return this.m_tupleDesc.getColumnIndex(string);
    }

    public Statement getStatement() throws SQLException {
        return this.m_statement;
    }

    protected final Portal getPortal() throws SQLException {
        if (!this.m_portal.isValid()) {
            throw new SQLException("ResultSet is closed");
        }
        return this.m_portal;
    }

    protected final SPITupleTable getTupleTable() throws SQLException {
        if (this.m_table == null) {
            int n;
            Portal portal = this.getPortal();
            if (portal.isAtEnd()) {
                return null;
            }
            if (this.m_maxRows > 0) {
                n = this.m_maxRows - portal.getPortalPos();
                if (n <= 0) {
                    return null;
                }
                if (n > this.m_fetchSize) {
                    n = this.m_fetchSize;
                }
            } else {
                n = this.m_fetchSize;
            }
            int n2 = portal.fetch(true, n);
            if (n2 > 0) {
                this.m_table = SPI.getTupTable();
            }
            this.m_tableRow = -1;
        }
        return this.m_table;
    }

    protected final Tuple getCurrentRow() throws SQLException {
        if (this.m_currentRow == null) {
            throw new SQLException("ResultSet is not positioned on a valid row");
        }
        return this.m_currentRow;
    }

    protected final Tuple peekNext() throws SQLException {
        if (this.m_nextRow != null) {
            return this.m_nextRow;
        }
        SPITupleTable sPITupleTable = this.getTupleTable();
        if (sPITupleTable == null) {
            return null;
        }
        if (this.m_tableRow >= sPITupleTable.getCount() - 1) {
            this.m_table.invalidate();
            this.m_table = null;
            sPITupleTable = this.getTupleTable();
            if (sPITupleTable == null) {
                return null;
            }
        }
        this.m_nextRow = sPITupleTable.getSlot(++this.m_tableRow);
        return this.m_nextRow;
    }

    protected Object getObjectValue(int n) throws SQLException {
        return this.getCurrentRow().getObject(this.m_tupleDesc, n);
    }
}

