/*
 *  PostgreSQLPrivate.h
 *  PostgresSQL
 *
 *  Created by Pascal on Sun Dec 22 2002.
 *  Copyright (c) 2002 P3 Consulting. All rights reserved.
 *
 */

#import <Foundation/Foundation.h>
#import "PgSQLBindItem.h"

@interface PostgreSQL(Private)

-(void)_setAsyncThread:(PgASyncThread *)asyncThread;
-(void)_resultAvailable;
-(void)_timeOut;
-(void)_fetchData;
-(void)_fetchData:(PGresult *)forResult atIndex:(int)rowIndex withBinding:(NSMutableArray *)bindingArray;
-(id)_fetchFieldValue:(PGresult *)result atIndex:(int)rowIndex forField:(int)fieldIndex binary:(BOOL)binary;
-(Oid)_fetchFieldType:(int)fieldIndex;
-(const char *)_fetchFieldTypeName:(int)fieldIndex;
-(const char *)_fetchFieldName:(int)fieldIndex;
-(int)_fetchNFields;

-(void)_bindDouble:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(double *)addr;
-(void)_bindFloat:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(float *)addr;
-(void)_bindDecimal2Double:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(double *)addr;
-(void)_bindNSDecimal:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(NSDecimalNumber **)addr;
-(void)_bindBoolean:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(BOOL *)addr;
-(void)_bindChar:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(char *)addr;
-(void)_bindShort:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(short *)addr;
-(void)_bindInteger:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(int *)addr;
-(void)_bindLongLong:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(long long *)addr;
-(void)_bindText:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(TEXT *)addr;
-(void)_bindString:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(char *)addr;
-(id)_bindAnyNumber:(PGresult *)result atIndex:(int)rowIndex type:(int)type forField:(int)field binary:(int)binary;
-(void)_bindBinaryString:(PGresult *)result atIndex:(int)rowIndex forField:(int)field binary:(int)binary addr:(BSTRING *)addr;
-(void)_bindAny:(int)col address:(void *)itemAddr type:(TBindItemType)itemType bindingArray:(NSMutableArray *)bindingArray;

@end
