/*-------------------------------------------------------------------------
 *
 * globals.c--
 *	  global variable declarations
 *
 * Copyright (c) 1994, Regents of the University of California
 *
 *
 * IDENTIFICATION
 *	  $Header: /home/postgres/cvs_root/postgres-r/src/backend/utils/init/globals.c,v 1.2 2001/06/12 14:51:59 johnsond Exp $
 *
 * NOTES
 *	  Globals used all over the place should be declared here and not
 *	  in other modules.
 *
 *	last change 1998/11/27, wb, added GotoReplicaMode boolean. This boolean indicates wether the 
 *								backend is to be started in replication mode or not		
 *
 *-------------------------------------------------------------------------
 */

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <sys/file.h>
#include <sys/types.h>
#include <math.h>
#include <unistd.h>

#include "postgres.h"
#include "miscadmin.h"			/* where the declarations go */

#include <storage/backendid.h>
#include "access/heapam.h"
#include "storage/sinval.h"
#include "storage/sinvaladt.h"
#include "storage/lmgr.h"
#include "utils/elog.h"
#include "libpq/pqcomm.h"
#include "libpq/bufferedSock.h"
#include "catalog/catname.h"
#include "replication/writeset.h" //(wb) added for MyWriteSet





ProtocolVersion FrontendProtocol = PG_PROTOCOL_LATEST;
int			Portfd = -1;

bool		Noversion = false;
bool		Quiet = false;
bool		QueryCancel = false;

int			MyProcPid;
struct Port *MyProcPort;
long		MyCancelKey;

char	   *DataDir = NULL;

 /*
  * The PGDATA directory user says to use, or defaults to via environment
  * variable.  NULL if no option given and no environment variable set
  */
Relation	reldesc;			/* current relation descriptor */

char		OutputFileName[MAXPGPATH] = "";

BackendId	MyBackendId;
BackendTag	MyBackendTag;

char	   *UserName = NULL;
char	   *DatabaseName = NULL;
char	   *DatabasePath = NULL;

bool		MyDatabaseIdIsInitialized = false;
Oid			MyDatabaseId = InvalidOid;
bool		TransactionInitWasProcessed = false;

bool		IsUnderPostmaster = false;

/*
*	 3 globals needed when replicating (wb)
*/
txn_t		txn_type = NOT_REPLICATED;
txn_t		txn_location = LOCAL_TXN;
bool        txn_read_only = false;
bufsockptr	MyRmgrSock = NULL; 
WriteSet	MyWriteSet;
/* a 4'th added */
bool        may_not_abort_right_now = false;

short		DebugLvl = 0;

int			DateStyle = USE_POSTGRES_DATES;
bool		EuroDates = false;
bool		HasCTZSet = false;
bool		CDayLight = false;
int			CTimeZone = 0;
char		CTZName[MAXTZLEN + 1] = "";

char		DateFormat[20] = "%d-%m-%Y";		/* mjl: sizes! or better
												 * malloc? XXX */
char		FloatFormat[20] = "%f";

int			fsyncOff = 0;
int			SortMem = 512;

char	   *IndexedCatalogNames[] = {
	AttributeRelationName,
	ProcedureRelationName,
	TypeRelationName,
	RelationRelationName,
	0
};


/* ----------------
 * we just do a linear search now so there's no requirement that the list
 * be ordered.	The list is so small it shouldn't make much difference.
 * make sure the list is null-terminated
 *				- jolly 8/19/95
 *
 * OLD COMMENT
 *		WARNING  WARNING  WARNING  WARNING	WARNING  WARNING
 *
 *		keep SharedSystemRelationNames[] in SORTED order!  A binary search
 *		is done on it in catalog.c!
 *
 *		XXX this is a serious hack which should be fixed -cim 1/26/90
 * ----------------
 */
char	   *SharedSystemRelationNames[] = {
	DatabaseRelationName,
	GroupRelationName,
	LogRelationName,
	ShadowRelationName,
	VariableRelationName,
	0
};
