/***************************************************************************
                          kwindrose.cpp  -  description
                             -------------------
    begin                : Mon Sep  4 21:47:05 CEST 2000
    copyright            : (C) 2000 by CFJH
    email                : hochwald@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwindrose.h"
#include "kwrdlg.h"

extern WrTestDlg *DLG;

DrawWidget::DrawWidget( QWidget* parent=0, const char* name=0, WFlags f=0)
        : QWindow( parent, name, f ) {

   Test = new KWindRose(this);
   Test->setGeometry(100,50,300,300);

   DLG = new WrTestDlg(0);
   DLG->show();
   DLG->WR = Test;
   connect(Test, SIGNAL(valueChanged(float)), DLG, SLOT(ValChange(float)));

   Test->setFocus();
}

DrawWidget::~DrawWidget() {
   //debug("delete DrawWidget");
//   delete DLG;
//   DLG=NULL;
   //debug("delete DrawWidget Ende");
}

void DrawWidget::resizeEvent(QResizeEvent*){

   Test->setGeometry(0,0,width(),height());
}


Kwindrose::Kwindrose(const char *name) : KTMainWindow(name)
{
  Client = new DrawWidget(this);
  setView(Client);
  initMenu();
  setCaption(i18n("test_en"));
}

Kwindrose::~Kwindrose()
{
}

int Kwindrose::initMenu() {

   QPopupMenu* Menu1 = new QPopupMenu;
   Menu1->insertItem(i18n("Change &Colors"),         this, SLOT(MenuSetColors()),ALT+Key_C);
   Menu1->insertItem(i18n("Change &Size"),           this, SLOT(MenuSetWidth()), ALT+Key_W );
   Menu1->insertItem(i18n("Show &Properties Window"),this, SLOT(MenuShowDlg()),  ALT+Key_D );
   Menu1->insertSeparator();
   Menu1->insertItem(i18n("&Exit"), qApp, SLOT(quit()), CTRL+Key_Q );
//   Menu1->insertItem(i18n("TESTtest"), qApp, SLOT(quit()), CTRL+Key_Q );
   MainMenu = new KMenuBar(this);
   MainMenu->insertItem(i18n("&Main"), Menu1);
   setMenu(MainMenu);

   resize(640,480);
   show();
   return 0;
}

void Kwindrose::MenuSetColors() {
   Client->Test->setColors(qRgb(255,255,255), qRgb(255,0,0), qRgb(255,255,0),qRgb(0,0,0));
}

void Kwindrose::MenuSetWidth() {
   Client->Test->setRoseWidth(0.1);
}

void Kwindrose::MenuShowDlg() {
   DLG->show();
}
