//start of HashAndChainedListSearch.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * HashAndChainedListSearch.java
 * 
 * Copyright (C) 2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.util.lha;

//import classes and interfaces
import jp.gr.java_conf.dangan.lang.reflect.Factory;
import jp.gr.java_conf.dangan.util.lha.HashMethod;
import jp.gr.java_conf.dangan.util.lha.HashDefault;
import jp.gr.java_conf.dangan.util.lha.LzssOutputStream;
import jp.gr.java_conf.dangan.util.lha.LzssSearchMethod;

//import exceptions
import java.io.IOException;
import java.lang.NoSuchMethodException;
import java.lang.ClassNotFoundException;
import java.lang.InstantiationException;
import java.lang.IllegalArgumentException;
import java.lang.reflect.InvocationTargetException;

import java.lang.Error;
import java.lang.NoSuchMethodError;
import java.lang.InstantiationError;
import java.lang.NoClassDefFoundError;


/**
 * nbVƒPAXggčꂽ LzssSearchMethodB<br>
 * ł؂邱Ƃɂ鍂sĂ邽߁A
 * KŒv邱ƂoƂ͌ȂB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: HashAndChainedListSearch.java,v $
 * Revision 1.0  2002/08/05 00:00:00  dangan
 * add to version control
 * [change]
 *     LzssSearchMethod ̃C^tFCXύXɂ킹ăC^tFCXύX
 * [improvement]
 *     ar940528  TEST5 ̎ɕύXB
 * [maintenance]
 *     \[X
 *     ^up~
 *     CZX̏C
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class HashAndChainedListSearch implements LzssSearchMethod{


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  LZSS parameter
    //------------------------------------------------------------------
    //  private int DictionarySize
    //  private int MaxMatch
    //  private int Threshold
    //------------------------------------------------------------------
    /**
     * LZSSTCYB
     */
    private int DictionarySize;

    /**
     * LZSSkɎgplB
     * ővB
     */
    private int MaxMatch;

    /**
     * LZSSkɎgp臒lB
     * v ̒lȏł΁AkR[ho͂B
     */
    private int Threshold;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  text buffer
    //------------------------------------------------------------------
    //  private byte[] TextBuffer
    //  private int DictionaryLimit
    //------------------------------------------------------------------
    /**
     * LZSSk{߂̃obt@B
     * Ö͎A
     * 㔼͈k{߂̃f[^̓obt@B
     * LzssSearchMethod̎ł͓ǂݍ݂̂݋B
     */
    private byte[] TextBuffer;

    /**
     * ̌EʒuB 
     * TextBufferO̎̈Ƀf[^ꍇ
     * ̈ɂs̃f[^(Javał0)gp
     * Ĉkŝ}~B
     */
    private int DictionaryLimit;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  hash
    //------------------------------------------------------------------
    //  private HashMethod hashMethod
    //  private int[] hashTable
    //  private char[] tooBigFlag
    //------------------------------------------------------------------
    /**
     * nbV֐
     */
    private HashMethod hashMethod;

    /**
     * nbVe[u
     * Y̓nbVlAeTextBuffer̈ʒu
     */
    private int[] hashTable;

    /**
     * nbVlf[^p^̘AXg̒
     * ȏɂȂꍇɃZbgtOB
     * 
     * boolean[] ɂƉ̂xȂ̂
     * char[] Ƃ 16Z߂ĈB
     * ꍇ [eBeB\bh
     * isTooBig(), setTooBigFlag(), clearTooBigFlag() ĈB
     */
    private char[] tooBigFlag;


    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  cahined list
    //------------------------------------------------------------------
    //  private int[] prev
    //  private int SearchLimitCount
    //------------------------------------------------------------------
    /**
     * nbVlf[^p^Jnʒu
     * PAXgB
     */
    private int[] prev;

    /**
     * Ts񐔂̏lB
     * ̉񐔈ȏ̒T͍sȂB
     */
    private int SearchLimitCount;


    //------------------------------------------------------------------
    //  constructor
    //------------------------------------------------------------------
    //  private HashAndChainedListSearch()
    //  public HashAndChainedListSearch( int DictionarySize, int MaxMatch, 
    //                                   int Threshold, byte[] TextBuffer )
    //  public HashAndChainedListSearch( int DictionarySize, int MaxMatch, 
    //                                   int Threshold, byte[] TextBuffer,
    //                                   int SearchLimitCount )
    //  public HashAndChainedListSearch( int DictionarySize, int MaxMatch, 
    //                                   int Threshold, byte[] TextBuffer,
    //                                   String HashMethodClassName )
    //  public HashAndChainedListSearch( int DictionarySize, int MaxMatch, 
    //                                   int Threshold, byte[] TextBuffer,
    //                                   String HashMethodClassName,
    //                                   int SearchLimitCount )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private HashAndChainedListSearch(){ }

    /**
     * nbVƘAXggp LzssSearchMethod \zB<br>
     * nbV֐ƒTs񐔂̏lɂ̓ftHĝ̂gpB<br>
     * 
     * @param DictionarySize      TCY
     * @param MaxMatch            Œv
     * @param Threshold           kA񈳏k臒l
     * @param TextBuffer          LZSSk{߂̃obt@
     */
    public HashAndChainedListSearch( int    DictionarySize,
                                     int    MaxMatch,
                                     int    Threshold,
                                     byte[] TextBuffer ){
        this( DictionarySize,
              MaxMatch,
              Threshold,
              TextBuffer,
              HashDefault.class.getName(),
              256 );
    }

    /**
     * nbVƘAXggp LzssSearchMethod \zB<br>
     * nbV֐ɂ̓ftHĝ̂gpB<br>
     * 
     * @param DictionarySize      TCY
     * @param MaxMatch            Œv
     * @param Threshold           kA񈳏k臒l
     * @param TextBuffer          LZSSk{߂̃obt@
     * @param SearchLimitCount    Ts񐔂̏
     * 
     * @exception IllegalArgumentException
     *              SearchLimitCount 0ȉ̏ꍇ
     */
    public HashAndChainedListSearch( int    DictionarySize,
                                     int    MaxMatch,
                                     int    Threshold,
                                     byte[] TextBuffer,
                                     int    SearchLimitCount ){
        this( DictionarySize,
              MaxMatch,
              Threshold,
              TextBuffer,
              HashDefault.class.getName(),
              SearchLimitCount );
    }

    /**
     * nbVƘAXggp LzssSearchMethod \zB<br>
     * Ts񐔂̏lɂ̓ftHĝ̂gpB<br>
     * 
     * @param DictionarySize      TCY
     * @param MaxMatch            Œv
     * @param Threshold           kA񈳏k臒l
     * @param TextBuffer          LZSSk{߂̃obt@
     * @param HashMethodClassName Hash֐񋟂NX
     * 
     * @exception NoClassDefFoundError
     *              HashMethodClassName ŗ^ꂽNX
     *              ȂꍇB
     * @exception InstantiationError
     *              HashMethodClassName ŗ^ꂽNX
     *              abstract class ł邽߃CX^X𐶐łȂꍇB
     * @exception NoSuchMethodError
     *              HashMethodClassName ŗ^ꂽNX
     *              RXgN^ HashMethod( byte[] )Ȃꍇ
     */
    public HashAndChainedListSearch( int    DictionarySize,
                                     int    MaxMatch,
                                     int    Threshold,
                                     byte[] TextBuffer,
                                     String HashMethodClassName ){
        this( DictionarySize,
              MaxMatch,
              Threshold,
              TextBuffer,
              HashMethodClassName,
              256 );
    }


    /**
     * nbVƘAXggp LzssSearchMethod \zB<br>
     * 
     * @param DictionarySize      TCY
     * @param MaxMatch            Œv
     * @param Threshold           kA񈳏k臒l
     * @param TextBuffer          LZSSk{߂̃obt@
     * @param HashMethodClassName Hash֐񋟂NX
     * @param SearchLimitCount    Ts񐔂̏
     * 
     * @exception IllegalArgumentException
     *              SearchLimitCount 0ȉ̏ꍇ
     * @exception NoClassDefFoundError
     *              HashMethodClassName ŗ^ꂽNX
     *              ȂꍇB
     * @exception InstantiationError
     *              HashMethodClassName ŗ^ꂽNX
     *              abstract class ł邽߃CX^X𐶐łȂꍇB
     * @exception NoSuchMethodError
     *              HashMethodClassName ŗ^ꂽNX
     *              RXgN^ HashMethod( byte[] )Ȃꍇ
     */
    public HashAndChainedListSearch( int    DictionarySize,
                                     int    MaxMatch,
                                     int    Threshold,
                                     byte[] TextBuffer,
                                     String HashMethodClassName,
                                     int    SearchLimitCount ){

        if( 0 < SearchLimitCount ){

            this.DictionarySize   = DictionarySize;
            this.MaxMatch         = MaxMatch;
            this.Threshold        = Threshold;
            this.TextBuffer       = TextBuffer;
            this.DictionaryLimit  = this.DictionarySize;
            this.SearchLimitCount = SearchLimitCount;

            try{
                this.hashMethod = (HashMethod)Factory.createInstance(
                                                    HashMethodClassName, 
                                                    new Object[]{ TextBuffer } );
            }catch( ClassNotFoundException exception ){
                throw new NoClassDefFoundError( exception.getMessage() );
            }catch( InvocationTargetException exception ){
                throw new Error( exception.getTargetException().getMessage() );
            }catch( NoSuchMethodException exception ){
                throw new NoSuchMethodError( exception.getMessage() );
            }catch( InstantiationException exception ){
                throw new InstantiationError( exception.getMessage() );
            }

            // nbVe[u
            this.hashTable = new int[ this.hashMethod.tableSize() ];
            for( int i = 0 ; i < this.hashTable.length ; i++ ){
                this.hashTable[i] = -1;
            }

            // AXg
            this.prev = new int[ this.DictionarySize ];
            for( int i = 0 ; i < this.prev.length ; i++ ){
                this.prev[i] = -1;
            }

            this.tooBigFlag = new char[ this.hashMethod.tableSize() >> 4 ];

        }else{
            throw new IllegalArgumentException( "SearchLimitCount must be 1 or more." );
        }
    }


    //------------------------------------------------------------------
    //  method jp.gr.java_conf.dangan.util.lha.LzssSearchMethod
    //------------------------------------------------------------------
    //  public void put( int position )
    //  public int searchAndPut( int position )
    //  public int search( int position, int lastPutPos )
    //  public void slide( int slideWidth, int slideEnd )
    //  public int putRequires()
    //------------------------------------------------------------------
    /**
     * position n܂f[^p^
     * nbVƘAXg琬錟@\ɓo^B<br>
     * 
     * @param position TextBuffer̃f[^p^̊Jnʒu
     */
    public void put( int position ){
        int hash   = this.hashMethod.hash( position );
        this.prev[ position & ( this.DictionarySize - 1 ) ] = this.hashTable[ hash ];
        this.hashTable[ hash ] = position;
    }

    /**
     * nbVƘAXg琬錟@\ɓo^ꂽ
     * f[^p^ position n܂f[^p^
     * Œ̈v̂A
     *  position n܂f[^p^ 
     * nbVƘAXg琬錟@\ɓo^B<br>
     * 
     * @param position TextBuffer̃f[^p^̊JnʒuB
     * 
     * @return vꍇ
     *         LzssOutputStream.createSearchReturn 
     *         ɂĐꂽvʒuƈv̏lA
     *         vȂꍇ
     *         LzssOutputStream.NOMATCHB
     * 
     * @see LzssOutputStream#createSearchReturn(int,int)
     * @see LzssOutputStream#NOMATCH
     */
    public int searchAndPut( int position ){

        int matchlen    = this.Threshold - 1;
        int matchpos    = position;
        int maxmatch    = this.MaxMatch;
        int scanlimit   = Math.max( this.DictionaryLimit,
                                    position - this.DictionarySize );

        //------------------------------------------------------------------
        //  AXg̒ꍇ offset gp
        //  AXg̒ZnbVlgB
        int poshash = this.hashMethod.hash( position );
        int offhash = poshash;
        int offset  = 0;
        while( this.isTooBig( offhash )
            && offset < this.MaxMatch - this.hashMethod.hashRequires() ){
            offset++;
            offhash = this.hashMethod.hash( position + offset );
        }

        //------------------------------------------------------------------
        //  C[v
        //  ő offhash  poshash n܂ 2̘AXg𑖍B
        byte[] buf     = this.TextBuffer;
        int max        = position + this.MaxMatch;
        int s          = 0;
        int p          = 0;
        int len        = 0;
        while( true ){
            int scanpos     = this.hashTable[ offhash ];
            int searchCount = this.SearchLimitCount;

            while( scanlimit <= scanpos - offset && 0 < --searchCount ){
                if( buf[ scanpos  + matchlen - offset ]
                 == buf[ position + matchlen ] ){
                    s = scanpos - offset;
                    p = position;
                    while( buf[ s ] == buf[ p ] ){
                        s++;
                        p++;
                        if( max <= p ) break;
                    }

                    len = p - position;
                    if( matchlen < len ){
                        matchpos = scanpos - offset;
                        matchlen = len;
                        if( max <= p ) break;
                    }
                }
                scanpos = this.prev[ scanpos & ( this.DictionarySize - 1 ) ];
            }

            if( searchCount <= 0 ){
                this.setTooBigFlag( offhash );
            }else if( scanpos < scanlimit ){
                this.clearTooBigFlag( offhash );
            }

            if( 0 < offset
             && matchlen < this.hashMethod.hashRequires() + offset ){
                offset   = 0;
                maxmatch = this.hashMethod.hashRequires() + offset - 1;
                max      = position + maxmatch;
                offhash  = poshash;
            }else{
                break;
            }
        }

        //------------------------------------------------------------------
        //  nbVƘAXggp@\
        //  position n܂f[^p^o^B
        this.prev[ position & ( this.DictionarySize - 1 ) ] = this.hashTable[ poshash ];
        this.hashTable[ poshash ] = position;

        //------------------------------------------------------------------
        //  ŒvĂяoɕԂB
        if( this.Threshold <= matchlen ){
            return LzssOutputStream.createSearchReturn( matchlen, matchpos );
        }else{
            return LzssOutputStream.NOMATCH;
        }
    }

    /**
     * nbVƘAXggp@\ɓo^ꂽ
     * f[^p^ position n܂f[^p^
     * Œ̈v̂𓾂B<br>
     * 
     * @param position   TextBuffer̃f[^p^̊JnʒuB
     * @param lastPutPos Ōɓo^f[^p^̊JnʒuB
     * 
     * @return vꍇ
     *         LzssOutputStream.createSearchReturn 
     *         ɂĐꂽvʒuƈv̏lA
     *         vȂꍇ
     *         LzssOutputStream.NOMATCHB
     * 
     * @see LzssOutputStream#createSearchReturn(int,int)
     * @see LzssOutputStream#NOMATCH
     */
    public int search( int position, int lastPutPos ){

        //------------------------------------------------------------------
        //  nbVƘAXgɂ錟@\ɓo^ĂȂ
        //  f[^p^PȒŌB
        int matchlen   = this.Threshold - 1;
        int matchpos   = position;
        int scanpos    = position - 1;
        int scanlimit  = Math.max( this.DictionaryLimit, lastPutPos );

        byte[] buf     = this.TextBuffer;
        int max        = Math.min( this.TextBuffer.length,
                                   position + this.MaxMatch );
        int s          = 0;
        int p          = 0;
        int len        = 0;
        while( scanlimit < scanpos ){
            s = scanpos;
            p = position;
            while( buf[ s ] == buf[ p ] ){
                s++;
                p++;
                if( max <= p ) break;
            }

            if( matchlen < len ){
                matchpos = scanpos;
                matchlen = len;
            }
            scanpos--;
        }

        //------------------------------------------------------------------
        //  nbVƘAXggp@\ 猟B
        if( this.hashMethod.hashRequires() < this.TextBuffer.length - position ){
            int maxmatch    = this.MaxMatch;
            scanlimit   = Math.max( this.DictionaryLimit,
                                    position - this.DictionarySize );

            //  AXg̒ꍇ offset gp
            //  AXg̒ZnbVlgB
            int poshash = this.hashMethod.hash( position );
            int offhash = poshash;
            int offset  = 0;
            while( this.isTooBig( offhash )
                && offset < this.MaxMatch - this.hashMethod.hashRequires() ){
                offset++;
                offhash = this.hashMethod.hash( position + offset );
            }

            //  C[v
            //  ő offhash  poshash n܂ 2̘AXg𑖍B
            while(true){
                int searchCount = this.SearchLimitCount;
                scanpos = this.hashTable[ offhash ];

                while( scanlimit <= scanpos - offset && 0 < --searchCount ){
                    if( buf[ scanpos  + matchlen - offset ]
                     == buf[ position + matchlen ] ){
                        s = scanpos - offset;
                        p = position;
                        while( buf[ s ] == buf[ p ] ){
                            s++;
                            p++;
                            if( max <= p ) break;
                        }

                        len = p - position;
                        if( matchlen < len ){
                            matchpos = scanpos - offset;
                            matchlen = len;
                            if( max <= p ) break;
                        }
                    }
                    scanpos = this.prev[ scanpos & ( this.DictionarySize - 1 ) ];
                }

                if( searchCount <= 0 ){
                    this.setTooBigFlag( offhash );
                }else if( scanpos < scanlimit ){
                    this.clearTooBigFlag( offhash );
                }

                if( 0 < offset
                 && matchlen < this.hashMethod.hashRequires() + offset ){
                    offset   = 0;
                    maxmatch = this.hashMethod.hashRequires() + offset - 1;
                    max      = Math.min( this.TextBuffer.length,
                                         position + maxmatch );
                    offhash  = poshash;
                }else{
                    break;
                }
            }
        }

        //------------------------------------------------------------------
        //  ŒvĂяoɕԂB
        if( this.Threshold <= matchlen ){
            return LzssOutputStream.createSearchReturn( matchlen, matchpos );
        }else{
            return LzssOutputStream.NOMATCH;
        }
    }

    /**
     * TextBufferposition܂ł̃f[^
     * OֈړہAɉ SearchMethod
     * f[^ TextBuffer̃f[^ƖȂ悤
     * Oֈړ鏈sB
     */
    public void slide(){
        this.DictionaryLimit = Math.max( 0, this.DictionaryLimit - this.DictionarySize );

        for( int i = 0 ; i < this.hashTable.length ; i++ ){
            int pos = this.hashTable[i] - this.DictionarySize;
            this.hashTable[i] = ( 0 <= pos ? pos : -1 );
        }

        for( int i = 0 ; i < this.prev.length ; i++  ){
            int pos = this.prev[i] - this.DictionarySize;
            this.prev[i] = ( 0 <= pos ? pos : -1 );;
        }
    }

    /**
     * put()  LzssSearchMethodɃf[^
     * o^ƂɎgpf[^ʂ𓾂B
     * HashAndChainedListSearch ł́A
     * ŎgpĂ HashMethod ̎ 
     * hash() ̂߂ɕKvƂf[^
     * ( HashMethod.hashRequires() ̖߂l ) ԂB
     * 
     * @return ŎgpĂ HashMethod ̎ 
     *         hash() ̂߂ɕKvƂf[^
     */
    public int putRequires(){
        return this.hashMethod.hashRequires();
    }

    //------------------------------------------------------------------
    //  method of ImprovedLzssSearchMethod
    //------------------------------------------------------------------
    //  public int searchAndPut( int position, int[] matchposs )
    //------------------------------------------------------------------
    /**
     * ǂ LZSS k̂߂̑I񋟂 searchAndPut()B 
     * ႦΈv 3, vʒu 4  v 4, vʒu 1024 ł
     * v 3, vʒu 4 + 񈳏k1 ̕o̓rbg
     * ȂȂ鎖B̂悤ȏꍇɑΏ邽߈v
     * positionɈԋ߂vʒu񋓂B
     * 
     * @param position  Ώۂ̃f[^p^̊Jnʒu
     * @param matchposs vʒu̗񋓂i[ĕԂ߂̔z<br>
     *                  matchpos[0] ɂ v Threshold ̈vʒuA<br>
     *                  matchpos[1] ɂ v Threshold + 1 ̈vʒui[B<br>
     *                  vȂꍇɂ LzssOutputStream.NOMATCH i[B
     * 
     * @return vꍇ
     *         LzssOutputStream.createSearchReturn Őꂽ SearchReturn ԂB<br>
     *         vȂꍇ LzssOutputStream.NOMATCH ԂB<br>
     */
    public int searchAndPut( int position, int[] matchposs ){
        int matchlen    = this.Threshold - 1;
        int matchpos    = position;
        int maxmatch    = this.MaxMatch;
        int scanlimit   = Math.max( this.DictionaryLimit,
                                    position - this.DictionarySize );
        int searchCount = this.SearchLimitCount;

        for( int i = 0 ; i < matchposs.length ; i++ )
            matchposs[i] = LzssOutputStream.NOMATCH;

        int scanpos    = this.hashTable[ this.hashMethod.hash( position ) ];

        while( scanlimit < scanpos && 0 < searchCount-- ){
            if( this.TextBuffer[ scanpos  + matchlen ]
             == this.TextBuffer[ position + matchlen ] ){
                int len = 0;
                while( this.TextBuffer[ scanpos  + len ]
                    == this.TextBuffer[ position + len ] ){
                    if( maxmatch <= ++len ) break;
                }

                if( matchlen < len ){
                    int i   = matchlen + 1 - this.Threshold;
                    int end = Math.min( len + 1 - this.Threshold, matchposs.length );
                    while( i < end ) matchposs[ i++ ] = scanpos;

                    matchpos = scanpos;
                    matchlen = len;
                    if( maxmatch <= len )
                        break;
                }
            }
            scanpos = this.prev[ scanpos & ( this.DictionarySize - 1 ) ];
        }

        this.put( position );

        if( matchpos < position )
            return LzssOutputStream.createSearchReturn( matchlen, matchpos );
        else
            return LzssOutputStream.NOMATCH;
    }


    //------------------------------------------------------------------
    //  local methods
    //------------------------------------------------------------------
    //  too big flag
    //------------------------------------------------------------------
    //  private int isTooBig( int hash )
    //  private void setTooBigFlag( int hash )
    //  private void clearTooBigFlag( int hash )
    //------------------------------------------------------------------
    /**
     * hash ̘AXg臒l𒴂Ă邩𓾂B
     * 
     * @param hash nbVl
     * 
     * @return AXg̒臒l𒴂ĂȂ true
     *         ĂȂ false
     */
    private boolean isTooBig( int hash ){
        return 0 != ( this.tooBigFlag[ hash >> 4 ] & ( 1 << ( hash & 0x0F ) ) );
    }

    /**
     * hash ̘AXg臒l𒴂
     * tOZbgB
     * 
     * @param hash too big tOZbgnbVl
     */
    private void setTooBigFlag( int hash ){
        this.tooBigFlag[ hash >> 4 ] |= 1 << ( hash & 0x0F );
    }

    /**
     * hash ̘AXg臒l𒴂Ă鎖
     * tONAB
     * 
     * @param hash too big tONAnbVl
     */
    private void clearTooBigFlag( int hash ){
        this.tooBigFlag[ hash >> 4 ] &= ~( 1 << ( hash & 0x0F ) );
    }

}
//end of HashAndChainedListSearch.java
