/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import java.util.List;

public class MathExpr
extends Expr {
    final String mOp;

    MathExpr(Expr left, String op, Expr right) {
        super(left, right);
        this.mOp = op;
    }

    @Override
    protected String computeUniqueKey() {
        return sUniqueKeyJoiner.join(this.getLeft().getUniqueKey(), this.mOp, this.getRight().getUniqueKey());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        if ("+".equals(this.mOp) && (this.getLeft().getResolvedType().isString() || this.getRight().getResolvedType().isString())) {
            return modelAnalyzer.findClass(String.class);
        }
        return modelAnalyzer.findCommonParentOf(this.getLeft().getResolvedType(), this.getRight().getResolvedType());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public String getOp() {
        return this.mOp;
    }

    public Expr getLeft() {
        return this.getChildren().get(0);
    }

    public Expr getRight() {
        return this.getChildren().get(1);
    }
}

