/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGridGUI.Application.PropertySetEditor;
import IceGridGUI.Application.ServerInstance;
import IceGridGUI.Utils;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

class ServerInstancePropertySetEditor
extends PropertySetEditor {
    private JComboBox _id = new JComboBox();

    ServerInstancePropertySetEditor() {
        super("Service Name");
        this._id.setToolTipText("The name of the service");
        JTextField idTextField = (JTextField)this._id.getEditor().getEditorComponent();
        idTextField.getDocument().addDocumentListener(this._updateListener);
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Service Instance Property Set");
    }

    protected JComponent getIdComponent() {
        return this._id;
    }

    protected String getIdText() {
        if (this._id.getSelectedItem() == null) {
            return "";
        }
        return this._id.getSelectedItem().toString().trim();
    }

    protected void showId(String unsubstitutedId, Utils.Resolver resolver) {
        ServerInstance s = (ServerInstance)this._target.getParent();
        this._id.setEnabled(true);
        this._id.setEditable(true);
        this._id.setModel(new DefaultComboBoxModel<Object>(s.getServiceNames()));
        this._id.setSelectedItem(Utils.substitute(unsubstitutedId, resolver));
        this._id.setEditable(resolver == null);
        this._id.setEnabled(resolver == null);
    }
}

