" -*- vim -*-
" FILE: "/home/joze/.vim/autoload/Page.vim"
" LAST MODIFICATION: "Sun, 16 Sep 2001 17:16:35 +0200 (joze)"
" (C) 1999 - 2001 by Johannes Zellner, <johannes@zellner.org>
" $Id: Page.vim,v 1.4 2001/09/16 15:16:35 joze Exp $

if exists('*Page') | finish | endif

" PURPOSE:
"   - redirects the output of vim commands to a split (new) buffer.
"     most useful for searching thru long outputs as you get them
"     from `:map' or `:autocmd'.
"
" EXAMPLES:
"   :Page map
"   :Page autocmd
"
"   The temporary buffer is automatically deleted if it's left.
"
" LICENSE:
"   BSD type license: http://www.zellner.org/copyright.html
"   if you like this script type :help uganda<Enter>
"
" URL: http://www.zellner.org/vim/autoload/Page.vim


"autocmd BufLeave * if expand('<afile>')==''|bd!|endif

function! Page(...)
    let tmp = tempname()
    let more = &more
    set nomore
    if v:version >= 600
	exe 'redir >'.tmp | silent exe a:1 | redir END
    else
	exe 'redir >'.tmp | exe a:1 | redir END
    endif
    exe 'sp '.tmp
    exe 'au BufLeave '.tmp.' bd! | call delete("'.tmp.'") | au! BufLeave '.tmp
    let &more = more
endfunction

if exists('g:autoload') | finish | endif " used by the autoload generator
command! -nargs=1 Page call Page(<q-args>)
