

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: PiecewiseFlatForward.i,v 1.6 2002/01/23 14:09:25 lballabio Exp $

#ifndef quantlib_piecewise_flat_forward_i
#define quantlib_piecewise_flat_forward_i

%include TermStructures.i
%include RateHelpers.i

%{
using QuantLib::TermStructures::PiecewiseFlatForward;
typedef Handle<PiecewiseFlatForward> PiecewiseFlatForwardHandle;
%}

%name(PiecewiseFlatForward) class PiecewiseFlatForwardHandle
: public TermStructureHandle {
  public:
    // constructor redefined below
    ~PiecewiseFlatForwardHandle();
};

%addmethods PiecewiseFlatForwardHandle {
    void crash() {}
    PiecewiseFlatForwardHandle(Currency currency,
        DayCounter dayCounter, Date todaysDate,
        Calendar calendar, int settlementDays,
        RateHelperHandleVector instruments) {
	        return new PiecewiseFlatForwardHandle(
	            new PiecewiseFlatForward(currency, dayCounter,
	                todaysDate, calendar, settlementDays, instruments));
    }
    const DateVector& dates() {
        return (*self)->dates();
    }
    const DoubleVector& times() {
        return (*self)->times();
    }
}


#endif
