

/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: MarketElements.i,v 1.6 2002/01/16 14:51:31 nando Exp $

#ifndef quantlib_market_elements_i
#define quantlib_market_elements_i

%{
using QuantLib::MarketElement;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;
typedef Handle<MarketElement> MarketElementHandle;
typedef RelinkableHandle<MarketElement> MarketElementRelinkableHandle;
%}

// Export handle
%name(MarketElement) class MarketElementHandle {
  private:
    // abstract class - forbid explicit construction
    MarketElementHandle();
  public:
	~MarketElementHandle();
};

// replicate the MarketElement interface
%addmethods MarketElementHandle {
    void crash() {}
	double value() {
		return (*self)->value();
	}
}

// export relinkable handle
%name(MarketElementHandle) class MarketElementRelinkableHandle {
  public:
    MarketElementRelinkableHandle();
	~MarketElementRelinkableHandle();
	void linkTo(MarketElementHandle);
};


// actual market elements

%{
    using QuantLib::SimpleMarketElement;
    typedef Handle<SimpleMarketElement> SimpleMarketElementHandle;
%}

%name(SimpleMarketElement)
class SimpleMarketElementHandle : public MarketElementHandle {
  public:
    // constructor redefined below
    ~SimpleMarketElementHandle();
};

%addmethods SimpleMarketElementHandle {
    void crash() {}
    SimpleMarketElementHandle(double value) {
        return new SimpleMarketElementHandle(
            new SimpleMarketElement(value));
    }
    void setValue(double value) {
        (*self)->setValue(value);
    }
    %pragma(ruby) alias = "value= setValue";
}


#endif
