
#include "Python.h"
#include <windows.h>
#include <GL/gl.h>
#include <math.h>
#include "structmember.h"

#define TRY(E) if(! (E)) return NULL


// PIXELFORMATDESCRIPTOR support
class PyPIXELFORMATDESCRIPTOR : public PyObject
{
public:
	PIXELFORMATDESCRIPTOR *GetPFD() {return &m_pfd;}

	PyPIXELFORMATDESCRIPTOR(void);

	/* Python support */
	int compare(PyObject *ob);

	static void deallocFunc(PyObject *ob);

	static PyObject *getattr(PyObject *self, char *name);
	static int setattr(PyObject *self, char *name, PyObject *v);

#pragma warning( disable : 4251 )
	static struct memberlist memberlist[];
	static PyTypeObject Type;
#pragma warning( default : 4251 )

protected:
	PIXELFORMATDESCRIPTOR m_pfd;
};

PIXELFORMATDESCRIPTOR *PyObject_AsPIXELFORMATDESCRIPTOR(PyObject *ob)
{
	if (ob->ob_type != &PyPIXELFORMATDESCRIPTOR::Type) {
		PyErr_SetString(PyExc_TypeError, "Must be a PIXELFORMATDESCRIPTOR object");
		return NULL;
	}
	return ((PyPIXELFORMATDESCRIPTOR *)ob)->GetPFD();
}

// @pymethod <o PyPIXELFORMATDESCRIPTOR>|pywintypes|PIXELFORMATDESCRIPTOR|Creates a new PIXELFORMATDESCRIPTOR object
PyObject *CreatePIXELFORMATDESCRIPTOR(PyObject *self, PyObject *args)
{
	TRY( PyArg_ParseTuple(args, ":PIXELFORMATDESCRIPTOR") );
	return new PyPIXELFORMATDESCRIPTOR();
}

// @object PyPIXELFORMATDESCRIPTOR|A Python object, representing a PIXELFORMATDESCRIPTOR structure
static struct PyMethodDef PyPIXELFORMATDESCRIPTOR_methods[] = {
	{NULL}
};


PyTypeObject PyPIXELFORMATDESCRIPTOR::Type =
{
	PyObject_HEAD_INIT(&PyType_Type)
	0,
	"PyPIXELFORMATDESCRIPTOR",
	sizeof(PyPIXELFORMATDESCRIPTOR),
	0,
	PyPIXELFORMATDESCRIPTOR::deallocFunc,		/* tp_dealloc */
	0,		/* tp_print */
	PyPIXELFORMATDESCRIPTOR::getattr,				/* tp_getattr */
	PyPIXELFORMATDESCRIPTOR::setattr,				/* tp_setattr */
	0,	/* tp_compare */
	0,						/* tp_repr */
	0,						/* tp_as_number */
	0,	/* tp_as_sequence */
	0,						/* tp_as_mapping */
	0,
	0,						/* tp_call */
	0,		/* tp_str */
};

#define OFF(e) offsetof(PyPIXELFORMATDESCRIPTOR, e)

/*static*/ struct memberlist PyPIXELFORMATDESCRIPTOR::memberlist[] = {
	{"dwFlags",  T_LONG,  OFF(m_pfd.dwFlags)},
	{"iPixelType",  T_BYTE,  OFF(m_pfd.iPixelType)},
	{"cColorBits",  T_BYTE,  OFF(m_pfd.cColorBits)},
	{"cRedBits",  T_BYTE,  OFF(m_pfd.cRedBits)},
	{"cRedShift",  T_BYTE,  OFF(m_pfd.cRedShift)},
	{"cGreenBits",  T_BYTE,  OFF(m_pfd.cGreenBits)},
	{"cGreenShift",  T_BYTE,  OFF(m_pfd.cGreenShift)},
	{"cBlueBits",  T_BYTE,  OFF(m_pfd.cBlueBits)},
	{"cBlueShift",  T_BYTE,  OFF(m_pfd.cBlueShift)},
	{"cAlphaBits",  T_BYTE,  OFF(m_pfd.cAlphaBits)},
	{"cAlphaShift",  T_BYTE,  OFF(m_pfd.cAlphaShift)},
	{"cAccumBits",  T_BYTE,  OFF(m_pfd.cAccumBits)},
	{"cAccumRedBits",  T_BYTE,  OFF(m_pfd.cAccumRedBits)},
	{"cAccumGreenBits",  T_BYTE,  OFF(m_pfd.cAccumGreenBits)},
	{"cAccumBlueBits",  T_BYTE,  OFF(m_pfd.cAccumBlueBits)},
	{"cAccumAlphaBits",  T_BYTE,  OFF(m_pfd.cAccumAlphaBits)},
	{"cDepthBits",  T_BYTE,  OFF(m_pfd.cDepthBits)},
	{"cStencilBits",  T_BYTE,  OFF(m_pfd.cStencilBits)},
	{"cAuxBuffers",  T_BYTE,  OFF(m_pfd.cAuxBuffers)},
	{"iLayerType",  T_BYTE,  OFF(m_pfd.iLayerType)},
	{"bReserved",  T_BYTE,  OFF(m_pfd.bReserved)},
	{"dwLayerMask",  T_LONG,  OFF(m_pfd.dwLayerMask)},
	{"dwVisibleMask",  T_LONG,  OFF(m_pfd.dwVisibleMask)},
	{"dwDamageMask",  T_LONG,  OFF(m_pfd.dwDamageMask)},
	{NULL}	/* Sentinel */
};

PyPIXELFORMATDESCRIPTOR::PyPIXELFORMATDESCRIPTOR(void)
{
	ob_type = &Type;
	_Py_NewReference(this);
	memset(&m_pfd, 0, sizeof(m_pfd));
	m_pfd.nSize=sizeof(m_pfd);
	m_pfd.nVersion = 1;
}

PyObject *PyPIXELFORMATDESCRIPTOR::getattr(PyObject *self, char *name)
{
	PyObject *res;

	res = Py_FindMethod(PyPIXELFORMATDESCRIPTOR_methods, self, name);
	if (res != NULL)
		return res;
	PyErr_Clear();
	return PyMember_Get((char *)self, memberlist, name);
}

int PyPIXELFORMATDESCRIPTOR::setattr(PyObject *self, char *name, PyObject *v)
{
	if (v == NULL) {
		PyErr_SetString(PyExc_AttributeError, "can't delete PIXELFORMATDESCRIPTOR attributes");
		return -1;
	}
	return PyMember_Set((char *)self, memberlist, name, v);
}

/*static*/ void PyPIXELFORMATDESCRIPTOR::deallocFunc(PyObject *ob)
{
	delete (PyPIXELFORMATDESCRIPTOR *)ob;
}

/******************************************************
*
* The module
*
******************************************************/

static PyObject* _ChoosePixelFormat(PyObject* self, PyObject* args)
{
	HDC hdc;
	PyObject *obpfd;
	TRY (PyArg_ParseTuple(args, "lO", &hdc, &obpfd));
	PIXELFORMATDESCRIPTOR *pfd;
	TRY (pfd=PyObject_AsPIXELFORMATDESCRIPTOR(obpfd));
	return PyInt_FromLong( ChoosePixelFormat(hdc, pfd) );
};

static PyObject* _DescribePixelFormat(PyObject* self, PyObject* args)
{
	HDC hdc;
	int format;
	TRY (PyArg_ParseTuple(args, "li", &hdc, &format));

	PyPIXELFORMATDESCRIPTOR *pRet = new PyPIXELFORMATDESCRIPTOR();
	if (pRet==NULL) {
		PyErr_SetString(PyExc_MemoryError, "Allocating PyPIXELFORMATDESCRIPTOR");
		return NULL;
	}
	DescribePixelFormat(hdc, format, sizeof(PIXELFORMATDESCRIPTOR), pRet->GetPFD());
	return pRet;
};

static PyObject* _GetPixelFormat(PyObject* self, PyObject* args)
{
	HDC hdc;
	TRY (PyArg_ParseTuple(args, "l", &hdc));
	return PyInt_FromLong( GetPixelFormat(hdc) );
};

static PyObject* _SetPixelFormat(PyObject* self, PyObject* args)
{
	HDC hdc;
	int iFormat;
	PyObject *obpfd;
	TRY (PyArg_ParseTuple(args, "liO", &hdc, &iFormat, &obpfd));
	PIXELFORMATDESCRIPTOR *pfd;
	TRY (pfd=PyObject_AsPIXELFORMATDESCRIPTOR(obpfd));
	return PyInt_FromLong( SetPixelFormat(hdc, iFormat, pfd) );
};

static PyObject* wgl_GetCurrentContext(PyObject* self, PyObject* args)
{
	HGLRC hglrc;
	TRY (PyArg_ParseTuple(args, "")); 
	hglrc=wglGetCurrentContext();
	return PyInt_FromLong((long)hglrc);
}

static PyObject* wgl_GetCurrentDC(PyObject* self, PyObject* args)
{
	HDC hdc;
	TRY (PyArg_ParseTuple(args, "")); 
	hdc=wglGetCurrentDC();
	return PyInt_FromLong((long)hdc);
}

static PyObject* wgl_MakeCurrent(PyObject* self, PyObject* args)
{
	HDC hdc;
	HGLRC hglrc;
	TRY (PyArg_ParseTuple(args, "ll", &hdc, &hglrc)); 
	return PyInt_FromLong( wglMakeCurrent(hdc, hglrc) );
}

static PyObject* wgl_DeleteContext(PyObject* self, PyObject* args)
{
	HGLRC hglrc;
	TRY (PyArg_ParseTuple(args, "l", &hglrc)); 
	return PyInt_FromLong( wglDeleteContext(hglrc) );
}

static PyObject* wgl_CreateContext(PyObject* self, PyObject* args)
{
	HDC hdc;
	TRY (PyArg_ParseTuple(args, "l", &hdc)); 
	return PyInt_FromLong( (long)wglCreateContext(hdc) );
}

static PyObject* _SwapBuffers(PyObject* self, PyObject* args)
{
	HDC hdc;
	TRY (PyArg_ParseTuple(args, "l", &hdc)); 
	return PyInt_FromLong( SwapBuffers(hdc) );
}


static PyMethodDef wgl_methods[] = {
	{ "CreatePIXELFORMATDESCRIPTOR", CreatePIXELFORMATDESCRIPTOR, 1},
	{ "ChoosePixelFormat",   _ChoosePixelFormat, 1},
	{ "DescribePixelFormat", _DescribePixelFormat, 1},
	{ "GetPixelFormat",      _GetPixelFormat, 1},
	{ "SetPixelFormat",      _SetPixelFormat, 1},
	{ "SwapBuffers",         _SwapBuffers, 1},
	{ "wglGetCurrentContext",wgl_GetCurrentContext, 1},
	{ "wglGetCurrentDC",     wgl_GetCurrentDC, 1},
	{ "wglMakeCurrent",      wgl_MakeCurrent, 1},
	{ "wglDeleteContext",    wgl_DeleteContext, 1},
	{ "wglCreateContext",    wgl_CreateContext, 1},
  	{NULL,               NULL} 
};

extern "C" __declspec(dllexport)
void initwgl()
{
	Py_InitModule("wgl", wgl_methods);
}


