#!/usr/bin/env python

"""setup.py

Compiles and installs PyOpenGL.

"""

## created 2000/08/01, Rene Liebscher <R.Liebscher@gmx.de>

import sys,os
from distutils.sysconfig import *
from distutils.core import setup,Extension
from distutils.command.build_ext import build_ext
from distutils.command.install import install
from my_install_data import *

#######################################################################
## platform specific stuff
## see config.py for any configurable options

from config import *

#######################################################################
## test if we need to build togl
if TRY_TO_BUILD_TOGL:
    try:
        import togl_setup
        class togl_build(build_ext):
            def run(self):
                build_ext.run(self)
                # togl_build can read instance variables of build_ext
                # for example: compiler, built_temp, force, debug, dry_run, ...
                togl_setup.togl_build(self)
        class togl_install(install):
            togl_outfiles = None
            def run(self):
                install.run(self)
                # togl_install can read instance variables of install_lib
                # it has to return the filenames of all installed files
                self.togl_outfiles = togl_setup.togl_install(self) 
            def get_outputs(self):
                if self.togl_outfiles is None:
                    self.togl_outfiles = togl_setup.togl_install(self,dry_run=1)
                return install.get_outputs(self) + self.togl_outfiles              
    except ImportError:
        # either Tkinter or togl_setup doesn't exist 
        # use original classes
        togl_build = build_ext
        togl_install = install            
else:
    # use original classes
    togl_build = build_ext
    togl_install = install            

######################################################################
## test if Numpy available
try:
    import Numeric
    macros = ["-DHAVE_NUMPY"]
    python_inc = get_python_inc()
    # there seem to be different places where NumPy could have installed its 
    # header files (list taken from pygtk)
    if os.path.isfile(os.path.join(python_inc,"arrayobject.h")):
        macros.append("-DHAVE_ARRAYOBJECT_H")   
    elif os.path.isfile(os.path.join(python_inc,"Extensions","arrayobject.h")):
        macros.append("-DHAVE_EXTENSIONS_ARRAYOBJECT_H") 
    elif os.path.isfile(os.path.join(python_inc,"Numeric","arrayobject.h")): # standard ?
        macros.append("-DHAVE_NUMERIC_ARRAYOBJECT_H") 
    elif os.path.isfile(os.path.join(python_inc,"numerical","arrayobject.h")): # my freebsd
        macros.append("-DHAVE_NUMERICAL_ARRAYOBJECT_H") 
    # some extensions can only be build if NumPy is available
    numeric_gl_extensions = [
        Extension("_opengl_num", 
            [os.path.join("src","_opengl_nummodule.c")],
            libraries = gl_libs,
            library_dirs = gl_lib_dirs,
            extra_compile_args = macros,
        ),
        Extension("_glu_num", 
            [os.path.join("src","_glu_nummodule.c")],
            libraries = glu_libs,
            library_dirs = glu_lib_dirs,
            extra_compile_args = macros,
        ),
        Extension("openglutil_num", 
            [os.path.join("src","openglutil_num.c")],
            libraries = glu_libs,
            library_dirs = glu_lib_dirs,
            extra_compile_args = macros,
        ),
    ]
except ImportError:
    # no NumPy available
    numeric_gl_extensions=[]

######################################################################
## wgl is windows specific
if sys.platform == "win32":
    wgl_extension = [ # windows specific module
        Extension("wgl", 
            [os.path.join("src","wgl.cpp")],
            libraries = gl_libs + ['gdi32'],
        ),
    ]
else:
    wgl_extension = []

######################################################################
## and now the setup script

setup (name = "PyOpenGL",
       version = "1.5.7",
       description = "OpenGL bindings for Python",
       author = "PyOpenGL",
       author_email = "pyopengl@yahoogroups.com",
       url = "http://pyopengl.sourceforge.net/",

       package_dir = {'OpenGL':'py'},

        options = {'bdist_rpm':{'group':'Development/Languages/Python','source_only':1}},
       packages = [
                    'OpenGL', 
                    'OpenGL.GL',
                    'OpenGL.GLU',
                    'OpenGL.GLUT',
                    'OpenGL.Tk',
                    'OpenGL.dynload',
                    'OpenGL.Demo',
                    'OpenGL.Demo.da',
                    'OpenGL.Demo.dek',
                    'OpenGL.Demo.dek.OglSurface',
                    'OpenGL.Demo.srenner',
                    'OpenGL.Demo.srenner.Images',
                    'OpenGL.Demo.tom',
                ],
       
       ext_package = "OpenGL.dynload." + sys.platform,
       include_dirs = include_dirs,
       ext_modules = [
           Extension("_opengl", 
                [os.path.join("src","_openglmodule.c")],
                libraries=gl_libs,
                library_dirs=gl_lib_dirs,
           ),
           Extension("openglutil", 
                [os.path.join("src","openglutil.c")],
                libraries=glu_libs,
                library_dirs=glu_lib_dirs,
               ),
           Extension("_glu", 
                [os.path.join("src","_glumodule.c")],
                libraries=glu_libs,
                library_dirs=glu_lib_dirs,
               ),
           Extension("_glut", 
                [os.path.join("src","_glutmodule.c")],
                libraries=glut_libs,
                library_dirs=glut_lib_dirs,
           ),
       ] + numeric_gl_extensions + wgl_extension,

       # Overridden command classes
       cmdclass = {
            'build_ext': togl_build,
            'install': togl_install,
            # the next line is very important
            # because we use another format for data_files
            'install_data': my_install_data},
       # non python files of examples      
       data_files = [
           Data_Files(
               base_dir='install_lib',
               copy_to = 'OpenGL/Demo',
               strip_dirs = 2,
               template=[
                   # take the whole tree
                   'graft py/Demo',
                   # python files are already installed
                   'global-exclude *.py*',
                   'global-exclude Cvs/*',
                   'global-exclude CVS/*'
                   ],
               preserve_path=1
           ),
           Data_Files(
               base_dir='install_lib',
               copy_to = 'OpenGL/doc',
               strip_dirs = 1,
               template=[
                   # take the whole tree
                   'graft doc',
                   # python files are already installed
                   'global-exclude *.py*',
                   'global-exclude Cvs/*',
                   'global-exclude CVS/*'
                   ],
               preserve_path=1
           )
       ],
      )
