import os, os.path, fnmatch, sys, string
from config import emulate_posix

if sys.platform[:3] == 'win':
    import posixpath
    myfnmatch = fnmatch.fnmatch
    defaultdir = "c:\\"
    def isdir(path): # kludge to recognize single drive letters as directory
        # path is already real fs path
        return os.path.isdir(path) or (len(path)==2 and path[1]==':' and path[0] in string.letters)
    def isexec(path): # see if path is executable
        return ( isdir(path) or 
                 (os.path.splitext(string.lower(path))[1] in (".exe", ".com", ".bat"))
                )
                
    # translate visible ftp-path into real filesystem path
    def v2fs_native(path, session):
        #r = config.chrootdir + path
        if len(path)==2 and path[1]==':' and path[0] in string.letters:
            return path+"\\"
        r = os.path.normpath(path)
        return r
    
    # translate visible ftp-path into real filesystem path
    def v2fs_posix(path, session):
        #r = config.chrootdir + path
        if len(path)>2 and path[2]==":" and path[1] in string.letters:
            path = path[1:]
            if len(path) == 2:
                path=path+"/"
        r = os.path.normpath(path)
        return r

    # construct new path from cwd and path, decide if path is absolute
    def getpath_native(cwd, path):
        if len(path)==2 and path[0] in string.letters and path[1]==":":
            # because ntpath.isabs will not recognize c: as absolute path
            return path
        return os.path.normpath(os.path.join(cwd, path))

    # construct new path from cwd and path, decide if path is absolute
    def getpath_posix(cwd, path):
        return posixpath.normpath(posixpath.join(cwd, path))
    
    if emulate_posix:
        v2fs = v2fs_posix
        getpath = getpath_posix
    else:
        v2fs = v2fs_native
        getpath = getpath_native
    
else:
    myfnmatch = fnmatch.fnmatchcase
    defaultdir = "/"
    isdir = os.path.isdir
    def isexec(path):
        try:
            r = os.access(path, 1)
        except:
            try:
                r = isdir(path)
            except:
                r = 0
        return r
        
    # translate visible ftp-path into real filesystem path
    def v2fs(path, session):
        #r = config.chrootdir + path
        r = os.path.normpath(path)
        return r

    # construct new path from cwd and path, decide if path is absolute
    def getpath(cwd, path):
        return os.path.normpath(os.path.join(cwd, path))
