########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/Commands/Start.py,v 1.13 2006/02/14 03:04:24 mbrown Exp $
"""
4Suite repository start command (4ss_manager start)

Copyright 2006 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """\
The start command can be used to start any or all protocol servers.  To start
all of the servers, execute the start command with no paramters.  To bring up
individual servers, list them on the command line.
"""

from Ft.Server.Server.Commands.CommandUtil import GetRepository
from Ft.Server.Common import ResourceTypes

def Run(options, args):

    username, password, properties, repo = \
              GetRepository(options, '4ss_manager.start')

    if args.has_key('server-uri'):
        print "Setting the status of server " + args['server-uri'] + ' to running'
        server = repo.fetchResource(args['server-uri'])
        if server.resourceType != ResourceTypes.ResourceType.SERVER:
            print args['server-uri'] + " is not a server"
            repo.txRollback()
            return
        server.setRunning()
        repo.txCommit()
        return
    repo.txRollback()

    try:
        if options.get('no-daemon'):
            from Ft.Server.Server import Controller, GlobalConfig
            config = GlobalConfig.GlobalConfig(username, password,
                                               properties['CoreId'],
                                               properties['ConfigFile'],
                                               debug=1)
            controller = Controller.Controller(config)
            controller.run()
        else:
            from Ft.Server.Server import Launcher
            launcher = Launcher.Launcher(username, password, properties)
            launcher.start()
    except Exception, error:
        print str(error)
    return


def Register():
    from Ft.Lib.CommandLine import Command, Options, Arguments
    options = [Options.Option('n', 'no-daemon',
                             'Do not detach from the terminal'),
               ]

    cmd = Command.Command('start',
                          "Start the 4Suite server (controller)",
                          '',
                          __doc__,
                          function=Run,
                          fileName=__file__,
                          options=Options.Options(options),
                          arguments = [Arguments.OptionalArgument('server-uri',
								  "If specified, set the running state of this server to 'on'.  This does not start the 4ss daemon",
                                                                    str),
                                       ],
                          )
    return cmd
