########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Add/Member.py,v 1.8 2004/08/20 20:36:17 mbrown Exp $
"""
Implementation of '4ss add member' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

__doc__ = """This command adds a User to a Group in a 4Suite \
repository. If necessary, you will be prompted first for credentials \
and access info to connect to the repository."""

from Ft.Server.Client import FtServerClientException
from Ft.Server.Client.Commands import CommandUtil
from Ft.Server.Common import ResourceTypes


def Run(options,args):

    try:
        commit = False
        membername = args['memberName']
        groupname = args['groupName']
        repo = CommandUtil.GetRepository(options, '4ss.add.member')
        try:
            user = repo.fetchUserOrGroupByName(membername)
            group = repo.fetchUserOrGroupByName(groupname)
            if user is not None:
                if group is not None:
                    if group.isResourceType(ResourceTypes.ResourceType.GROUP):
                        group.addMember(user)
                        commit = True
                    else:
                        sys.stderr.write("%s is a User, not a Group.\n" % groupname)
                        sys.stderr.flush()
                else:
                    sys.stderr.write("Group %s does not exist.\n" % groupname)
                    sys.stderr.flush()
            else:
                sys.stderr.write("User %s does not exist.\n" % membername)
                sys.stderr.flush()
        finally:
            try:
                if commit:
                    repo.txCommit()
                else:
                    repo.txRollback()
            except:
                pass

    except FtServerClientException, e:
        raise


def Register():

    from Ft.Lib.CommandLine import Options, Command, Arguments

    cmd = Command.Command('member',
                          """Add a User to a Group in a repository""",
                          'developers michael',
                          __doc__,
                          function = Run,
                          arguments = [Arguments.RequiredArgument('groupName',
                                                                  "The name (not path) of the Group",
                                                                  str),
                                       Arguments.RequiredArgument('memberName',
                                                                  "The name (not path) of the User",
                                                                  str),
                                       ],

                          fileName = __file__,
                          )
    return cmd


