#include "Python.h"
#include "domlette.h"

/*Internal Interfaces*/
void Text_ReleaseNode(PyTextObject *text)
{
  Py_XDECREF(text->textData.nodeValue);
  text->textData.nodeValue = NULL;
}


/*External Interfaces*/


static struct PyMethodDef Text_methods[] = { NODE_METHODS,CHARACTERDATA_METHODS,
  {NULL,     NULL}      /* sentinel */
};




/*
  Type Interfaces
*/

static PyObject *text_getattr(PyTextObject *self, char *name)
{
  PyObject *rt = NULL;

  if (!strcmp(name,"data")) {
    rt = self->textData.nodeValue;
  }
  else if (!strcmp(name,"nodeValue")) {
    rt = self->textData.nodeValue;
  }
  else if (!strcmp(name,"nodeType")) {
    rt = g_textNodeType;
  }
  else if (!strcmp(name,"nodeName")) {
    rt = g_textNodeName;
  }
  if (rt) {
    Py_INCREF(rt);
    return rt;
  }

  return node_getattr((PyNodeObject*)self,name, Text_methods);
}


static void
text_dealloc(PyTextObject *node)
{
  node_dealloc((PyNodeObject*)node);
}


void text_build_display_string(char * buf, PyTextObject *v)
{
  sprintf(buf, "<cDomlette Text Node at %x>", (long)v);
}

static int
text_print(v, fp, flags)
     PyTextObject *v;
     FILE *fp;
     int flags; /* Not used but required by interface */
{
  char buf[256];
  text_build_display_string(buf,v);
  fputs(buf, fp);
  return 0;
}


PyTypeObject PyDomletteText_Type = {
    PyObject_HEAD_INIT(0)
    0,
    "cDomlette.Text",
    sizeof(PyTextObject),
    0,
    (destructor)text_dealloc,   /*tp_dealloc*/
    (printfunc)text_print,  /*tp_print*/
    (getattrfunc)text_getattr,  /*tp_getattr*/
    0,              /*tp_setattr*/
    0,                          /*tp_compare*/
    0,          /*tp_repr*/
    0,                          /*tp_as_number*/
    0,              /*tp_as_sequence*/
    0,              /*tp_as_mapping*/
    0,                             /*tp_hash*/
    0,          /*tp_call*/
    0,          /*tp_str*/
    0,                      /*tp_getattro*/
    0,          /*tp_setattro*/
};

