#include <fstream>
#include <string.h>
#include "test.hh"
#include "basic-cpp.hh"

using namespace Test;
using namespace std;

char *createReversedString(char const *src) {
	int length = strlen(src);
	char *end = CORBA::string_alloc(length)+length;
	*end = '\0';
	while (*src) *--end = *src++;
	return end;
	}

CORBA::ORB_ptr ORB;
PortableServer::POA_ptr POA;

struct Callback_impl : public POA_Test::Callback {
	int Calls;
	CORBA::Long Identifier;
  
	Callback_impl(long identifier)
		: Calls(0),Identifier(identifier) {
	}
	CORBA::Long call() throw(CORBA::SystemException){
		Calls++;
		return Identifier;
	}
};

struct Head_impl : public POA_Test::Head {
    Callback_impl Cbi1,Cbi2,Cbi3;
    Callback_var Cb1,Cb2,Cb3;
  
    Head_impl()
        : Cbi1(1),Cbi2(2),Cbi3(3) {
		PortableServer::ObjectId_var oid = POA->activate_object(&Cbi1);
		CORBA::Object_var cbco = POA->id_to_reference(oid);
		Cb1 = Callback::_narrow(cbco);
	  
		oid = POA->activate_object(&Cbi2);
		cbco = POA->id_to_reference(oid);
		Cb2 = Callback::_narrow(cbco);
	  
		oid = POA->activate_object(&Cbi3);
		cbco = POA->id_to_reference(oid);
		Cb3 = Callback::_narrow(cbco);
    }
    ~Head_impl() {
    }
    MyNumber returnHalf(MyNumber value,MyNumber &dbl,MyNumber &quarter)throw(CORBA::SystemException) {
		dbl *= 2;
		quarter = value/4;
		return value/2;
    }
    char *returnReverse(char const *value,char *&reverse_me_too,CORBA::String_out half_of_value) throw(CORBA::SystemException){
		char *temp = createReversedString(reverse_me_too);
		CORBA::string_free(reverse_me_too);
		reverse_me_too = temp;
		
		temp = CORBA::string_dup(value);
		int length = strlen(value);
		temp[length/2] = '\0';
		half_of_value = temp;
		
		return createReversedString(value);
    }
    void throwException() throw(CORBA::SystemException,Failure){
		throw Failure(/*"DIG THIS",0xdeadbeef*/);
    }
    Callback_ptr getCallback(Callback_ptr call_me,Callback_ptr &ccm,Callback_out ret)throw(CORBA::SystemException) {
		call_me->call();
		ccm->call();
		ccm = Callback::_duplicate(Cb2);
		ret = Callback::_duplicate(Cb3);
		return Callback::_duplicate(Cb1);
    }
    CORBA::Boolean verifyAndExit() throw(CORBA::SystemException) {
		ORB->shutdown(true);
		return Cbi1.Calls && Cbi2.Calls && Cbi3.Calls;
    }
};

BEGIN_TEST {
	try {
		CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "orbit-local-orb");
		PASSED;
	  
		CORBA::Object_var poa_ = orb->resolve_initial_references("RootPOA");
		PASSED;
	  
		PortableServer::POA_var poa = PortableServer::POA::_narrow(poa_);
		PASSED;
	  
		POA = poa;
		ORB = orb;
	  
		PortableServer::POAManager_var pm = poa->the_POAManager();
		PASSED;
	  
		pm->activate();
		PASSED;
	  
		Head_impl hi;
		
		PortableServer::ObjectId_var oid = poa->activate_object(&hi);
		CORBA::Object_var mswco = poa->id_to_reference(oid);
		// write the ior out to a file
		ofstream out("iorfile");
		out << orb->object_to_string(mswco) << flush;

		orb->run();
	}
	catch (CORBA::SystemException &ex) {
	  cout << "Caught system exception" << endl;
	}
} END_TEST
