// firfilter.h

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


// FIRFilter is an InputOutputFunction which implements a FIR filter

#ifndef FIRFILTER_H
#ifdef __GNUG__
#pragma interface
#endif
#define FIRFILTER_H

#include "iofunction.h"

class Delay;

class FIRFilter : public SimpleInputOutputFunction {
	typedef SimpleInputOutputFunction Super;
	friend class FIRFilterRequester;
public:
	FIRFilter(Data* input, Data* output, Data* coefficients);
	FIRFilter(Data* input, Data* output);
	static Modifier* create(class DataEditor *);
	virtual ~FIRFilter();
	redefined const char* message() { return "Filtering..."; }
	redefined void restoreState();
protected:
	redefined Requester* createRequester();
	redefined void initialize();
	redefined void saveConfig();
	redefined int doProcessing();
	redefined int doSimpleProcess(double *, int);
private:
	void clear();
private:
        Data *coeffData;
	double *_coeffs;
	double *_past;
	int _counter;
	int _length;
	double gain;
private:
	static double _savedGain;
};

#endif

