/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet;

/**
 * All messages resource keys should be defined in a Messages class, per package, as constants. The class is named like
 * this: XDocletMessages, or XDocletEjbDdMessages, i.e. full package name prefixed (making pointing to them easier).
 * They should not be referenced literally in any place, because it's easy to misspell it. Using Messages class means
 * this possibility is zero. Another benefit is that wherever you need to reference a resource key from another package,
 * you just use a phrase like xdoclet.ejb.Messages.class and not the literal, and that means if we refactor the code
 * (change packages) a refactoring tool like IDEA can update the references too. So even if we're pointing to external
 * resources, everything is compile time checked.
 *
 * @author    Ara Abrahamian (ara_e_w@yahoo.com)
 * @created   May 30, 2002
 * @version   $Revision: 1.16 $
 */
public final class XDocletMessages
{
    /**
     * @msg.bundle   msg="''{0}'' parameter missing or empty."
     */
    public final static String PARAMETER_MISSING_OR_EMPTY = "PARAMETER_MISSING_OR_EMPTY";

    /**
     * @msg.bundle   msg="Running {0} task failed. An IO error occured while writing context data."
     */
    public final static String CONTEXT_WRITE_ERROR = "CONTEXT_WRITE_ERROR";

    /**
     * @msg.bundle   msg="Running XDoclet failed. An IO error occured while reading context data."
     */
    public final static String CONTEXT_READ_ERROR = "CONTEXT_READ_ERROR";

    /**
     * @msg.bundle   msg="{0} attribute must be present."
     */
    public final static String ATTRIBUTE_NOT_PRESENT_ERROR = "ATTRIBUTE_NOT_PRESENT_ERROR";

    /**
     * @msg.bundle   msg="You must specify at least one fileset to indicate which files are to be processed."
     */
    public final static String NO_FILESETS = "NO_FILESETS";

    /**
     * @msg.bundle   msg="Running {0}"
     */
    public final static String RUNNING_TASKNAME = "RUNNING_TASKNAME";

    /**
     * @msg.bundle   msg="Running XDoclet failed."
     */
    public final static String RUNNING_FAILED = "RUNNING_FAILED";

    /**
     * @msg.bundle   msg="Running XDoclet failed. A needed class was not found. Configure classpath of XDoclet task
     *      properly."
     */
    public final static String INCORRECT_CLASSPATH = "INCORRECT_CLASSPATH";

    /**
     * @msg.bundle   msg="Could not instantiate SubTask class ''{0}''. Ignored. Make sure it''s in doclet''s classpath."
     */
    public final static String COULDNT_INSTANTIATE_SUBTASK = "COULDNT_INSTANTIATE_SUBTASK";

    /**
     * @msg.bundle   msg="Initializing template engine failed."
     */
    public final static String INIT_TEMPLATE_ENGINE_FAILED = "INIT_TEMPLATE_ENGINE_FAILED";

    /**
     * @msg.bundle   msg="Mandatory parameter ''{0}'' missing for {1} tag in {2} field of {3} class."
     */
    public final static String MANDATORY_TAG_PARAM_MISSING_FIELD = "MANDATORY_TAG_PARAM_MISSING_FIELD";

    /**
     * @msg.bundle   msg="Mandatory parameter ''{0}'' missing for {1} tag in constructor of {2} class."
     */
    public final static String MANDATORY_TAG_PARAM_MISSING_CONSTRUCTOR = "MANDATORY_TAG_PARAM_MISSING_CONSTRUCTOR";

    /**
     * @msg.bundle   msg="Mandatory parameter ''{0}'' missing for {1} tag in {2} class."
     */
    public final static String MANDATORY_TAG_PARAM_MISSING_CLASS = "MANDATORY_TAG_PARAM_MISSING_CLASS";

    /**
     * @msg.bundle   msg="Mandatory parameter ''{0}'' missing for {1} tag in {2} method of {3} class."
     */
    public final static String MANDATORY_TAG_PARAM_MISSING_METHOD = "MANDATORY_TAG_PARAM_MISSING_METHOD";

    /**
     * @msg.bundle   msg="Generated by XDoclet"
     */
    public final static String GENERATED_BY_XDOCLET = "GENERATED_BY_XDOCLET";

    /**
     * @msg.bundle   msg="Generated file - Do not edit!"
     */
    public final static String DO_NOT_EDIT = "DO_NOT_EDIT";

    /**
     * @msg.bundle   msg="No Description."
     */
    public final static String NO_DESCRIPTION = "NO_DESCRIPTION";

    /**
     * @msg.bundle   msg="Javadoc couldn''t load class {0}, add it to the sourcepath please."
     */
    public final static String JAVADOC_COULDNT_LOAD_CLASS = "JAVADOC_COULDNT_LOAD_CLASS";

    /**
     * @msg.bundle   msg="{0} failed."
     */
    public final static String METHOD_FAILED = "METHOD_FAILED";

    /**
     * @msg.bundle   msg="Class ''{0}'' not found. Make sure it''s added to XDoclet''s classpath."
     */
    public final static String CLASS_NOT_FOUND = "CLASS_NOT_FOUND";

    /**
     * @msg.bundle   msg="Not an XmlSubTask, so can''t use Xml namespace template tags."
     */
    public final static String NO_XML_TAGS_ALLOWED = "NO_XML_TAGS_ALLOWED";

    /**
     * @msg.bundle   msg="doc argument passed to TemplateDoclet.getText is not of type ClassDoc or MethodDoc or
     *      ConstructorDoc or FieldDoc. doc={0}"
     */
    public final static String BAD_GETTEXT_DOC_TYPE = "BAD_GETTEXT_DOC_TYPE";

    /**
     * @msg.bundle   msg="Couldn''t configure XML parser."
     */
    public final static String COULDNT_CONF_XML_PARSER = "COULDNT_CONF_XML_PARSER";

    /**
     * @msg.bundle   msg="Couldn''t load DTD."
     */
    public final static String COULDNT_LOAD_DTD = "COULDNT_LOAD_DTD";

    /**
     * @msg.bundle   msg="Couldn''t load XML file."
     */
    public final static String COULDNT_LOAD_XML_FILE = "COULDNT_LOAD_XML_FILE";

    /**
     * @msg.bundle   msg="Couldn''t initialize XML parser."
     */
    public final static String COULDNT_INIT_XML_PARSER = "COULDNT_INIT_XML_PARSER";

    /**
     * @msg.bundle   msg="WARNING: couldn''t load local DTD for publicId={0}."
     */
    public final static String COULDNT_LOAD_LOCAL_DTD = "COULDNT_LOAD_LOCAL_DTD";

    /**
     * @msg.bundle   msg="WARNING: Couldn''t find DTD in xdoclet.jar: {0}. You should set validatexml=\"false\"."
     */
    public final static String COULDNT_FIND_DTD = "COULDNT_FIND_DTD";

    /**
     * @msg.bundle   msg="''{0}'' parameter of {1} class tag expected in class {2} but not found."
     */
    public final static String CLASS_TAG_PARAMETER_EXPECTED = "CLASS_TAG_PARAMETER_EXPECTED";

    /**
     * @msg.bundle   msg="{0} class tag expected in class {1} but not found."
     */
    public final static String CLASS_TAG_EXPECTED = "CLASS_TAG_EXPECTED";

    /**
     * @msg.bundle   msg="The value ''{0}'' specified for parameter ''{1}'' of {2} tag in {3} field of {4} class is not
     *      valid. Valid values for this tag are: '{'{5}}."
     */
    public final static String INVALID_TAG_PARAM_VALUE_FIELD = "INVALID_TAG_PARAM_VALUE_FIELD";

    /**
     * @msg.bundle   msg="The value ''{0}'' specified for parameter ''{1}'' of {2} tag in constructor of {3} class is
     *      not valid. Valid values for this tag are: '{'{4}}."
     */
    public final static String INVALID_TAG_PARAM_VALUE_CONSTRUCTOR = "INVALID_TAG_PARAM_VALUE_CONSTRUCTOR";

    /**
     * @msg.bundle   msg="The value ''{0}'' specified for parameter ''{1}'' of {2} tag in {3} class is not valid. Valid
     *      values for this tag are: '{'{4}}."
     */
    public final static String INVALID_TAG_PARAM_VALUE_CLASS = "INVALID_TAG_PARAM_VALUE_CLASS";

    /**
     * @msg.bundle   msg="The value ''{0}'' specified for parameter ''{1}'' of {2} tag in {3} method of {4} class is not
     *      valid. Valid values for this tag are: '{'{5}}."
     */
    public final static String INVALID_TAG_PARAM_VALUE_METHOD = "INVALID_TAG_PARAM_VALUE_METHOD";

    /**
     * @msg.bundle   msg="What''s going on here?!?!? prg_elem_doc={0}"
     */
    public final static String BAD_PRGELEMDOC_TYPE = "BAD_PRGELEMDOC_TYPE";

    /**
     * @msg.bundle   msg="Generating output for ''{0}'' using template file ''{1}''."
     */
    public final static String GENERATING_TEMPLATE_OUTPUT_PER_CLASS = "GENERATING_TEMPLATE_OUTPUT_PER_CLASS";

    /**
     * @msg.bundle   msg="Generating output ''{0}'' using template file ''{1}''."
     */
    public final static String GENERATING_TEMPLATE_OUTPUT_SINGLE_FILE = "GENERATING_TEMPLATE_OUTPUT_SINGLE_FILE";

    /**
     * @msg.bundle   msg="Couldn''t find bean {0} in sourcepath {1}."
     */
    public final static String COULDNT_FIND_BEAN = "COULDNT_FIND_BEAN";

    /**
     * @msg.bundle   msg="Error in tag: = sign expected after parameter name, class={0}, tag={1}."
     */
    public final static String TAG_MISSING_EQUALS = "TAG_MISSING_EQUALS";

    /**
     * @msg.bundle   msg="Error in tag: parameters should be in paramName=\"paramValue\" format, class={0}, tag={1}."
     */
    public final static String TAG_MALFORMED_VALUE = "TAG_MALFORMED_VALUE";

    /**
     * @msg.bundle   msg="Error in tag: \" sign expected but something different found, class={0}, tag={1}."
     */
    public final static String TAG_QUOTE_EXPECTED = "TAG_QUOTE_EXPECTED";

    /**
     * @msg.bundle   msg="Error in tag: to put \" in a parameter value you need to escape \" character with \\,
     *      class={0}, tag={1}."
     */
    public final static String TAG_MUST_ESCAPE_QUOTES = "TAG_MUST_ESCAPE_QUOTES";

    /**
     * @msg.bundle   msg="Error in tag: trailing \" sign expected but not found, class={0}, tag={1}."
     */
    public final static String TAG_NO_CLOSING_QUOTE = "TAG_NO_CLOSING_QUOTE";

    /**
     * @msg.bundle   msg="tagName mandatory parameter in template file is null."
     */
    public final static String TEMPLATE_TAGNAME_IS_NULL = "TEMPLATE_TAGNAME_IS_NULL";

    /**
     * @msg.bundle   msg="Bad type. Should have been one of FOR_CLASS, FOR_METHOD, FOR_CONSTRUCTOR or FOR_FIELD."
     */
    public final static String BAD_TAGVALUE_TYPE = "BAD_TAGVALUE_TYPE";

    /**
     * @msg.bundle   msg="Cannot have null program element when extracting tag value."
     */
    public final static String TAGVALUE_NULL = "TAGVALUE_NULL";

    /**
     * @msg.bundle   msg="Mandatory parameter ''{0}'' missing for template tag ''{1}''."
     */
    public final static String MANDATORY_TAG_PARAM_MISSING_TEMPLATE = "MANDATORY_TAG_PARAM_MISSING_TEMPLATE";

    /**
     * @msg.bundle   msg="Generating {0}."
     */
    public final static String GENERATING_SOMETHING = "GENERATING_SOMETHING";

    /**
     * @msg.bundle   msg="Method {0} not found."
     */
    public final static String METHOD_NOT_FOUND = "METHOD_NOT_FOUND";

    /**
     * @msg.bundle   msg="{0} tag must include a {1} property."
     */
    public final static String TAG_MUST_INCLUDE_A_PROPERTY = "TAG_MUST_INCLUDE_A_PROPERTY";

    /**
     * @msg.bundle   msg="Duplicated tag {0} {1}=''{2}'' encountered. IGNORED."
     */
    public final static String DUPLICATED_TAG = "DUPLICATED_TAG";

    /**
     * @msg.bundle   msg="The {0} task doesn''t support the {1} attribute."
     */
    public final static String ATTRIBUTE_NOT_SUPPORTED = "ATTRIBUTE_NOT_SUPPORTED";

    /**
     * @msg.bundle   msg="{0} attribute is now obsolete. Please use a nested <fileset> element."
     */
    public final static String OBSOLETE_TASK_ATTRIBUTE = "PACKAGENAMES_OBSOLETE";

    /**
     * @msg.bundle   msg="Can''t create a {0} element under {1}. Make sure the jar file containing the corresponding
     *      subtask class is on the classpath specified in the <taskdef> that defined {2}."
     */
    public final static String CREATE_TASK_ERROR = "CREATE_TASK_ERROR";

    /**
     * @msg.bundle   msg="Couldn''t find class {0}: {1}"
     */
    public final static String CLASS_NOT_FOUND_EXCEPTION = "CLASS_NOT_FOUND_EXCEPTION";

    /**
     * @msg.bundle   msg="Couldn''t instantiate class {0}: {1}"
     */
    public final static String INSTANTIATION_EXCEPTION = "INSTANTIATION_EXCEPTION";

    /**
     * @msg.bundle   msg="Couldn''t invoke constructor for class {0}: {1}"
     */
    public final static String ILLEGAL_ACCESS_EXCEPTION = "ILLEGAL_ACCESS_EXCEPTION";

    /**
     * @msg.bundle   msg="XDoclet failed."
     */
    public final static String XDOCLET_FAILED = "XDOCLET_FAILED";

    /**
     * @msg.bundle   msg="Make sure the jar file containing the {0} class is on the classpath specified in the <taskdef>
     *      that defined {1}. These classes are needed in order to generate correct output."
     */
    public final static String CHECK_CLASS_FAILED = "CHECK_CLASS_FAILED";

    /**
     * @msg.bundle   msg="Ambiguous subtask definition for logical name {0}: {1} and {2}"
     */
    public final static String AMBIGUOUS_SUBTASK_DEFINITION = "AMBIGUOUS_SUBTASK_DEFINITION";

    /**
     * @msg.bundle   msg="Couldn''t find the class {0} on the classpath: {1}"
     */
    public final static String DEPENDENT_CLASS_FOR_SUBTASK_NOT_FOUND = "DEPENDENT_CLASS_FOR_SUBTASK_NOT_FOUND";

    /**
     * @msg.bundle   msg="Couldn''t cast class {0} to {1}"
     */
    public final static String CLASS_CAST_EXCEPTION = "CLASS_CAST_EXCEPTION";
}
