import ru.novosoft.uml.*;
import ru.novosoft.uml.foundation.core.*;

public class EventTest implements MElementListener
{
  public static void main (String args[]) {
    try
    {
      EventTest l = new EventTest();
      System.out.println("Starting ...");
      MFactory.setUndoPolicy(MFactory.UNDO_POLICY_ENABLED);
      MFactory.setEventPolicy(MFactory.EVENT_POLICY_IMMEDIATE);
      MCheckPoint c1 = MFactory.getCheckPoint();
      MClass cls = new MClassImpl();
      cls.addMElementListener(l);
      cls.setName("Test");
      cls.setName("Test2");
      MAttribute attr = new MAttributeImpl();
      attr.addMElementListener(l);
      attr.setType(cls);
      attr.setName("test");
      cls.addFeature(attr);
      cls.remove();
      MCheckPoint c4 = MFactory.getCheckPoint();
      System.out.println("Doing full undo ...");
      MFactory.undo(c1);
      System.out.println("Doing full redo ...");
      MFactory.redo(c4);
      System.out.println("Finished.");
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  public void propertySet(MElementEvent e)
  {
    System.out.println("object: "+e.getSource()+" property set: "+e.getName()+" val: "+e.getNewValue());
  }
  public void roleAdded(MElementEvent e)
  {
    System.out.println("object: "+e.getSource()+" role added: "+e.getName()+" val: "+e.getNewValue());
  }
  public void roleRemoved(MElementEvent e)
  {
    System.out.println("object: "+e.getSource()+" role removed: "+e.getName()+" val: "+e.getNewValue());
  }
  public void listRoleItemSet(MElementEvent e)
  {
    System.out.println("object: "+e.getSource()+" list item set: "+e.getName()+" val: "+e.getNewValue());
  }
  public void removed(MElementEvent e)
  {
    System.out.println("object: "+e.getSource()+" removed");
  }
  public void recovered(MElementEvent e)
  {
    System.out.println("object: "+e.getSource()+" recovered");
  }


}
