/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.swing.event.EventListenerList;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.jgraph.event.GraphLayoutCacheEvent;
import org.jgraph.event.GraphLayoutCacheListener;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.graph.AbstractCellView;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.CellMapper;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.EdgeView;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.ParentMap;
import org.jgraph.graph.PortView;
import org.jgraph.graph.VertexView;
import org.jgraph.util.RectUtils;

public class GraphLayoutCache
implements CellMapper,
Serializable {
    protected boolean autoSizeOnValueChange = false;
    protected boolean showsExistingConnections = true;
    protected boolean showsChangedConnections = true;
    protected boolean showsInvisibleEditedCells = false;
    protected boolean showsInsertedCells = true;
    protected boolean showsInsertedConnections = true;
    protected boolean hidesExistingConnections = true;
    protected boolean hidesDanglingConnections = false;
    protected boolean remembersCellViews = true;
    protected boolean selectsAllInsertedCells = false;
    protected boolean selectsLocalInsertedCells = false;
    protected boolean movesChildrenOnExpand = true;
    protected boolean movesParentsOnCollapse = true;
    protected boolean resizesParentsOnCollapse = false;
    protected double collapseXScale = 1.0;
    protected double collapseYScale = 1.0;
    protected boolean reconnectsEdgesToVisibleParent = false;
    protected EventListenerList listenerList = new EventListenerList();
    protected GraphModel graphModel;
    protected Map mapping = new Hashtable();
    protected transient Map hiddenMapping = new WeakHashMap();
    protected CellViewFactory factory = null;
    protected Set visibleSet = new HashSet();
    protected List roots = new ArrayList();
    protected PortView[] ports;
    protected boolean partial = false;
    protected boolean allAttributesLocal = false;
    protected Set localAttributes = new HashSet();
    static /* synthetic */ Class class$org$jgraph$event$GraphLayoutCacheListener;

    public GraphLayoutCache() {
        this(new DefaultGraphModel(), new DefaultCellViewFactory());
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory) {
        this(graphModel, cellViewFactory, false);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, boolean bl) {
        this(graphModel, cellViewFactory, null, null, bl);
    }

    public GraphLayoutCache(GraphModel graphModel, CellViewFactory cellViewFactory, CellView[] cellViewArray, CellView[] cellViewArray2, boolean bl) {
        int n;
        this.factory = cellViewFactory;
        this.partial = bl;
        if (cellViewArray != null) {
            this.graphModel = graphModel;
            for (n = 0; n < cellViewArray.length; ++n) {
                if (cellViewArray[n] == null) continue;
                this.putMapping(cellViewArray[n].getCell(), cellViewArray[n]);
                if (!bl) continue;
                this.visibleSet.add(cellViewArray[n].getCell());
            }
            this.insertViews(cellViewArray);
        } else {
            this.setModel(graphModel);
        }
        if (cellViewArray2 != null) {
            for (n = 0; n < cellViewArray2.length; ++n) {
                this.hiddenMapping.put(cellViewArray2[n].getCell(), cellViewArray2[n]);
            }
        }
    }

    public void addGraphLayoutCacheListener(GraphLayoutCacheListener graphLayoutCacheListener) {
        this.listenerList.add(class$org$jgraph$event$GraphLayoutCacheListener == null ? (class$org$jgraph$event$GraphLayoutCacheListener = GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener")) : class$org$jgraph$event$GraphLayoutCacheListener, graphLayoutCacheListener);
    }

    public void removeGraphLayoutCacheListener(GraphLayoutCacheListener graphLayoutCacheListener) {
        this.listenerList.remove(class$org$jgraph$event$GraphLayoutCacheListener == null ? (class$org$jgraph$event$GraphLayoutCacheListener = GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener")) : class$org$jgraph$event$GraphLayoutCacheListener, graphLayoutCacheListener);
    }

    public void cellViewsChanged(final CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.fireGraphLayoutCacheChanged(this, new GraphLayoutCacheEvent.GraphLayoutCacheChange(){

                public Object[] getInserted() {
                    return null;
                }

                public Object[] getRemoved() {
                    return null;
                }

                public Map getPreviousAttributes() {
                    return null;
                }

                public Object getSource() {
                    return this;
                }

                public Object[] getChanged() {
                    return cellViewArray;
                }

                public Map getAttributes() {
                    return null;
                }

                public Object[] getContext() {
                    return null;
                }

                public Rectangle2D getDirtyRegion() {
                    return null;
                }

                public void setDirtyRegion(Rectangle2D rectangle2D) {
                }
            });
        }
    }

    protected void fireGraphLayoutCacheChanged(Object object, GraphLayoutCacheEvent.GraphLayoutCacheChange graphLayoutCacheChange) {
        Object[] objectArray = this.listenerList.getListenerList();
        GraphLayoutCacheEvent graphLayoutCacheEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$org$jgraph$event$GraphLayoutCacheListener == null ? GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener") : class$org$jgraph$event$GraphLayoutCacheListener)) continue;
            if (graphLayoutCacheEvent == null) {
                graphLayoutCacheEvent = new GraphLayoutCacheEvent(object, graphLayoutCacheChange);
            }
            ((GraphLayoutCacheListener)objectArray[i + 1]).graphLayoutCacheChanged(graphLayoutCacheEvent);
        }
    }

    public GraphLayoutCacheListener[] getGraphLayoutCacheListeners() {
        return (GraphLayoutCacheListener[])this.listenerList.getListeners(class$org$jgraph$event$GraphLayoutCacheListener == null ? (class$org$jgraph$event$GraphLayoutCacheListener = GraphLayoutCache.class$("org.jgraph.event.GraphLayoutCacheListener")) : class$org$jgraph$event$GraphLayoutCacheListener);
    }

    public void setFactory(CellViewFactory cellViewFactory) {
        this.factory = cellViewFactory;
    }

    public CellViewFactory getFactory() {
        return this.factory;
    }

    public void setModel(GraphModel graphModel) {
        this.roots.clear();
        this.mapping.clear();
        this.hiddenMapping.clear();
        this.visibleSet.clear();
        this.graphModel = graphModel;
        if (!this.isPartial()) {
            Object[] objectArray = DefaultGraphModel.getRoots(this.getModel());
            CellView[] cellViewArray = this.getMapping(objectArray, true);
            this.insertViews(cellViewArray);
        }
        this.updatePorts();
        this.cellViewsChanged(this.getRoots());
    }

    public CellView[] getCellViews() {
        Collection collection = this.mapping.values();
        CellView[] cellViewArray = new CellView[collection.size()];
        collection.toArray(cellViewArray);
        return cellViewArray;
    }

    public static Rectangle2D getBounds(CellView[] cellViewArray) {
        if (cellViewArray != null && cellViewArray.length > 0) {
            Rectangle2D rectangle2D = cellViewArray[0] != null ? cellViewArray[0].getBounds() : null;
            Rectangle2D rectangle2D2 = rectangle2D != null ? (Rectangle2D)rectangle2D.clone() : null;
            for (int i = 1; i < cellViewArray.length; ++i) {
                Rectangle2D rectangle2D3 = rectangle2D = cellViewArray[i] != null ? cellViewArray[i].getBounds() : null;
                if (rectangle2D == null) continue;
                if (rectangle2D2 == null) {
                    rectangle2D2 = rectangle2D != null ? (Rectangle2D)rectangle2D.clone() : null;
                    continue;
                }
                Rectangle2D.union(rectangle2D2, rectangle2D, rectangle2D2);
            }
            return rectangle2D2;
        }
        return null;
    }

    public Object[] getCells(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        CellView[] cellViewArray = this.getCellViews();
        ArrayList<Object> arrayList = new ArrayList<Object>(cellViewArray.length);
        GraphModel graphModel = this.getModel();
        for (int i = 0; i < cellViewArray.length; ++i) {
            Object object = cellViewArray[i].getCell();
            boolean bl5 = graphModel.isEdge(object);
            if (!bl3 && graphModel.isPort(object) || ((!bl3 && !bl2 || bl5) && (!bl4 || !bl5) || !cellViewArray[i].isLeaf()) && (!bl || cellViewArray[i].isLeaf())) continue;
            arrayList.add(cellViewArray[i].getCell());
        }
        return arrayList.toArray();
    }

    public Map createNestedMap() {
        CellView[] cellViewArray = this.getCellViews();
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < cellViewArray.length; ++i) {
            hashtable.put(cellViewArray[i].getCell(), new Hashtable((Map)cellViewArray[i].getAllAttributes().clone()));
        }
        return hashtable;
    }

    public CellView[] getHiddenCellViews() {
        Collection collection = this.hiddenMapping.values();
        CellView[] cellViewArray = new CellView[collection.size()];
        collection.toArray(cellViewArray);
        return cellViewArray;
    }

    public synchronized void reload() {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        Hashtable hashtable = new Hashtable(this.mapping);
        this.mapping.clear();
        Iterator iterator = hashtable.keySet().iterator();
        HashSet hashSet = new HashSet(this.roots);
        while (iterator.hasNext()) {
            Object k = iterator.next();
            CellView cellView = (CellView)hashtable.get(k);
            CellView cellView2 = this.getMapping(k, true);
            cellView2.changeAttributes(this, cellView.getAttributes());
            if (!hashSet.contains(cellView)) continue;
            arrayList.add(cellView2);
        }
        this.hiddenMapping.clear();
        this.roots = arrayList;
    }

    public GraphModel getModel() {
        return this.graphModel;
    }

    public CellView[] getRoots() {
        CellView[] cellViewArray = new CellView[this.roots.size()];
        this.roots.toArray(cellViewArray);
        return cellViewArray;
    }

    public CellView[] getRoots(Rectangle2D rectangle2D) {
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        CellView[] cellViewArray = this.getRoots();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!cellViewArray[i].getBounds().intersects(rectangle2D)) continue;
            arrayList.add(cellViewArray[i]);
        }
        cellViewArray = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray);
        return cellViewArray;
    }

    public Object[] getVisibleCells(Object[] objectArray) {
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isVisible(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
            }
            return arrayList.toArray();
        }
        return null;
    }

    public PortView[] getPorts() {
        return this.ports;
    }

    protected void updatePorts() {
        Object[] objectArray = DefaultGraphModel.getRoots(this.graphModel);
        List list = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
        if (list != null) {
            ArrayList<CellView> arrayList = new ArrayList<CellView>();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                CellView cellView;
                Object e = iterator.next();
                if (!this.graphModel.isPort(e) || (cellView = this.getMapping(e, false)) == null) continue;
                arrayList.add(cellView);
                cellView.refresh(this, this, false);
            }
            this.ports = new PortView[arrayList.size()];
            arrayList.toArray(this.ports);
        }
    }

    public void refresh(CellView[] cellViewArray, boolean bl) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void refresh(CellView cellView, boolean bl) {
        if (cellView != null) {
            cellView.refresh(this, this, bl);
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.refresh(cellViewArray[i], bl);
            }
        }
    }

    public void update(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void update(CellView cellView) {
        if (cellView != null) {
            cellView.update(this);
            CellView[] cellViewArray = cellView.getChildViews();
            for (int i = 0; i < cellViewArray.length; ++i) {
                this.update(cellViewArray[i]);
            }
        }
    }

    public void graphChanged(GraphModelEvent.GraphModelChange graphModelChange) {
        CellView[] cellViewArray = graphModelChange.getViews(this);
        if (cellViewArray != null) {
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                this.mapping.put(cellViewArray[i].getCell(), cellViewArray[i]);
            }
            this.setVisibleImpl(this.getCells(cellViewArray), true);
        }
        Object[] objectArray = graphModelChange.getChanged();
        this.getMapping(graphModelChange.getInserted(), true);
        cellViewArray = this.removeCells(graphModelChange.getRemoved());
        graphModelChange.putViews(this, cellViewArray);
        if (this.isPartial()) {
            this.showCellsForChange(graphModelChange);
            this.hideCellsForChange(graphModelChange);
        }
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                CellView cellView = this.getMapping(objectArray[i], false);
                if (cellView == null) continue;
                cellView.refresh(this, this, true);
                this.update(cellView);
            }
        }
        this.reloadRoots();
        this.refresh(this.getMapping(this.getContext(graphModelChange), false), false);
        this.updatePorts();
    }

    protected void reloadRoots() {
        Object[] objectArray = DefaultGraphModel.getAll(this.graphModel);
        ArrayList<CellView> arrayList = new ArrayList<CellView>();
        for (int i = 0; i < objectArray.length; ++i) {
            CellView cellView = this.getMapping(objectArray[i], false);
            if (cellView == null) continue;
            cellView.refresh(this, this, true);
            if (cellView.getParentView() != null) continue;
            arrayList.add(cellView);
        }
        this.roots = arrayList;
    }

    protected Object[] getContext(GraphModelEvent.GraphModelChange graphModelChange) {
        return graphModelChange.getContext();
    }

    protected void hideCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Object[] objectArray = graphModelChange.getRemoved();
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                hashSet.add(objectArray[i]);
            }
        }
        if (this.hidesDanglingConnections || this.hidesExistingConnections) {
            Object[] objectArray2 = graphModelChange.getChanged();
            for (int i = 0; i < objectArray2.length; ++i) {
                boolean bl;
                CellView cellView = this.getMapping(objectArray2[i], false);
                if (!(cellView instanceof EdgeView)) continue;
                EdgeView edgeView = (EdgeView)cellView;
                Object object = edgeView.getSource() == null ? null : edgeView.getSource().getCell();
                Object object2 = edgeView.getTarget() == null ? null : edgeView.getTarget().getCell();
                Object object3 = this.graphModel.getSource(objectArray2[i]);
                Object object4 = this.graphModel.getTarget(objectArray2[i]);
                boolean bl2 = bl = this.hidesExistingConnections && (object3 != null && !this.hasVisibleParent(object3, null) || object4 != null && !this.hasVisibleParent(object4, null));
                if ((!this.hidesDanglingConnections || !hashSet.contains(object) && !hashSet.contains(object2)) && !bl) continue;
                this.setVisibleImpl(new Object[]{objectArray2[i]}, false);
            }
        }
    }

    protected boolean hasVisibleParent(Object object, Set set) {
        boolean bl = false;
        do {
            bl = set == null || !set.contains(object) ? this.isVisible(object) : false;
        } while ((object = this.getModel().getParent(object)) != null && !bl);
        return bl;
    }

    protected void showCellsForChange(GraphModelEvent.GraphModelChange graphModelChange) {
        Set set;
        Object object;
        Object[] objectArray = graphModelChange.getInserted();
        if (objectArray != null && this.showsInsertedConnections) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.isVisible(objectArray[i])) continue;
                object = this.graphModel.getSource(objectArray[i]);
                Object object2 = this.graphModel.getTarget(objectArray[i]);
                if (object == null && object2 == null || !this.isVisible(object) || !this.isVisible(object2)) continue;
                this.setVisibleImpl(new Object[]{objectArray[i]}, true);
            }
        }
        if (graphModelChange.getConnectionSet() != null && (set = graphModelChange.getConnectionSet().getChangedEdges()) != null && this.showsChangedConnections) {
            object = set.toArray();
            for (int i = 0; i < ((Object[])object).length; ++i) {
                if (this.isVisible(object[i])) continue;
                Object object3 = this.graphModel.getSource(object[i]);
                Object object4 = this.graphModel.getTarget(object[i]);
                if (object3 == null && object4 == null || !this.isVisible(object3) || !this.isVisible(object4) || this.isVisible(object[i])) continue;
                this.setVisibleImpl(new Object[]{object[i]}, true);
            }
        }
    }

    public void insertViews(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            this.refresh(cellViewArray, true);
            for (int i = 0; i < cellViewArray.length; ++i) {
                Object object;
                if (cellViewArray[i] == null || this.getMapping(cellViewArray[i].getCell(), false) == null) continue;
                CellView cellView = cellViewArray[i].getParentView();
                Object object2 = object = cellView != null ? cellView.getCell() : null;
                if (this.graphModel.isPort(cellViewArray[i].getCell()) || object != null) continue;
                this.roots.add(cellViewArray[i]);
            }
        }
    }

    public CellView[] removeCells(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            int n;
            CellView[] cellViewArray = new CellView[objectArray.length];
            HashSet<CellView> hashSet = null;
            for (n = 0; n < objectArray.length; ++n) {
                cellViewArray[n] = this.removeMapping(objectArray[n]);
                if (cellViewArray[n] == null) continue;
                cellViewArray[n].removeFromParent();
                if (hashSet == null) {
                    hashSet = new HashSet<CellView>();
                }
                hashSet.add(cellViewArray[n]);
                this.visibleSet.remove(cellViewArray[n].getCell());
            }
            if (hashSet != null && hashSet.size() > 0) {
                n = this.roots.size() - hashSet.size();
                if (n < 8) {
                    n = 8;
                }
                ArrayList arrayList = new ArrayList(n);
                Iterator iterator = this.roots.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (hashSet.contains(e)) continue;
                    arrayList.add(e);
                }
                this.roots = arrayList;
            }
            return cellViewArray;
        }
        return null;
    }

    public Object[] getCells(CellView[] cellViewArray) {
        if (cellViewArray != null) {
            Object[] objectArray = new Object[cellViewArray.length];
            for (int i = 0; i < cellViewArray.length; ++i) {
                if (cellViewArray[i] == null) continue;
                objectArray[i] = cellViewArray[i].getCell();
            }
            return objectArray;
        }
        return null;
    }

    public CellView getMapping(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        CellView cellView = (CellView)this.mapping.get(object);
        if (cellView == null && bl && this.isVisible(object)) {
            cellView = (CellView)this.hiddenMapping.get(object);
            if (cellView != null) {
                this.putMapping(object, cellView);
                this.hiddenMapping.remove(object);
            } else {
                cellView = this.factory.createView(this.graphModel, object);
                this.putMapping(object, cellView);
                cellView.refresh(this, this, true);
                cellView.update(this);
            }
        }
        return cellView;
    }

    public CellView[] getMapping(Object[] objectArray) {
        return this.getMapping(objectArray, false);
    }

    public CellView[] getMapping(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            CellView[] cellViewArray = new CellView[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                cellViewArray[i] = this.getMapping(objectArray[i], bl);
            }
            return cellViewArray;
        }
        return null;
    }

    public void putMapping(Object object, CellView cellView) {
        if (object != null && cellView != null) {
            this.mapping.put(object, cellView);
        }
    }

    public CellView removeMapping(Object object) {
        if (object != null) {
            CellView cellView = (CellView)this.mapping.remove(object);
            return cellView;
        }
        return null;
    }

    public boolean isVisible(Object object) {
        return !this.isPartial() || this.visibleSet.contains(object) || object == null;
    }

    public Set getVisibleSet() {
        return new HashSet(this.visibleSet);
    }

    public void setVisibleSet(Set set) {
        this.visibleSet = set;
    }

    public void setVisible(Object object, boolean bl) {
        this.setVisible(new Object[]{object}, bl);
    }

    public void setVisible(Object[] objectArray, boolean bl) {
        if (bl) {
            this.setVisible(objectArray, null);
        } else {
            this.setVisible(null, objectArray);
        }
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2) {
        this.setVisible(objectArray, objectArray2, null);
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2, ConnectionSet connectionSet) {
        this.setVisible(objectArray, objectArray2, null, connectionSet);
    }

    public void setVisible(Object[] objectArray, Object[] objectArray2, Map map, ConnectionSet connectionSet) {
        GraphLayoutCacheEdit graphLayoutCacheEdit = new GraphLayoutCacheEdit(null, map, objectArray, objectArray2);
        graphLayoutCacheEdit.end();
        this.graphModel.edit(map, connectionSet, null, new UndoableEdit[]{graphLayoutCacheEdit});
    }

    protected Object[] addVisibleDependencies(Object[] objectArray, boolean bl) {
        if (objectArray != null) {
            if (bl) {
                Object object;
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.add(objectArray[i]);
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    object = this.getParentPorts(this.graphModel.getSource(objectArray[i]));
                    if (object != null) {
                        hashSet.addAll((Collection<Object>)object);
                    }
                    if ((object = this.getParentPorts(this.graphModel.getTarget(objectArray[i]))) == null) continue;
                    hashSet.addAll((Collection<Object>)object);
                }
                if (this.showsExistingConnections) {
                    Set set = DefaultGraphModel.getEdges(this.getModel(), objectArray);
                    object = set.iterator();
                    while (object.hasNext()) {
                        Object e = object.next();
                        Object object2 = this.graphModel.getSource(e);
                        Object object3 = this.graphModel.getTarget(e);
                        if (!this.isVisible(object2) && !hashSet.contains(object2) || !this.isVisible(object3) && !hashSet.contains(object3)) continue;
                        hashSet.add(e);
                    }
                }
                hashSet.removeAll(this.visibleSet);
                hashSet.remove(null);
                return hashSet.toArray();
            }
            if (this.hidesExistingConnections) {
                HashSet<Object> hashSet = new HashSet<Object>();
                for (int i = 0; i < objectArray.length; ++i) {
                    hashSet.addAll(this.getPorts(objectArray[i]));
                    hashSet.add(objectArray[i]);
                }
                Iterator iterator = DefaultGraphModel.getEdges(this.graphModel, objectArray).iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    Object object = this.graphModel.getSource(e);
                    Object object4 = this.graphModel.getTarget(e);
                    if ((object == null || this.hasVisibleParent(object, hashSet)) && (object4 == null || this.hasVisibleParent(object4, hashSet))) continue;
                    hashSet.add(e);
                }
                hashSet.remove(null);
                return hashSet.toArray();
            }
        }
        return objectArray;
    }

    public boolean setVisibleImpl(Object[] objectArray, boolean bl) {
        if ((objectArray = this.addVisibleDependencies(objectArray, bl)) != null && this.isPartial()) {
            boolean bl2 = false;
            CellView[] cellViewArray = new CellView[objectArray.length];
            if (!bl) {
                cellViewArray = this.removeCells(objectArray);
            }
            HashSet hashSet = null;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null) continue;
                if (bl) {
                    this.visibleSet.add(objectArray[i]);
                    cellViewArray[i] = this.getMapping(objectArray[i], true);
                    continue;
                }
                if (cellViewArray[i] == null) continue;
                if (hashSet == null) {
                    hashSet = new HashSet(DefaultGraphModel.getRootsAsCollection(this.getModel()));
                }
                if (hashSet.contains(cellViewArray[i].getCell()) && this.remembersCellViews) {
                    this.hiddenMapping.put(cellViewArray[i].getCell(), cellViewArray[i]);
                }
                bl2 = true;
            }
            if (bl) {
                Object object;
                Object object2;
                HashSet<CellView> hashSet2 = new HashSet<CellView>();
                HashSet<CellView> hashSet3 = null;
                for (int i = 0; i < cellViewArray.length; ++i) {
                    if (cellViewArray[i] == null) continue;
                    object2 = cellViewArray[i];
                    object = AbstractCellView.getDescendantViews(new CellView[]{object2});
                    for (int j = 0; j < ((CellView[])object).length; ++j) {
                        if (hashSet3 == null) {
                            hashSet3 = new HashSet<CellView>();
                        }
                        hashSet3.add(object[j]);
                    }
                    object2.refresh(this, this, false);
                    CellView cellView = object2.getParentView();
                    if (cellView != null) {
                        hashSet2.add(cellView);
                    }
                    bl2 = true;
                }
                if (hashSet3 != null && hashSet3.size() > 0) {
                    ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
                    object2 = this.roots.iterator();
                    while (object2.hasNext()) {
                        object = object2.next();
                        if (hashSet3.contains(object)) continue;
                        arrayList.add((CellView[])object);
                    }
                    this.roots = arrayList;
                }
                CellView[] cellViewArray2 = new CellView[hashSet2.size()];
                hashSet2.toArray(cellViewArray2);
                this.refresh(cellViewArray2, true);
            }
            return bl2;
        }
        return false;
    }

    protected Collection getParentPorts(Object object) {
        Object object2 = this.graphModel.getParent(object);
        while (object2 != null) {
            if (this.isVisible(object2)) {
                return null;
            }
            object2 = this.graphModel.getParent(object2);
        }
        object2 = this.graphModel.getParent(object);
        Collection collection = this.getPorts(object2);
        collection.add(object2);
        return collection;
    }

    protected Collection getPorts(Object object) {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (int i = 0; i < this.graphModel.getChildCount(object); ++i) {
            Object object2 = this.graphModel.getChild(object, i);
            if (!this.graphModel.isPort(object2)) continue;
            linkedList.add(object2);
        }
        return linkedList;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public boolean getPartial() {
        return this.isPartial();
    }

    public void valueForCellChanged(Object object, Object object2) {
        Map map = null;
        if (this.isAutoSizeOnValueChange()) {
            CellView cellView = this.getMapping(object, false);
            if (cellView != null) {
                AttributeMap attributeMap = cellView.getAllAttributes();
                Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
                Rectangle2D rectangle2D2 = null;
                rectangle2D2 = rectangle2D != null ? attributeMap.createRect(rectangle2D.getX(), rectangle2D.getY(), 0.0, 0.0) : attributeMap.createRect(0.0, 0.0, 0.0, 0.0);
                map = GraphConstants.createAttributes(new Object[]{object}, new Object[]{"resize", "bounds"}, new Object[]{Boolean.TRUE, rectangle2D2});
            }
        } else {
            map = new Hashtable();
            map.put(object, new Hashtable());
        }
        this.augmentNestedMapForValueChange(map, object, object2);
        this.edit(map, null, null, null);
    }

    protected void augmentNestedMapForValueChange(Map map, Object object, Object object2) {
        Map map2 = (Map)map.get(object);
        if (map2 != null) {
            GraphConstants.setValue(map2, object2);
        }
    }

    public void insert(Object[] objectArray, Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        Object object;
        Object[] objectArray2 = null;
        if (this.isPartial() && this.showsInsertedCells) {
            object = DefaultGraphModel.getDescendants(this.graphModel, objectArray);
            object.removeAll(this.visibleSet);
            if (!object.isEmpty()) {
                objectArray2 = object.toArray();
            }
        }
        if ((object = this.createLocalEdit(objectArray, map, objectArray2, null)) != null) {
            undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)object);
        }
        this.graphModel.insert(objectArray, map, connectionSet, parentMap, undoableEditArray);
    }

    public Object[] insertClones(Object[] objectArray, Map map, Map map2, ConnectionSet connectionSet, ParentMap parentMap, double d, double d2) {
        if (objectArray != null) {
            if (connectionSet != null) {
                connectionSet = connectionSet.clone(map);
            }
            if (parentMap != null) {
                parentMap = parentMap.clone(map);
            }
            if (map2 != null) {
                map2 = GraphConstants.replaceKeys(map, map2);
                AttributeMap.translate(map2.values(), d, d2);
            }
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = map.get(objectArray[i]);
            }
            this.insert(objectArray2, map2, connectionSet, parentMap, null);
            return objectArray2;
        }
        return null;
    }

    public void insert(Object object) {
        this.insert(new Object[]{object});
    }

    public void insertEdge(Object object, Object object2, Object object3) {
        this.insert(new Object[]{object}, new Hashtable(), new ConnectionSet(object, object2, object3), new ParentMap());
    }

    public void insert(Object[] objectArray) {
        this.insert(objectArray, new Hashtable(), new ConnectionSet(), new ParentMap());
    }

    public void insert(Object[] objectArray, Map hashtable, ConnectionSet connectionSet, ParentMap parentMap) {
        if (objectArray != null) {
            if (hashtable == null) {
                hashtable = new Hashtable<Object, Object>();
            }
            if (connectionSet == null) {
                connectionSet = new ConnectionSet();
            }
            if (parentMap == null) {
                parentMap = new ParentMap();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                Object object2;
                Object object3;
                int n = this.getModel().getChildCount(objectArray[i]);
                for (int j = 0; j < n; ++j) {
                    object3 = this.getModel().getChild(objectArray[i], j);
                    parentMap.addEntry(object3, objectArray[i]);
                    object2 = this.getModel().getAttributes(object3);
                    if (object2 == null) continue;
                    hashtable.put(object3, object2);
                }
                Map map = (Map)hashtable.get(objectArray[i]);
                object3 = this.getModel().getAttributes(objectArray[i]);
                if (map != null) {
                    object3.putAll(map);
                }
                hashtable.put(objectArray[i], object3);
                object2 = this.getModel().getSource(objectArray[i]);
                if (object2 != null) {
                    connectionSet.connect(objectArray[i], object2, true);
                }
                if ((object = this.getModel().getTarget(objectArray[i])) == null) continue;
                connectionSet.connect(objectArray[i], object, false);
            }
            objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            this.insert(objectArray, hashtable, connectionSet, parentMap, null);
        }
    }

    public void insertGroup(Object object, Object[] objectArray) {
        if (object != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length + 1);
            if (!this.getModel().contains(object)) {
                arrayList.add(object);
            }
            ParentMap parentMap = new ParentMap();
            for (int i = 0; i < objectArray.length; ++i) {
                parentMap.addEntry(objectArray[i], object);
                if (this.getModel().contains(objectArray[i])) continue;
                arrayList.add(objectArray[i]);
                AttributeMap attributeMap = this.getModel().getAttributes(objectArray[i]);
                if (attributeMap == null) continue;
                hashtable.put(objectArray[i], attributeMap);
            }
            if (arrayList.isEmpty()) {
                this.edit(hashtable, null, parentMap, null);
            } else {
                this.insert(arrayList.toArray(), hashtable, null, parentMap);
            }
        }
    }

    public void remove(Object[] objectArray) {
        this.graphModel.remove(objectArray);
    }

    public void remove(Object[] objectArray, boolean bl, boolean bl2) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl2) {
                Object[] objectArray2 = DefaultGraphModel.getEdges(this.getModel(), objectArray).toArray();
                Object[] objectArray3 = new Object[objectArray.length + objectArray2.length];
                System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
                System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
                objectArray = objectArray3;
            }
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.remove(objectArray);
        }
    }

    public void hideCells(Object[] objectArray, boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.setVisible(objectArray, false);
        }
    }

    public void showCells(Object[] objectArray, boolean bl) {
        if (objectArray != null && objectArray.length > 0) {
            if (bl) {
                objectArray = DefaultGraphModel.getDescendants(this.getModel(), objectArray).toArray();
            }
            this.setVisible(objectArray, true);
        }
    }

    public Object[] ungroup(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            boolean bl = false;
            for (int i = 0; i < objectArray.length; ++i) {
                boolean bl2 = false;
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                for (int j = 0; j < this.getModel().getChildCount(objectArray[i]); ++j) {
                    Object object = this.getModel().getChild(objectArray[i], j);
                    if (!this.getModel().isPort(object)) {
                        arrayList2.add(object);
                        bl2 = true;
                        continue;
                    }
                    arrayList3.add(object);
                }
                if (!bl2) continue;
                arrayList.addAll(arrayList3);
                arrayList.add(objectArray[i]);
                bl = true;
            }
            if (bl) {
                this.remove(arrayList.toArray());
            }
            return arrayList2.toArray();
        }
        return null;
    }

    public void toggleCollapsedState(Object[] objectArray, boolean bl, boolean bl2) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            CellView cellView = this.getMapping(object, false);
            if (cellView == null) continue;
            if (cellView.isLeaf() && !bl) {
                arrayList.add(cellView.getCell());
                continue;
            }
            if (cellView.isLeaf() || bl2) continue;
            arrayList2.add(cellView.getCell());
        }
        if (!arrayList2.isEmpty() || !arrayList.isEmpty()) {
            this.setCollapsedState(arrayList2.toArray(), arrayList.toArray());
        }
    }

    public void collapse(Object[] objectArray) {
        this.setCollapsedState(objectArray, null);
    }

    public void expand(Object[] objectArray) {
        this.setCollapsedState(null, objectArray);
    }

    public void setCollapsedState(Object[] objectArray, Object[] objectArray2) {
        int n;
        int n2;
        ConnectionSet connectionSet = new ConnectionSet();
        List list = DefaultGraphModel.getDescendants(this.getModel(), objectArray);
        if (objectArray != null) {
            int n3;
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                list.remove(objectArray[n3]);
                this.cellWillCollapse(objectArray[n3]);
            }
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                n2 = this.getModel().getChildCount(objectArray[n3]);
                if (n2 <= 0) continue;
                for (n = 0; n < n2; ++n) {
                    Object object = this.getModel().getChild(objectArray[n3], n);
                    if (!this.getModel().isPort(object)) continue;
                    list.remove(object);
                }
            }
        }
        HashSet<Object> hashSet = new HashSet<Object>();
        if (objectArray2 != null) {
            for (n2 = 0; n2 < objectArray2.length; ++n2) {
                n = this.getModel().getChildCount(objectArray2[n2]);
                for (int i = 0; i < n; ++i) {
                    hashSet.add(this.getModel().getChild(objectArray2[n2], i));
                }
            }
        }
        this.setVisible(hashSet.toArray(), list != null ? list.toArray() : null, connectionSet);
    }

    protected Object getParentPort(Object object, boolean bl) {
        int n;
        Object object2 = this.getModel().getParent(bl ? DefaultGraphModel.getSourceVertex(this.getModel(), object) : DefaultGraphModel.getTargetVertex(this.getModel(), object));
        int n2 = this.getModel().getChildCount(object2);
        int n3 = n = bl ? n2 - 1 : 0;
        while (n < this.getModel().getChildCount(object2) && n >= 0) {
            Object object3 = this.getModel().getChild(object2, n);
            if (this.getModel().isPort(object3)) {
                return object3;
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    protected Object getChildPort(Object object, boolean bl) {
        int n;
        GraphModel graphModel = this.getModel();
        Object object2 = bl ? DefaultGraphModel.getSourceVertex(graphModel, object) : DefaultGraphModel.getTargetVertex(graphModel, object);
        int n2 = graphModel.getChildCount(object2);
        int n3 = n = bl ? n2 - 1 : 0;
        while (n < n2 && n >= 0) {
            Object object3 = graphModel.getChild(object2, n);
            if (!graphModel.isEdge(object3) && !graphModel.isPort(object3)) {
                for (int i = 0; i < graphModel.getChildCount(object3); ++i) {
                    Object object4 = graphModel.getChild(object3, i);
                    if (!graphModel.isPort(object4)) continue;
                    return object4;
                }
            }
            n += bl ? -1 : 1;
        }
        return null;
    }

    public void edit(Map map, ConnectionSet connectionSet, ParentMap parentMap, UndoableEdit[] undoableEditArray) {
        if (map != null || connectionSet != null || parentMap != null || undoableEditArray != null) {
            Serializable serializable;
            Object[] objectArray = null;
            if (this.isPartial() && this.showsInvisibleEditedCells) {
                serializable = new HashSet();
                if (map != null) {
                    serializable.addAll(map.keySet());
                }
                if (connectionSet != null) {
                    serializable.addAll(connectionSet.getChangedEdges());
                }
                if (parentMap != null) {
                    serializable.addAll(parentMap.getChangedNodes());
                }
                serializable.removeAll(this.visibleSet);
                if (!serializable.isEmpty()) {
                    objectArray = serializable.toArray();
                }
            }
            if ((serializable = this.createLocalEdit(null, map, objectArray, null)) != null) {
                undoableEditArray = this.augment(undoableEditArray, (UndoableEdit)((Object)serializable));
            }
            this.graphModel.edit(map, connectionSet, parentMap, undoableEditArray);
        }
    }

    public void edit(Map map) {
        this.edit(map, null, null, null);
    }

    public void edit(Object[] objectArray, Map map) {
        if (map != null && objectArray != null && objectArray.length > 0) {
            Hashtable<Object, Map> hashtable = new Hashtable<Object, Map>();
            for (int i = 0; i < objectArray.length; ++i) {
                hashtable.put(objectArray[i], map);
            }
            this.edit(hashtable, null, null, null);
        }
    }

    public void editCell(Object object, Map map) {
        if (map != null && object != null) {
            this.edit(new Object[]{object}, map);
        }
    }

    protected UndoableEdit[] augment(UndoableEdit[] undoableEditArray, UndoableEdit undoableEdit) {
        if (undoableEdit != null) {
            int n = undoableEditArray != null ? undoableEditArray.length + 1 : 1;
            UndoableEdit[] undoableEditArray2 = new UndoableEdit[n];
            if (undoableEditArray != null) {
                System.arraycopy(undoableEditArray, 0, undoableEditArray2, 0, n - 2);
            }
            undoableEditArray2[n - 1] = undoableEdit;
            return undoableEditArray2;
        }
        return undoableEditArray;
    }

    public void toBack(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toBack(objectArray);
        }
    }

    public void toFront(Object[] objectArray) {
        if (objectArray != null && objectArray.length > 0) {
            this.graphModel.toFront(objectArray);
        }
    }

    protected GraphLayoutCacheEdit createLocalEdit(Object[] objectArray, Map map, Object[] objectArray2, Object[] objectArray3) {
        if (!(map == null || map.isEmpty() || this.localAttributes.isEmpty() && !this.isAllAttributesLocal())) {
            Object object;
            Hashtable hashtable = new Hashtable();
            Hashtable hashtable2 = new Hashtable();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Hashtable hashtable3 = new Hashtable();
                object = iterator.next();
                Object k = object.getKey();
                Map map2 = (Map)object.getValue();
                CellView cellView = this.getMapping(k, false);
                if (cellView != null) {
                    map2 = cellView.getAllAttributes().diff(map2);
                }
                Iterator iterator2 = map2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry entry = iterator2.next();
                    Object k2 = entry.getKey();
                    Object v = entry.getValue();
                    boolean bl = this.isControlAttribute(k, k2, v);
                    if (!this.isAllAttributesLocal() && !bl && !this.isLocalAttribute(k, k2, v)) continue;
                    hashtable3.put(k2, v);
                    if (bl) continue;
                    iterator2.remove();
                }
                if (!hashtable3.isEmpty()) {
                    hashtable2.put(k, hashtable3);
                }
                if (map2.isEmpty()) continue;
                hashtable.put(k, map2);
            }
            map.clear();
            map.putAll(hashtable);
            if (objectArray2 != null || objectArray3 != null || !hashtable2.isEmpty()) {
                object = new GraphLayoutCacheEdit(objectArray, new Hashtable(hashtable2), objectArray2, objectArray3);
                ((CompoundEdit)object).end();
                return object;
            }
        } else if (objectArray2 != null || objectArray3 != null) {
            GraphLayoutCacheEdit graphLayoutCacheEdit = new GraphLayoutCacheEdit(objectArray, null, objectArray2, objectArray3);
            graphLayoutCacheEdit.end();
            return graphLayoutCacheEdit;
        }
        return null;
    }

    protected boolean isLocalAttribute(Object object, Object object2, Object object3) {
        return this.localAttributes.contains(object2);
    }

    protected boolean isControlAttribute(Object object, Object object2, Object object3) {
        return "removeAll".equals(object2) || "removeAttributes".equals(object2);
    }

    public boolean removeViewLocalAttribute(Object object, boolean bl, boolean bl2) {
        if (this.localAttributes.contains(object)) {
            if (bl) {
                this.copyRemovedViewValue(object, bl, bl2, this.mapping.values());
                this.copyRemovedViewValue(object, bl, bl2, this.hiddenMapping.values());
            }
            this.localAttributes.remove(object);
            return true;
        }
        return false;
    }

    private void copyRemovedViewValue(Object object, boolean bl, boolean bl2, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object2;
            AttributeMap attributeMap;
            CellView cellView = (CellView)iterator.next();
            AttributeMap attributeMap2 = cellView.getAttributes();
            if (!attributeMap2.containsKey(object)) continue;
            if (bl && (attributeMap = this.graphModel.getAttributes(object2 = cellView.getCell())) != null) {
                boolean bl3 = attributeMap.containsKey(object);
                if (!bl2 || !bl3) {
                    Object v = attributeMap2.get(object);
                    attributeMap.put(object, v);
                }
            }
            attributeMap2.remove(object);
        }
    }

    protected void cellExpanded(Object object) {
        CellView cellView;
        CellView cellView2;
        GraphModel graphModel = this.getModel();
        if (this.movesChildrenOnExpand && !graphModel.isPort(object) && (cellView2 = this.getMapping(object, false)) != null && (cellView = this.getMapping(graphModel.getParent(object), false)) != null && DefaultGraphModel.isVertex(graphModel, cellView)) {
            Rectangle2D rectangle2D = GraphConstants.getBounds(cellView.getAllAttributes());
            Rectangle2D rectangle2D2 = cellView.getBounds();
            if (rectangle2D2 != null && rectangle2D != null) {
                double d = rectangle2D.getX() - rectangle2D2.getX();
                double d2 = rectangle2D.getY() - rectangle2D2.getY();
                AttributeMap attributeMap = cellView2.getAttributes();
                if (!attributeMap.contains("bounds")) {
                    attributeMap = graphModel.getAttributes(cellView2.getCell());
                }
                attributeMap.translate(d, d2);
            }
        }
    }

    protected void cellWillCollapse(Object object) {
        CellView cellView;
        GraphModel graphModel = this.getModel();
        if (this.movesParentsOnCollapse && (cellView = this.getMapping(object, false)) != null && !cellView.isLeaf()) {
            AttributeMap attributeMap = cellView.getAttributes();
            if (!attributeMap.contains("bounds") && !this.localAttributes.contains("bounds")) {
                attributeMap = graphModel.getAttributes(object);
            }
            Rectangle2D rectangle2D = GraphConstants.getBounds(attributeMap);
            Rectangle2D rectangle2D2 = cellView.getBounds();
            if (this.resizesParentsOnCollapse || rectangle2D == null || rectangle2D.equals(VertexView.defaultBounds)) {
                rectangle2D = attributeMap.createRect(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D2.getWidth() * this.collapseXScale, rectangle2D2.getHeight() * this.collapseYScale);
                attributeMap.applyValue("bounds", rectangle2D);
            } else {
                rectangle2D.setFrame(rectangle2D2.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            }
        }
    }

    protected Map handleAttributes(Map map) {
        Hashtable<Object, AttributeMap> hashtable = new Hashtable<Object, AttributeMap>();
        CellView[] cellViewArray = new CellView[map.size()];
        Iterator iterator = map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CellView cellView;
            Map.Entry entry = iterator.next();
            cellViewArray[n] = cellView = this.getMapping(entry.getKey(), false);
            ++n;
            if (cellView == null || cellView.getAttributes() == null) continue;
            Map map2 = (Map)entry.getValue();
            AttributeMap attributeMap = cellView.getAttributes().applyMap(map2);
            cellView.refresh(this, this, false);
            hashtable.put(cellView.getCell(), attributeMap);
        }
        this.update(cellViewArray);
        return hashtable;
    }

    public static void translateViews(CellView[] cellViewArray, double d, double d2) {
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (!(cellViewArray[i] instanceof AbstractCellView)) continue;
            ((AbstractCellView)cellViewArray[i]).translate(d, d2);
        }
    }

    public List getNeighbours(Object object, Set set, boolean bl, boolean bl2) {
        GraphModel graphModel = this.getModel();
        Object[] objectArray = bl ? DefaultGraphModel.getOutgoingEdges(graphModel, object) : DefaultGraphModel.getEdges(graphModel, new Object[]{object}).toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        HashSet<Object> hashSet = new HashSet<Object>(objectArray.length + 8, 0.75f);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object2;
            if (bl2 && !this.isVisible(objectArray[i]) || (object2 = DefaultGraphModel.getOpposite(graphModel, objectArray[i], object)) == null || set != null && set.contains(object2) || hashSet.contains(object2) || bl2 && !this.isVisible(object2)) continue;
            hashSet.add(object2);
            arrayList.add(object2);
        }
        return arrayList;
    }

    public List getOutgoingEdges(Object object, Set set, boolean bl, boolean bl2) {
        return this.getEdges(object, set, bl, bl2, false);
    }

    public List getIncomingEdges(Object object, Set set, boolean bl, boolean bl2) {
        return this.getEdges(object, set, bl, bl2, true);
    }

    protected List getEdges(Object object, Set set, boolean bl, boolean bl2, boolean bl3) {
        GraphModel graphModel = this.getModel();
        Object[] objectArray = DefaultGraphModel.getEdges(graphModel, object, bl3);
        ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
        HashSet<Object> hashSet = new HashSet<Object>(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (set != null && set.contains(objectArray[i]) || hashSet.contains(objectArray[i]) || bl && !this.isVisible(objectArray[i])) continue;
            if (bl2 || graphModel.getSource(objectArray[i]) != graphModel.getTarget(objectArray[i])) {
                arrayList.add(objectArray[i]);
            }
            hashSet.add(objectArray[i]);
        }
        return arrayList;
    }

    public CellView[] getAllViews() {
        return this.getAllDescendants(this.getRoots());
    }

    public CellView[] getAllDescendants(CellView[] cellViewArray) {
        CellView[] cellViewArray2;
        Stack<CellView> stack = new Stack<CellView>();
        for (int i = 0; i < cellViewArray.length; ++i) {
            if (cellViewArray[i] == null) continue;
            stack.add(cellViewArray[i]);
        }
        ArrayList<CellView[]> arrayList = new ArrayList<CellView[]>();
        while (!stack.isEmpty()) {
            int n;
            cellViewArray2 = (CellView[])stack.pop();
            CellView[] cellViewArray3 = cellViewArray2.getChildViews();
            for (n = 0; n < cellViewArray3.length; ++n) {
                stack.add(cellViewArray3[n]);
            }
            arrayList.add(cellViewArray2);
            for (n = 0; n < this.graphModel.getChildCount(cellViewArray2.getCell()); ++n) {
                CellView cellView;
                Object object = this.graphModel.getChild(cellViewArray2.getCell(), n);
                if (!this.graphModel.isPort(object) || (cellView = this.getMapping(object, false)) == null) continue;
                stack.add(cellView);
            }
        }
        cellViewArray2 = new CellView[arrayList.size()];
        arrayList.toArray(cellViewArray2);
        return cellViewArray2;
    }

    public Map getHiddenMapping() {
        return this.hiddenMapping;
    }

    public void setShowsExistingConnections(boolean bl) {
        this.showsExistingConnections = bl;
    }

    public boolean isShowsExistingConnections() {
        return this.showsExistingConnections;
    }

    public void setShowsInsertedConnections(boolean bl) {
        this.showsInsertedConnections = bl;
    }

    public boolean isShowsInsertedConnections() {
        return this.showsInsertedConnections;
    }

    public void setHidesExistingConnections(boolean bl) {
        this.hidesExistingConnections = bl;
    }

    public boolean isHidesExistingConnections() {
        return this.hidesExistingConnections;
    }

    public void setHidesDanglingConnections(boolean bl) {
        this.hidesDanglingConnections = bl;
    }

    public boolean isHidesDanglingConnections() {
        return this.hidesDanglingConnections;
    }

    public void setRemembersCellViews(boolean bl) {
        this.remembersCellViews = bl;
    }

    public boolean isRemembersCellViews() {
        return this.remembersCellViews;
    }

    public void setHiddenSet(Map map) {
        this.hiddenMapping = map;
    }

    public Set getLocalAttributes() {
        return this.localAttributes;
    }

    public void setLocalAttributes(Set set) {
        this.localAttributes = set;
    }

    public boolean isAllAttributesLocal() {
        return this.allAttributesLocal;
    }

    public void setAllAttributesLocal(boolean bl) {
        this.allAttributesLocal = bl;
    }

    public boolean isAutoSizeOnValueChange() {
        return this.autoSizeOnValueChange;
    }

    public void setAutoSizeOnValueChange(boolean bl) {
        this.autoSizeOnValueChange = bl;
    }

    public boolean isSelectsAllInsertedCells() {
        return this.selectsAllInsertedCells;
    }

    public void setSelectsAllInsertedCells(boolean bl) {
        this.selectsAllInsertedCells = bl;
    }

    public boolean isSelectsLocalInsertedCells() {
        return this.selectsLocalInsertedCells;
    }

    public void setSelectsLocalInsertedCells(boolean bl) {
        this.selectsLocalInsertedCells = bl;
    }

    public boolean isReconnectsEdgesToVisibleParent() {
        return this.reconnectsEdgesToVisibleParent;
    }

    public void setReconnectsEdgesToVisibleParent(boolean bl) {
        this.reconnectsEdgesToVisibleParent = bl;
    }

    public boolean isShowsChangedConnections() {
        return this.showsChangedConnections;
    }

    public void setShowsChangedConnections(boolean bl) {
        this.showsChangedConnections = bl;
    }

    public boolean isMovesChildrenOnExpand() {
        return this.movesChildrenOnExpand;
    }

    public void setMovesChildrenOnExpand(boolean bl) {
        this.movesChildrenOnExpand = bl;
    }

    public boolean isShowsInvisibleEditedCells() {
        return this.showsInvisibleEditedCells;
    }

    public void setShowsInvisibleEditedCells(boolean bl) {
        this.showsInvisibleEditedCells = bl;
    }

    public double getCollapseXScale() {
        return this.collapseXScale;
    }

    public void setCollapseXScale(double d) {
        this.collapseXScale = d;
    }

    public double getCollapseYScale() {
        return this.collapseYScale;
    }

    public void setCollapseYScale(double d) {
        this.collapseYScale = d;
    }

    public boolean isMovesParentsOnCollapse() {
        return this.movesParentsOnCollapse;
    }

    public void setMovesParentsOnCollapse(boolean bl) {
        this.movesParentsOnCollapse = bl;
    }

    public boolean isResizesParentsOnCollapse() {
        return this.resizesParentsOnCollapse;
    }

    public void setResizesParentsOnCollapse(boolean bl) {
        this.resizesParentsOnCollapse = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Hashtable hashtable = new Hashtable(this.hiddenMapping);
        objectOutputStream.writeObject(hashtable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Map map = (Map)objectInputStream.readObject();
        this.hiddenMapping = new WeakHashMap(map);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class GraphLayoutCacheEdit
    extends CompoundEdit
    implements GraphLayoutCacheEvent.GraphLayoutCacheChange {
        protected Object[] cells;
        protected Object[] previousCells = null;
        protected CellView[] context;
        protected CellView[] hidden;
        protected Map attributes;
        protected Map previousAttributes;
        protected Object[] visible;
        protected Object[] invisible;
        protected Rectangle2D dirtyRegion = null;
        protected Set changedCells = new HashSet();

        public GraphLayoutCacheEdit(Map map) {
            this(null, map, null, null);
            this.attributes = map;
        }

        public GraphLayoutCacheEdit(Object[] objectArray, Map map, Object[] objectArray2, Object[] objectArray3) {
            this.attributes = map;
            this.previousAttributes = map;
            this.cells = objectArray;
            this.visible = objectArray2;
            this.invisible = objectArray3;
        }

        public Object getSource() {
            return GraphLayoutCache.this;
        }

        public boolean isSignificant() {
            return true;
        }

        public Object[] getChanged() {
            return this.changedCells.toArray();
        }

        public Object[] getInserted() {
            return this.invisible;
        }

        public Object[] getRemoved() {
            return this.visible;
        }

        public Object[] getContext() {
            return this.context;
        }

        public Map getAttributes() {
            return this.attributes;
        }

        public Map getPreviousAttributes() {
            return this.previousAttributes;
        }

        public Rectangle2D getDirtyRegion() {
            return this.dirtyRegion;
        }

        public void setDirtyRegion(Rectangle2D rectangle2D) {
            this.dirtyRegion = rectangle2D;
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.execute();
        }

        public void undo() throws CannotUndoException {
            super.undo();
            this.execute();
        }

        public void execute() {
            Object object;
            Object[] objectArray;
            int n;
            GraphModel graphModel = GraphLayoutCache.this.getModel();
            this.changedCells.clear();
            if (this.hidden != null) {
                for (n = 0; n < this.hidden.length; ++n) {
                    if (this.hidden[n] == null) continue;
                    GraphLayoutCache.this.mapping.put(this.hidden[n].getCell(), this.hidden[n]);
                }
            }
            if (this.invisible != null && this.invisible.length > 0) {
                CellView[] cellViewArray = new CellView[this.invisible.length];
                cellViewArray = GraphLayoutCache.this.getMapping(this.invisible, true);
                objectArray = GraphLayoutCache.getBounds(cellViewArray);
                this.dirtyRegion = RectUtils.union(this.dirtyRegion, (Rectangle2D)objectArray);
            }
            if (!GraphLayoutCache.this.remembersCellViews) {
                this.hidden = GraphLayoutCache.this.getMapping(this.invisible);
            }
            n = GraphLayoutCache.this.setVisibleImpl(this.visible, true) | GraphLayoutCache.this.setVisibleImpl(this.invisible, false);
            if (this.visible != null) {
                for (int i = 0; i < this.visible.length; ++i) {
                    this.changedCells.add(this.visible[i]);
                    if (this.cells != null) continue;
                    GraphLayoutCache.this.cellExpanded(this.visible[i]);
                }
            }
            if (this.invisible != null) {
                for (int i = 0; i < this.invisible.length; ++i) {
                    this.changedCells.add(this.invisible[i]);
                }
            }
            objectArray = this.visible;
            this.visible = this.invisible;
            this.invisible = objectArray;
            if (this.attributes != null) {
                this.previousAttributes = this.attributes;
                this.changedCells.addAll(this.attributes.keySet());
            }
            if (n != 0) {
                GraphLayoutCache.this.updatePorts();
            }
            HashSet<Object> hashSet = new HashSet<Object>();
            Iterator iterator = this.changedCells.iterator();
            while (iterator.hasNext()) {
                object = graphModel.getParent(iterator.next());
                while (object != null) {
                    hashSet.add(object);
                    object = graphModel.getParent(object);
                }
            }
            this.changedCells.addAll(hashSet);
            object = DefaultGraphModel.getEdges(GraphLayoutCache.this.getModel(), this.changedCells.toArray());
            this.context = GraphLayoutCache.this.getMapping(object.toArray());
            HashSet hashSet2 = new HashSet(this.changedCells);
            hashSet2.addAll(object);
            CellView[] cellViewArray = GraphLayoutCache.this.getMapping(hashSet2.toArray());
            Rectangle2D rectangle2D = GraphLayoutCache.getBounds(cellViewArray);
            this.dirtyRegion = RectUtils.union(this.dirtyRegion, rectangle2D);
            if (this.attributes != null) {
                this.attributes = GraphLayoutCache.this.handleAttributes(this.attributes);
            }
            GraphLayoutCache.this.refresh(GraphLayoutCache.this.getMapping(this.changedCells.toArray(), false), false);
            GraphLayoutCache.this.refresh(this.context, false);
            objectArray = this.cells;
            this.cells = this.previousCells;
            this.previousCells = objectArray;
            GraphLayoutCache.this.reloadRoots();
            GraphLayoutCache.this.fireGraphLayoutCacheChanged(GraphLayoutCache.this, this);
        }
    }
}

