/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 *   this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * - Neither the name of intarsys nor the names of its contributors may be used
 *   to endorse or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package de.intarsys.tools.locator;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;

import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.randomaccess.IRandomAccess;

/**
 * An adapter for implementing a delegation model.
 * 
 */
abstract public class DelegatingLocator implements ILocator, IAdapterSupport {

	private ILocator delegate;

	public DelegatingLocator(ILocator delegate) {
		super();
		this.delegate = delegate;
	}

	public void delete() throws IOException {
		getDelegate().delete();
	}

	public boolean exists() {
		return getDelegate().exists();
	}

	public <T> T getAdapter(Class<T> clazz) {
		return AdapterTools.getAdapter(delegate, clazz);
	}

	public ILocator getChild(String name) {
		return getDelegate().getChild(name);
	}

	public ILocator getDelegate() {
		return delegate;
	}

	public String getFullName() {
		return getDelegate().getFullName();
	}

	public InputStream getInputStream() throws IOException {
		return getDelegate().getInputStream();
	}

	public long getLength() throws IOException {
		return delegate.getLength();
	}

	public String getLocalName() {
		return getDelegate().getLocalName();
	}

	public OutputStream getOutputStream() throws IOException {
		return getDelegate().getOutputStream();
	}

	public ILocator getParent() {
		return getDelegate().getParent();
	}

	public IRandomAccess getRandomAccess() throws IOException {
		return getDelegate().getRandomAccess();
	}

	public Reader getReader() throws IOException {
		return getDelegate().getReader();
	}

	public Reader getReader(String encoding) throws IOException {
		return getDelegate().getReader(encoding);
	}

	public String getType() {
		return getDelegate().getType();
	}

	public String getTypedName() {
		return getDelegate().getTypedName();
	}

	public Writer getWriter() throws IOException {
		return getDelegate().getWriter();
	}

	public Writer getWriter(String encoding) throws IOException {
		return getDelegate().getWriter(encoding);
	}

	public boolean isDirectory() {
		return getDelegate().isDirectory();
	}

	public boolean isOutOfSynch() {
		return getDelegate().isOutOfSynch();
	}

	public boolean isReadOnly() {
		return getDelegate().isReadOnly();
	}

	public ILocator[] listLocators(ILocatorNameFilter filter)
			throws IOException {
		return getDelegate().listLocators(filter);
	}

	public void rename(String newName) throws IOException {
		getDelegate().rename(newName);
	}

	public void setReadOnly() {
		getDelegate().setReadOnly();
	}

	public void synch() {
		getDelegate().synch();
	}

	public URL toURL() {
		return getDelegate().toURL();
	}
}
