/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.UUID;
import javax.annotation.concurrent.Immutable;
import org.joda.time.Instant;

@Immutable
public final class NewRun {
    private final UUID id;
    private final String label;
    private final Instant startTime;

    private NewRun(Builder builder) {
        this.id = builder.id;
        this.label = builder.label;
        this.startTime = builder.startTime;
    }

    public UUID id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NewRun) {
            NewRun that = (NewRun)obj;
            return this.id.equals(that.id) && this.label.equals(that.label) && this.startTime.equals((Object)that.startTime);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.label, this.startTime});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.id).add("label", (Object)this.label).add("startTime", (Object)this.startTime).toString();
    }

    public static final class Builder {
        private UUID id;
        private String label = "";
        private Instant startTime;

        public Builder(UUID id) {
            this.id = (UUID)Preconditions.checkNotNull((Object)id);
        }

        public Builder label(String label) {
            this.label = (String)Preconditions.checkNotNull((Object)label);
            return this;
        }

        public Builder startTime(Instant startTime) {
            this.startTime = (Instant)Preconditions.checkNotNull((Object)startTime);
            return this;
        }

        public NewRun build() {
            Preconditions.checkState((this.id != null ? 1 : 0) != 0);
            Preconditions.checkState((this.startTime != null ? 1 : 0) != 0);
            return new NewRun(this);
        }
    }
}

