/*
  GNU-Classpath Extensions: JMI
  Copyright (C) 2004 Free Software Foundation, Inc.

  For more information on the GNU Classpathx project please mail:
  classpathx-discuss@gnu.org

  This file is part of GNU JMI

  GNU JMI is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  GNU JMI is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with program; see the file COPYING. If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/

package javax.jmi.reflect;

import java.util.Collection;
import java.util.List;

public interface RefPackage extends RefBaseObject
{
  
  public Collection refAllAssociations();
  
  public Collection refAllClasses();
  
  public Collection refAllPackages();
  
  public RefAssociation refAssociation(RefObject association);
  
  public RefAssociation refAssociation(String associationName);
  
  public RefClass refClass(RefObject type);
  
  public RefClass refClass(String typeName);
  
  public RefStruct refCreateStruct(RefObject struct, List params);
  
  public RefStruct refCreateStruct(String structName, List params);
  
  public void refDelete();
  
  public RefEnum refGetEnum(RefObject enumer, String name);
  
  public RefEnum refGetEnum(String enumName, String name);
  
  public RefPackage refPackage(RefObject nestedPackage);
  
  public RefPackage refPackage(String nestedPackageName);
  
}
