#if !defined (__COMPONENT_HPP)
#define __COMPONENT_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif
  

namespace corelinux
{

   DECLARE_CLASS( Visitor );
   DECLARE_CLASS( Component );

   /**
   A Component declares the interface for the objects in a composition and 
   implements default behavior. This is a safe component by which the
   composite implementation fully declares leaf management methods.
   @see TransparentComponent
   */

   class Component : public CoreLinuxObject
   {
   public:

                           /// Default Constructor

                           Component( void );

                           /** Copy Constructor
                           @param Component const reference
                           */

                           Component( ComponentCref );

                           /// Virtual Destructor  

      virtual              ~Component( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Component const reference
               @return Component reference to self
               */
            
               ComponentRef  operator=( ComponentCref );

               /**
               Equality operator overload
               @param Component const reference
               @return true if equal, false otherwise
               */

               bool        operator==( ComponentCref ) const;

               /**
               Non-equality operator overload
               @param Component const reference
               @return false if equal, true otherwise
               */

               bool        operator!=( ComponentCref ) const;

      //
      // Visitor access
      //

               /**
               Accept is a double dispatch method which allows
               components to have new operations defined without
               changing the structure of the components themselves.
               @param Visitor pointer to visitor
               @exception NullPointerException if pointer is null
               */

      virtual  void  accept( VisitorPtr ) throw ( NullPointerException );

   };

}
          
#endif   // if !defined(__COMPONENT_HPP)

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.2 $
   $Date: 2000/05/12 03:27:47 $
   $Locker:  $
*/



