//LabPlot : ImportOPJ.cc

#include <stdio.h>
#include <math.h>

#include <qstring.h>
#include <qregexp.h>
#include <kdebug.h>
#include "ImportOPJ.h"
#include "LTableItem.h"

#include "OPJFile.h"

ImportOPJ::ImportOPJ(MainWin *mw, QString filename) 
	: mw(mw),filename(filename) 
{}

int ImportOPJ::import() {
	kdDebug()<<"ImportOPJ::import() : "<<filename<<endl;

	OPJFile opj((char *)filename.latin1());
	opj.Parse();

	for (int s=0;s<opj.numSpreads();s++) {
		Spreadsheet *spread = mw->newSpreadsheet();
		QTable *table = spread->Table();
		kdDebug()<<"	SPREADNAME "<<s<<" = "<<opj.spreadName(s)<<endl;
		spread->setTitle(opj.spreadName(s));
		
		int nr_cols = opj.numCols(s), maxrows = opj.maxRows(s);
		table->setNumCols(nr_cols);
		table->setNumRows(maxrows);

		for (int j=0;j<nr_cols;j++) {
			QString name(opj.colName(s,j));
			spread->setColumnTitle(j,name.replace(QRegExp(".*_"),""));
			spread->setColumnType(j,opj.colType(s,j));
			
			for (int i=0;i<opj.numRows(s,j);i++) {
				double v = opj.Data(s,j)[i];

				LTableItem *item;
				if(strcmp(opj.colType(s,j),"LABEL")) {	// number
					if(fabs(v)<2.0e-300)	// empty entry
						continue;
					item = new LTableItem( table, QTableItem::OnTyping,QString::number(v));
				}
				else					// label
					item = new LTableItem( table,QTableItem::OnTyping,QString(opj.SData(s,j,i)));
				table->setItem(i, j, item);
			}
		}
	}

	return 0;
}
