//
// cppopt.cpp
// C++ Argument Parsing
//
// Copyright 2001 Zed C. Pobre
// Licensed to the public under the terms of the GNU GPL
//
// See cppopt.hpp for notes
//

#include "cppopt.h"

namespace cppopt
{
    // ===================================================================== //
    //
    // Functions, constructor, destructor of the class Options
    //

    Options::Options()
    {
	clear();
	return;
    }
    Options::~Options()
    {}

    void Options::clear()
    {
	preopt.erase(preopt.begin(),preopt.end());
	shortopt.erase(shortopt.begin(),shortopt.end());
	longopt.erase(longopt.begin(),longopt.end());
	postopt.erase();
	return;
    }

    bool Options::empty()
    {
	if(!preopt.empty()) return false;
	if(!shortopt.empty()) return false;
	if(!longopt.empty()) return false;
	if(!target.empty()) return false;
	if(!postopt.empty()) return false;
	return true;
    }

    bool Options::haspreopt()
    {
	return !preopt.empty();
    }
    bool Options::haspreopt(string opt)
    {
	vector<string>::iterator iter;
	bool retval = false;
	for(iter = preopt.begin(); iter != preopt.end(); iter++)
	{
	    if(*iter == opt) retval = true;
	}
	return retval;
    }
    
    bool Options::hasshortopt()
    {
	return !shortopt.empty();
    }
    bool Options::hasshortopt(char opt)
    {
	map<char,string>::iterator iter;
	bool retval = false;
	for(iter = shortopt.begin(); iter != shortopt.end(); iter++)
	{
	    if(iter->first == opt) retval = true;
	}
	return retval;
    }

    bool Options::haslongopt()
    {
	return !longopt.empty();
    }
    bool Options::haslongopt(string opt)
    {
	map<string,string>::iterator iter;
	bool retval = false;
	for(iter = longopt.begin(); iter != longopt.end(); iter++)
	{
	    if(iter->first == opt) retval = true;
	}
	return retval;
    }

    bool Options::hastarget()
    {
	return !target.empty();
    }
    bool Options::hastarget(string opt)
    {
	vector<string>::iterator iter;
	bool retval = false;
	for(iter = target.begin(); iter != target.end(); iter++)
	{
	    if(*iter == opt) retval = true;
	}
	return retval;
    }

    bool Options::haspostopt()
    {
	return !postopt.empty();
    }

    void Options::listall()
    {

	listpreopts();
	listshort();
	listlong();
	listtargets();

	if(!postopt.empty()) cout << "--\n\"" << postopt << "\"" << endl << endl;

	return;
    }

    void Options::listpreopts()
    {
	vector<string>::iterator iter;
	cout << "Pre-Options:" << endl;
	for(iter = preopt.begin(); iter != preopt.end(); iter++)
	{
	    cout << "  \"" << *iter << "\"" << endl;
	}
	cout << endl;
	return;
    }

    void Options::listshort()
    {
	map<char,string>::iterator iter;

	cout << "Short Options:" << endl;
	for(iter = shortopt.begin(); iter != shortopt.end(); iter++)
	{
	    cout << "  \"" << iter->first << "\"";
	    cout << " = \"" << iter->second << "\"" << endl;
	}

	cout << endl;
	return;
    }

    void Options::listlong()
    {
	map<string,string>::iterator iter;

	cout << "Long Options:" << endl;
	for(iter = longopt.begin(); iter != longopt.end(); iter++)
	{
	    cout << "  \"" << iter->first << "\"";
	    cout << " = \"" << iter->second << "\"" << endl;
	}

	cout << endl;
	return;
    }

    void Options::listtargets()
    {
	vector<string>::iterator iter;
	cout << "Targets:" << endl;
	for(iter = target.begin(); iter != target.end(); iter++)
	{
	    cout << "  \"" << *iter << "\"" << endl;
	}
	cout << endl;
	return;
    }


    // ===================================================================== //
    //
    // Global functions
    //

    string stripwhitespace(string unstripped)
    {
	string::size_type index1,index2;

	index1 = unstripped.find_first_not_of(" \t");
	if(index1 == string::npos)
	{
	    unstripped.erase();
	    return unstripped;
	}
	index2 = unstripped.find_last_not_of(" \t");

	return unstripped.substr(index1,index2-index1+1);
    }

    Options parse(string optstring)
    {
	string::size_type optindex1,optindex2;
	string tempstring;
	char tempchar;
	char shortopt;
	string longopt;
	string arg;
	Options retval;

	optstring = stripwhitespace(optstring);

	if(optstring.empty()) return retval;

	// The first pass is to strip out any targets that come BEFORE
	// any switches and put them in retval.preopt
	//
	if(optstring[0] != '-')
	{
	    // There is a preopt.  Check to see if there are any
	    // switches at all, and move only the preopts into a
	    // temporary string for special processing.
	    //
	    optindex1 = optstring.find(" -");
	    if(optindex1 == string::npos)
	    {
		// No switches found.  The entire string can be moved,
		// and the optstring can be cleared to break the loop.
		//
		tempstring = optstring;
		optstring.erase();
	    }
	    else
	    {
		// Switches were found.  Move all of the preopts in
		// one lump to tempstring for special processing, and
		// remove them from optstring, leaving optstring[0] at
		// the first '-'
		// 
		tempstring = optstring.substr(0,optindex1);
		optstring = optstring.substr(optindex1+1);
	    }
	    
	    optindex1 = 0;
	    while(optindex1 != string::npos)
	    {
		optindex2 = tempstring.find_first_of(" \t",optindex1);
		if(optindex2 == string::npos)
		{
		    retval.preopt.push_back(tempstring.substr(optindex1));
		    optindex1 = optindex2;
		}
		else
		{
		    retval.preopt.push_back(tempstring.substr(optindex1,optindex2-optindex1));
		    optindex1 = tempstring.find_first_not_of(" \t",optindex2);
		}
	    }
	    
	    if(optstring.empty()) return retval;
	    
	} // if(optstring[0] != '-')
	
	while(!optstring.empty())
	{
	    if(optstring[0] == '-')
	    {
		if(optstring[1] == '-')
		{
		    try { tempchar = optstring.at(2); }
		    catch (...)
		    {
			return retval;
		    }
		    if( (optstring[2] == ' ') || (optstring[2] == '\t') )
		    {
			retval.postopt = optstring.substr(3);
			return retval;
		    }

		    optindex1 = optstring.find_first_of(" \t=",3);
		    optindex2 = optstring.find_first_not_of(" \t=",optindex1);
		    longopt = optstring.substr(2,optindex1-2);

		    if(optstring[optindex1] != '=')
		    {
			if(optindex2 == string::npos)
			{
			    retval.longopt[longopt] = "";
			    return retval;
			}
			else if(optstring[optindex2] == '-')
			{
			    retval.longopt[longopt]="";
			    optstring = optstring.substr(optindex2);
			    continue;
			}
			else
			{
//			    cout << "DEBUG: parse: --" << longopt << " with arg" << endl;
			    optindex1 = optstring.find_first_of(" \t",optindex2);
			    if(optindex1 == string::npos)
			    {
				arg = optstring.substr(optindex2);
				retval.longopt[longopt] = arg;
				return retval;
			    }
			    else 
			    {
				arg = optstring.substr(optindex2,optindex1-optindex2);
				retval.longopt[longopt] = arg;
				optstring = stripwhitespace(optstring.substr(optindex1));
//				cout << "DEBUG: remaining optstring = \"" << optstring << "\"" << endl;
				continue;
			    }
			}
		    }
		    else
		    {
//			cout << "DEBUG: parse: --longopt=" << endl;
			if(optindex2 == string::npos)
			{
//			    cout << "DEBUG: parse: --longopt=[NULL][EOL]" << endl;
			    retval.longopt[longopt]="";
			    return retval;
			}
			optindex1 = optstring.find_first_of(" \t",optindex2);
			if(optindex1 == string::npos)
			{
			    arg = optstring.substr(optindex2);
			    retval.longopt[longopt]=arg;
			    return retval;
			}
			else
			{
			    arg = optstring.substr(optindex2,optindex1-optindex2);
			    retval.longopt[longopt]=arg;
			    optstring = stripwhitespace(optstring.substr(optindex1));
			    cout << "DEBUG: remaining optstring = \"" << optstring << "\"" << endl;
			    continue;
			}
		    } // optstring[optindex1] == '='
		} // optstring[0] == '-' && optstring[1] == '-'

		try { tempchar = optstring.at(1); }
		catch (...)
		{
		    retval.shortopt['-'] = "";
		    return retval;
		}		
		if( (optstring[1] == ' ') || (optstring[1] == '\t') )
		{
		    retval.shortopt['-'] = "";
		    optstring = stripwhitespace(optstring.substr(2));
//		    cout << "DEBUG: remaining optstring = \"" << optstring << "\"" << endl;
		    continue;
		}
		shortopt = optstring[1];
		if(optstring[2] == '=')
		{
//		    cout << "DEBUG: -" << shortopt << "=" << endl;
		    optindex1 = optstring.find_first_of(" \t");
		    if(optindex1 == string::npos)
		    {
			retval.shortopt[shortopt] = optstring.substr(3);
			return retval;
		    }
		    else
		    {
//			cout << "DEBUG: -" << shortopt << " = \"" << optstring.substr(3) << "\"" << endl;
			retval.shortopt[shortopt] = optstring.substr(3,optindex1-3);
			optstring = stripwhitespace(optstring.substr(optindex1));
			continue;
		    }
		}

		if( (optstring[2] == ' ') || (optstring[2] == '\t') )
		{
		    optstring = stripwhitespace(optstring.substr(3));
		    if(optstring[0] == '-')
		    {
			retval.shortopt[shortopt] = "";
			continue;
		    }
		    optindex1 = optstring.find_first_of(" \t");
		    if(optindex1 == string::npos)
		    {
			retval.shortopt[shortopt] = optstring;
			return retval;
		    }
		    else
		    {
			retval.shortopt[shortopt] = optstring.substr(0,optindex1);
			optstring = stripwhitespace(optstring.substr(optindex1));
			continue;
		    }
		}

		optindex1 = optstring.find_first_of(" \t");
		if(optindex1 == string::npos)
		{
		    retval.shortopt[shortopt] = optstring.substr(2);
		    return retval;
		}
		else
		{
		    retval.shortopt[shortopt] = optstring.substr(2,optindex1-2);
		    optstring = stripwhitespace(optstring.substr(optindex1));
		    continue;
		}
	    } // optstring[0] == '-'

	    optindex1 = optstring.find_first_of(" \t");
	    if(optindex1 == string::npos)
	    {
		retval.target.push_back(optstring);
		return retval;
	    }
	    else
	    {
		retval.target.push_back(optstring.substr(0,optindex1));
		optstring = stripwhitespace(optstring.substr(optindex1));
//		cout << "DEBUG: target: optstring = \"" << optstring << "\"" << endl;
		continue;
	    }

	    break;
	} // while(!optstring.empty())
	
	return retval;
    }

    Options parse(int argc, char **argv)
    {
	int ctr;
	string optstring;
	Options retval;

	if(argc < 2)
	{
	    return retval;
	}
    
	// I'm cheating severely here for the moment, since only the
	// simple string parsing works yet.
	//
	optstring = argv[1];
	for(ctr = 2; ctr < argc; ctr++)
	{
	    optstring = optstring + " " + argv[ctr];
	}

//	cout << "DEBUG: parse(argc,argv) parsing: \"" << optstring << "\"" << endl;
	return parse(optstring);
    }
} // namespace cppopt
