/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Javadoc
extends Task {
    private Commandline cmd = new Commandline();
    private static boolean javadoc1 = Project.getJavaVersion() == "1.1";
    private boolean foundJavaFile = false;
    private boolean failOnError = false;
    private Path sourcePath = null;
    private File destDir = null;
    private String sourceFiles = null;
    private String packageNames = null;
    private String excludePackageNames = null;
    private boolean author = true;
    private boolean version = true;
    private DocletInfo doclet = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private String group = null;
    private Vector compileList = new Vector(10);
    private String packageList = null;
    private Vector links = new Vector(2);
    private Vector groups = new Vector(2);
    private boolean useDefaultExcludes = true;

    private void addArgIf(boolean bl, String string) {
        if (bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    private void add12ArgIfNotEmpty(String string, String string2) {
        if (!javadoc1) {
            if (string2 != null && string2.length() != 0) {
                this.cmd.createArgument().setValue(string);
                this.cmd.createArgument().setValue(string2);
            } else {
                this.project.log(this, "Warning: Leaving out empty argument '" + string + "'", 1);
            }
        }
    }

    private void add11ArgIf(boolean bl, String string) {
        if (javadoc1 && bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    private void add12ArgIf(boolean bl, String string) {
        if (!javadoc1 && bl) {
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setDefaultexcludes(boolean bl) {
        this.useDefaultExcludes = bl;
    }

    public void setMaxmemory(String string) {
        if (javadoc1) {
            this.cmd.createArgument().setValue("-J-mx" + string);
        } else {
            this.cmd.createArgument().setValue("-J-Xmx" + string);
        }
    }

    public void setAdditionalparam(String string) {
        this.cmd.createArgument().setLine(string);
    }

    public void setSourcepath(Path path) {
        if (this.sourcePath == null) {
            this.sourcePath = path;
        } else {
            this.sourcePath.append(path);
        }
    }

    public Path createSourcepath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.project);
        }
        return this.sourcePath.createPath();
    }

    public void setSourcepathRef(Reference reference) {
        this.createSourcepath().setRefid(reference);
    }

    public void setDestdir(File file) {
        this.destDir = file;
        this.cmd.createArgument().setValue("-d");
        this.cmd.createArgument().setFile(this.destDir);
    }

    public void setSourcefiles(String string) {
        this.sourceFiles = string;
    }

    public void setPackagenames(String string) {
        this.packageNames = string;
    }

    public void setExcludePackageNames(String string) {
        this.excludePackageNames = string;
    }

    public void setOverview(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-overview");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setPublic(boolean bl) {
        this.addArgIf(bl, "-public");
    }

    public void setProtected(boolean bl) {
        this.addArgIf(bl, "-protected");
    }

    public void setPackage(boolean bl) {
        this.addArgIf(bl, "-package");
    }

    public void setPrivate(boolean bl) {
        this.addArgIf(bl, "-private");
    }

    public void setDoclet(String string) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setName(string);
    }

    public void setDocletPath(Path path) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.setPath(path);
    }

    public void setDocletPathRef(Reference reference) {
        if (this.doclet == null) {
            this.doclet = new DocletInfo();
        }
        this.doclet.createPath().setRefid(reference);
    }

    public DocletInfo createDoclet() {
        this.doclet = new DocletInfo();
        return this.doclet;
    }

    public void setOld(boolean bl) {
        this.add12ArgIf(bl, "-1.1");
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setBootclasspath(Path path) {
        if (this.bootclasspath == null) {
            this.bootclasspath = path;
        } else {
            this.bootclasspath.append(path);
        }
    }

    public Path createBootclasspath() {
        if (this.bootclasspath == null) {
            this.bootclasspath = new Path(this.project);
        }
        return this.bootclasspath.createPath();
    }

    public void setBootClasspathRef(Reference reference) {
        this.createBootclasspath().setRefid(reference);
    }

    public void setExtdirs(String string) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-extdirs");
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setVerbose(boolean bl) {
        this.add12ArgIf(bl, "-verbose");
    }

    public void setLocale(String string) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-locale");
            this.cmd.createArgument().setValue(string);
        }
    }

    public void setEncoding(String string) {
        this.cmd.createArgument().setValue("-encoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setVersion(boolean bl) {
        this.version = bl;
    }

    public void setUse(boolean bl) {
        this.add12ArgIf(bl, "-use");
    }

    public void setAuthor(boolean bl) {
        this.author = bl;
    }

    public void setSplitindex(boolean bl) {
        this.add12ArgIf(bl, "-splitindex");
    }

    public void setWindowtitle(String string) {
        this.add12ArgIfNotEmpty("-windowtitle", string);
    }

    public void setDoctitle(String string) {
        this.add12ArgIfNotEmpty("-doctitle", string);
    }

    public void setHeader(String string) {
        this.add12ArgIfNotEmpty("-header", string);
    }

    public void setFooter(String string) {
        this.add12ArgIfNotEmpty("-footer", string);
    }

    public void setBottom(String string) {
        this.add12ArgIfNotEmpty("-bottom", string);
    }

    public void setLinkoffline(String string) {
        if (!javadoc1) {
            LinkArgument linkArgument = this.createLink();
            linkArgument.setOffline(true);
            String string2 = "The linkoffline attribute must include a URL and a package-list file location separated by a space";
            if (string.trim().length() == 0) {
                throw new BuildException(string2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            linkArgument.setHref(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) {
                throw new BuildException(string2);
            }
            linkArgument.setPackagelistLoc(stringTokenizer.nextToken());
        }
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setLink(String string) {
        if (!javadoc1) {
            this.createLink().setHref(string);
        }
    }

    public void setNodeprecated(boolean bl) {
        this.addArgIf(bl, "-nodeprecated");
    }

    public void setNodeprecatedlist(boolean bl) {
        this.add12ArgIf(bl, "-nodeprecatedlist");
    }

    public void setNotree(boolean bl) {
        this.addArgIf(bl, "-notree");
    }

    public void setNoindex(boolean bl) {
        this.addArgIf(bl, "-noindex");
    }

    public void setNohelp(boolean bl) {
        this.add12ArgIf(bl, "-nohelp");
    }

    public void setNonavbar(boolean bl) {
        this.add12ArgIf(bl, "-nonavbar");
    }

    public void setSerialwarn(boolean bl) {
        this.add12ArgIf(bl, "-serialwarn");
    }

    public void setStylesheetfile(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-stylesheetfile");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setHelpfile(File file) {
        if (!javadoc1) {
            this.cmd.createArgument().setValue("-helpfile");
            this.cmd.createArgument().setFile(file);
        }
    }

    public void setDocencoding(String string) {
        this.cmd.createArgument().setValue("-docencoding");
        this.cmd.createArgument().setValue(string);
    }

    public void setPackageList(String string) {
        this.packageList = string;
    }

    public LinkArgument createLink() {
        LinkArgument linkArgument = new LinkArgument();
        this.links.addElement(linkArgument);
        return linkArgument;
    }

    public GroupArgument createGroup() {
        GroupArgument groupArgument = new GroupArgument();
        this.groups.addElement(groupArgument);
        return groupArgument;
    }

    public void setCharset(String string) {
        this.add12ArgIfNotEmpty("-charset", string);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws BuildException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if ("javadoc2".equals(this.taskType)) {
            this.log("!! javadoc2 is deprecated. Use javadoc instead. !!");
        }
        if (this.sourcePath == null) {
            String string = "sourcePath attribute must be set!";
            throw new BuildException(string);
        }
        this.log("Generating Javadoc", 2);
        Commandline commandline = (Commandline)this.cmd.clone();
        commandline.setExecutable("javadoc");
        this.classpath = this.classpath == null ? Path.systemClasspath : this.classpath.concatSystemClasspath("ignore");
        if (!javadoc1) {
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setPath(this.classpath);
            commandline.createArgument().setValue("-sourcepath");
            commandline.createArgument().setPath(this.sourcePath);
        } else {
            commandline.createArgument().setValue("-classpath");
            commandline.createArgument().setValue(this.sourcePath.toString() + System.getProperty("path.separator") + this.classpath.toString());
        }
        if (this.version && this.doclet == null) {
            commandline.createArgument().setValue("-version");
        }
        if (this.author && this.doclet == null) {
            commandline.createArgument().setValue("-author");
        }
        if ((javadoc1 || this.doclet == null) && this.destDir == null) {
            String string = "destDir attribute must be set!";
            throw new BuildException(string);
        }
        if (!javadoc1) {
            if (this.doclet != null) {
                if (this.doclet.getName() == null) {
                    throw new BuildException("The doclet name must be specified.", this.location);
                }
                commandline.createArgument().setValue("-doclet");
                commandline.createArgument().setValue(this.doclet.getName());
                if (this.doclet.getPath() != null) {
                    commandline.createArgument().setValue("-docletpath");
                    commandline.createArgument().setPath(this.doclet.getPath());
                }
                object4 = this.doclet.getParams();
                while (object4.hasMoreElements()) {
                    object3 = (DocletParam)object4.nextElement();
                    if (((DocletParam)object3).getName() == null) {
                        throw new BuildException("Doclet parameters must have a name");
                    }
                    commandline.createArgument().setValue(((DocletParam)object3).getName());
                    if (((DocletParam)object3).getValue() == null) continue;
                    commandline.createArgument().setValue(((DocletParam)object3).getValue());
                }
            }
            if (this.bootclasspath != null) {
                commandline.createArgument().setValue("-bootclasspath");
                commandline.createArgument().setPath(this.bootclasspath);
            }
            if (this.links.size() != 0) {
                object4 = this.links.elements();
                while (object4.hasMoreElements()) {
                    object3 = (LinkArgument)object4.nextElement();
                    if (((LinkArgument)object3).getHref() == null) {
                        throw new BuildException("Links must provide the URL to the external class documentation.");
                    }
                    if (((LinkArgument)object3).isLinkOffline()) {
                        object2 = ((LinkArgument)object3).getPackagelistLoc();
                        if (object2 == null) {
                            throw new BuildException("The package list location for link " + ((LinkArgument)object3).getHref() + " must be provided because the link is offline");
                        }
                        commandline.createArgument().setValue("-linkoffline");
                        commandline.createArgument().setValue(((LinkArgument)object3).getHref());
                        commandline.createArgument().setValue((String)object2);
                        continue;
                    }
                    commandline.createArgument().setValue("-link");
                    commandline.createArgument().setValue(((LinkArgument)object3).getHref());
                }
            }
            if (this.group != null) {
                object4 = new StringTokenizer(this.group, ",", false);
                while (((StringTokenizer)object4).hasMoreTokens()) {
                    object3 = ((StringTokenizer)object4).nextToken().trim();
                    int n = ((String)object3).indexOf(" ");
                    if (n <= 0) continue;
                    object = ((String)object3).substring(0, n);
                    String string = ((String)object3).substring(n + 1);
                    commandline.createArgument().setValue("-group");
                    commandline.createArgument().setValue((String)object);
                    commandline.createArgument().setValue(string);
                }
            }
            if (this.groups.size() != 0) {
                object4 = this.groups.elements();
                while (object4.hasMoreElements()) {
                    object3 = (GroupArgument)object4.nextElement();
                    object2 = ((GroupArgument)object3).getTitle();
                    object = ((GroupArgument)object3).getPackages();
                    if (object2 == null) throw new BuildException("The title and packages must be specified for group elements.");
                    if (object == null) {
                        throw new BuildException("The title and packages must be specified for group elements.");
                    }
                    commandline.createArgument().setValue("-group");
                    commandline.createArgument().setValue((String)object2);
                    commandline.createArgument().setValue((String)object);
                }
            }
        }
        if (this.packageNames != null && this.packageNames.length() > 0) {
            block43: {
                object4 = new Vector();
                object3 = new StringTokenizer(this.packageNames, ",", false);
                while (true) {
                    if (!((StringTokenizer)object3).hasMoreTokens()) {
                        object2 = new Vector();
                        if (this.excludePackageNames != null && this.excludePackageNames.length() > 0) {
                            object = new StringTokenizer(this.excludePackageNames, ",", false);
                            break;
                        }
                        break block43;
                    }
                    object2 = ((StringTokenizer)object3).nextToken().trim();
                    if (((String)object2).endsWith(".*")) {
                        ((Vector)object4).addElement(object2);
                        continue;
                    }
                    commandline.createArgument().setValue((String)object2);
                }
                while (((StringTokenizer)object).hasMoreTokens()) {
                    ((Vector)object2).addElement(((StringTokenizer)object).nextToken().trim());
                }
            }
            if (((Vector)object4).size() > 0) {
                this.evaluatePackages(commandline, this.sourcePath, (Vector)object4, (Vector)object2);
            }
        }
        if (this.sourceFiles != null && this.sourceFiles.length() > 0) {
            object4 = new StringTokenizer(this.sourceFiles, ",", false);
            while (((StringTokenizer)object4).hasMoreTokens()) {
                commandline.createArgument().setValue(((StringTokenizer)object4).nextToken().trim());
            }
        }
        if (this.packageList != null) {
            commandline.createArgument().setValue("@" + this.packageList);
        }
        this.log("Javadoc args: " + commandline, 3);
        this.log("Javadoc execution", 2);
        object4 = new JavadocOutputStream(2);
        object3 = new JavadocOutputStream(1);
        object2 = new Execute(new PumpStreamHandler((OutputStream)object4, (OutputStream)object3));
        ((Execute)object2).setAntRun(this.project);
        ((Execute)object2).setWorkingDirectory(this.project.getBaseDir());
        try {
            try {
                ((Execute)object2).setCommandline(commandline.getCommandline());
                int n = ((Execute)object2).execute();
                if (n != 0 && this.failOnError) {
                    throw new BuildException("Javadoc returned " + n, this.location);
                }
                Object var8_12 = null;
                ((JavadocOutputStream)object4).logFlush();
                ((JavadocOutputStream)object3).logFlush();
            }
            catch (IOException iOException) {
                throw new BuildException("Javadoc failed: " + iOException, iOException, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            ((JavadocOutputStream)object4).logFlush();
            ((JavadocOutputStream)object3).logFlush();
            try {
                ((LogOutputStream)object4).close();
                ((LogOutputStream)object3).close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        ((LogOutputStream)object4).close();
        ((LogOutputStream)object3).close();
        return;
    }

    private void evaluatePackages(Commandline commandline, Path path, Vector vector, Vector vector2) {
        String string;
        this.log("Source path = " + path.toString(), 3);
        this.log("Packages = " + vector, 3);
        this.log("Exclude Packages = " + vector2, 3);
        Vector<String> vector3 = new Vector<String>();
        String[] stringArray = path.list();
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        FileSet fileSet = new FileSet();
        fileSet.setDefaultexcludes(this.useDefaultExcludes);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if ((string = string.replace('.', '/')).endsWith("*")) {
                string = string + "*";
            }
            fileSet.createInclude().setName(string);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if ((string = string.replace('.', '/')).endsWith("*")) {
                string = string + "*";
            }
            fileSet.createExclude().setName(string);
        }
        int n = 0;
        while (n < stringArray.length) {
            File file = this.project.resolveFile(stringArray[n]);
            fileSet.setDir(file);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.project);
            String[] stringArray2 = directoryScanner.getIncludedDirectories();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String string2;
                File file2 = new File(file, stringArray2[n2]);
                String[] stringArray3 = file2.list(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".java");
                    }
                });
                if (stringArray3.length > 0 && !vector3.contains(string2 = stringArray2[n2].replace('/', '.').replace('\\', '.'))) {
                    commandline.createArgument().setValue(string2);
                    vector3.addElement(string2);
                }
                ++n2;
            }
            ++n;
        }
    }

    private class JavadocOutputStream
    extends LogOutputStream {
        private String queuedLine = null;

        JavadocOutputStream(int n) {
            super(Javadoc.this, n);
        }

        protected void processLine(String string, int n) {
            if (n == 2 && string.startsWith("Generating ")) {
                if (this.queuedLine != null) {
                    super.processLine(this.queuedLine, 3);
                }
                this.queuedLine = string;
            } else {
                if (this.queuedLine != null) {
                    if (string.startsWith("Building ")) {
                        super.processLine(this.queuedLine, 3);
                    } else {
                        super.processLine(this.queuedLine, 2);
                    }
                    this.queuedLine = null;
                }
                super.processLine(string, n);
            }
        }

        protected void logFlush() {
            if (this.queuedLine != null) {
                super.processLine(this.queuedLine, 3);
                this.queuedLine = null;
            }
        }
    }

    public class GroupArgument {
        private String title;
        private String packages;

        public void setTitle(String string) {
            this.title = string;
        }

        public String getTitle() {
            return this.title;
        }

        public void setPackages(String string) {
            this.packages = string;
        }

        public String getPackages() {
            return this.packages;
        }
    }

    public class LinkArgument {
        private String href;
        private boolean offline = false;
        private String packagelistLoc;

        public void setHref(String string) {
            this.href = string;
        }

        public String getHref() {
            return this.href;
        }

        public void setPackagelistLoc(String string) {
            this.packagelistLoc = string;
        }

        public String getPackagelistLoc() {
            return this.packagelistLoc;
        }

        public void setOffline(boolean bl) {
            this.offline = bl;
        }

        public boolean isLinkOffline() {
            return this.offline;
        }
    }

    public class DocletInfo {
        private String name;
        private Path path;
        private Vector params = new Vector();

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setPath(Path path) {
            if (this.path == null) {
                this.path = path;
            } else {
                this.path.append(path);
            }
        }

        public Path getPath() {
            return this.path;
        }

        public Path createPath() {
            if (this.path == null) {
                this.path = new Path(Javadoc.this.getProject());
            }
            return this.path.createPath();
        }

        public void setPathRef(Reference reference) {
            this.createPath().setRefid(reference);
        }

        public DocletParam createParam() {
            DocletParam docletParam = new DocletParam();
            this.params.addElement(docletParam);
            return docletParam;
        }

        public Enumeration getParams() {
            return this.params.elements();
        }
    }

    public class DocletParam {
        private String name;
        private String value;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getValue() {
            return this.value;
        }
    }
}

