/*
 * Decompiled with CFR 0.152.
 */
package servlet;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import servlet.ApplyXSLTProperties;

public class DefaultApplyXSLTProperties
extends ApplyXSLTProperties {
    private final String DEFAULT_catalog;
    protected transient String localHost = null;
    protected static int port = 0;

    public DefaultApplyXSLTProperties() {
        this.DEFAULT_catalog = null;
        this.setLocalHost();
    }

    public DefaultApplyXSLTProperties(ServletConfig servletConfig) {
        super(servletConfig);
        String string = servletConfig.getInitParameter("catalog");
        this.DEFAULT_catalog = string != null ? string : null;
        this.setLocalHost();
        this.setSystemProperties();
    }

    public String[] getCatalog(HttpServletRequest httpServletRequest) {
        String[] stringArray = httpServletRequest.getParameterValues("catalog");
        if (this.DEFAULT_catalog == null) {
            return stringArray;
        }
        if (stringArray == null) {
            String[] stringArray2 = new String[]{this.DEFAULT_catalog};
            return stringArray2;
        }
        int n = stringArray.length + 1;
        String[] stringArray3 = new String[n];
        stringArray3[0] = this.DEFAULT_catalog;
        int n2 = 1;
        while (n2 < n) {
            stringArray3[n2] = stringArray[n2 - 1];
            ++n2;
        }
        return stringArray3;
    }

    public String getLocalHost() {
        return this.localHost;
    }

    public String getXMLurl(HttpServletRequest httpServletRequest) throws MalformedURLException {
        URL uRL = this.toSafeURL(this.getRequestParmString(httpServletRequest, "URL"), httpServletRequest);
        if (uRL == null) {
            return super.getXMLurl(null);
        }
        return uRL.toExternalForm();
    }

    public String getXSLRequestURL(HttpServletRequest httpServletRequest) throws MalformedURLException {
        URL uRL = this.toSafeURL(this.getRequestParmString(httpServletRequest, "xslURL"), httpServletRequest);
        if (uRL == null) {
            return null;
        }
        return uRL.toExternalForm();
    }

    public String getXSLurl(HttpServletRequest httpServletRequest) throws MalformedURLException {
        String string = this.getXSLRequestURL(httpServletRequest);
        if (string != null) {
            return string;
        }
        return super.getXSLurl(null);
    }

    protected void setLocalHost() {
        try {
            this.localHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            this.localHost = null;
        }
    }

    protected void setSystemProperties() {
        Properties properties = new Properties();
        ((Hashtable)properties).put("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        ((Hashtable)properties).put("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
        ((Hashtable)properties).put("javax.xml.parsers.SAXParserFactory", "org.apache.xerces.jaxp.SAXParserFactoryImpl");
        Properties properties2 = System.getProperties();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (((Hashtable)properties2).containsKey(string)) continue;
            ((Hashtable)properties2).put(string, properties.getProperty(string));
        }
        System.setProperties(properties2);
    }

    public URL toSafeURL(String string, HttpServletRequest httpServletRequest) throws MalformedURLException {
        if (port == 0) {
            port = httpServletRequest.getServerPort();
        }
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            try {
                return new URL("http", this.localHost, port, string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new MalformedURLException("toSafeURL(): " + string + " did not map to local");
            }
        }
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException("toSafeURL(): " + string + " not a valid URL");
        }
        try {
            return new URL(uRL.getProtocol(), this.localHost, port, uRL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            throw new MalformedURLException("toSafeURL(): " + string + " could not be converted to local host");
        }
    }
}

