/*
 * Decompiled with CFR 0.152.
 */
package org.enhydra.instantdb.db;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;
import java.util.Vector;
import org.enhydra.instantdb.db.BTree;
import org.enhydra.instantdb.db.BitMap;
import org.enhydra.instantdb.db.BlobColumn;
import org.enhydra.instantdb.db.ByteColumn;
import org.enhydra.instantdb.db.Char1Column;
import org.enhydra.instantdb.db.Column;
import org.enhydra.instantdb.db.CurrencyColumn;
import org.enhydra.instantdb.db.Database;
import org.enhydra.instantdb.db.DateColumn;
import org.enhydra.instantdb.db.DoubleColumn;
import org.enhydra.instantdb.db.FileImporter;
import org.enhydra.instantdb.db.FloatColumn;
import org.enhydra.instantdb.db.GrowArray;
import org.enhydra.instantdb.db.Importer;
import org.enhydra.instantdb.db.IntegerColumn;
import org.enhydra.instantdb.db.JdbcImporter;
import org.enhydra.instantdb.db.LongColumn;
import org.enhydra.instantdb.db.Search;
import org.enhydra.instantdb.db.StringColumn;
import org.enhydra.instantdb.db.Table;
import org.enhydra.instantdb.db.Trace;
import org.enhydra.instantdb.db.Transaction;
import org.enhydra.instantdb.db.expression;
import org.enhydra.instantdb.db.indexTable;
import org.enhydra.instantdb.db.matchedTokens;
import org.enhydra.instantdb.db.tokenList;

public class SQLProg {
    Database db;
    boolean endOfSQL = false;
    tokenList tokens;
    matchedTokens matched;
    String originalSQL;
    Table rsTable;
    String rsTableName;
    int rowCount;
    int minTableIndex;
    int maxRows;
    Transaction trans;
    static Integer intZero = new Integer(0);
    indexTable distinctIndex;
    BTree rootNode;
    int outerTableCount;
    boolean isGroupBy;
    Vector groupCols;
    Object[] groupVals;
    boolean doingGroupSelect;
    boolean lastGroup;
    boolean filterScan;
    Table filterRS;
    Table groupTable;
    Search havingSearch;
    Vector havingExps;
    Vector havingExpsCopy;

    public SQLProg(Database database, String string, boolean bl, Transaction transaction) throws SQLWarning, SQLException {
        database.checkForShutdown();
        if (transaction != null && transaction.inTriggers) {
            throw new SQLException("Cannot access database during commit or rollback");
        }
        this.db = database;
        this.originalSQL = string;
        this.trans = transaction;
        if (this.trans != null) {
            this.trans.setSQL(string);
        }
        this.tokens = new tokenList(string, bl);
        this.rsTable = null;
        this.rowCount = -1;
        this.tokens.reset(0);
        this.matched = new matchedTokens(this.tokens, Database.SQLsyntax, this.db, bl);
    }

    SQLProg(Database database, matchedTokens matchedTokens2, Transaction transaction) {
        this.db = database;
        this.trans = transaction;
        this.rsTable = null;
        this.rowCount = -1;
        this.matched = matchedTokens2;
    }

    void addAllCols(Vector vector, Vector vector2, Vector vector3, Table table, int n) {
        Vector vector4 = table.getColList();
        int n2 = 1;
        while (n2 < vector4.size()) {
            Column column = (Column)vector4.elementAt(n2);
            expression expression2 = new expression(column, n);
            if (vector.size() > 1) {
                expression2.setName(String.valueOf((String)vector2.elementAt(n)) + "." + column.getName());
            }
            vector3.addElement(expression2);
            ++n2;
        }
    }

    String addCommaSeperatedStrings(String string, Vector vector, String string2) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(256);
        if (string != null) {
            stringBuffer.append(string);
        }
        int n = 0;
        while (n < vector.size()) {
            this.matched.mark(vector.elementAt(n));
            String string3 = (String)this.matched.get("colName");
            stringBuffer.append(string3);
            if (n == vector.size() - 1) {
                stringBuffer.append(string2);
            } else {
                stringBuffer.append(',');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    void addFK(Table table, Column column) throws SQLException {
        if (column.fkTableName != null) {
            String string = column.fkTableName;
            Table table2 = this.db.getTable(string);
            if (table2 == null) {
                if (string.equalsIgnoreCase(table.getTableName())) {
                    table2 = table;
                } else {
                    throw new SQLException("Table, " + string + ", in Foreign Key definition for column, " + column.colName + ", not found.");
                }
            }
            String string2 = column.fkColName;
            Column column2 = null;
            if (string2 != null) {
                column2 = table2.getColByName(string2);
                if (column2 == null) {
                    throw new SQLException("Column, " + string2 + ", in Foreign Key definition for column, " + column.colName + ", not found.");
                }
            } else {
                column2 = table2.getPrimaryKey();
                if (column2 == null) {
                    throw new SQLException("Table, " + string + ", in Foreign Key definition for column, " + column.colName + ", has no primary key.");
                }
            }
            column.fk = column2;
            column2.addFk(column);
        }
    }

    void addTableToList(String string, Vector vector, Vector vector2) throws SQLException {
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string);
        }
        vector.addElement(table);
        String string2 = (String)this.matched.get("pseudoTable");
        if (string2 == null) {
            string2 = string;
        }
        vector2.addElement(string2);
    }

    public void clearParameters() {
        this.matched.clearParameters();
    }

    public void clearUp() {
        this.matched.finalize();
    }

    void compile_alter_table() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table: " + string + ", not found");
        }
        table.lockTable(this.db.sysTrans, Transaction.WRITE);
        String string2 = null;
        Column column = null;
        if (this.matched.containsKey("column") && (column = table.getColByName(string2 = (String)this.matched.get("column"))) == null) {
            throw new SQLException("Column, " + string2 + " not found");
        }
        if (this.matched.containsKey("add_col")) {
            if (this.matched.containsKey("PRIMARY")) {
                throw new SQLException("Use ALTER TABLE ADD PRIMARY KEY col_list");
            }
            Column column2 = this.createColumn(table);
            try {
                table.newColAdded();
            }
            catch (Exception exception) {
                Vector vector = table.columnList;
                vector.removeElement(column2);
                table.recLength -= column2.getLength();
                throw new SQLException(exception.toString());
            }
        } else if (this.matched.containsKey("alter_col")) {
            String string3 = (String)this.matched.get("value");
            column.setProperty(4, string3);
            String string4 = "UPDATE " + this.db.colsTableName + " SET ColDefault = " + string3 + " WHERE ColID = " + column.getColID();
            this.db.execSQL(string4, this.db.sysTrans);
        } else if (this.matched.containsKey("drop_col")) {
            if (this.matched.containsKey("PRIMARY")) {
                String string5 = String.valueOf(table.getTableName()) + "$pKey";
                String string6 = "DROP INDEX " + string5;
                this.db.execSQL(string6, this.db.sysTrans);
            } else {
                try {
                    table.dropColumn(string2, column);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException.toString());
                }
            }
        } else if (this.matched.containsKey("table_constraint")) {
            Vector vector = (Vector)this.matched.get("colName");
            if (this.matched.containsKey("PRIMARY")) {
                String string7 = "CREATE INDEX " + string + "$pKey ON " + string + " (";
                string7 = this.addCommaSeperatedStrings(string7, vector, ")");
                this.db.execSQL(string7, this.db.sysTrans);
            } else if (this.matched.containsKey("UNIQUE")) {
                String string8 = "UPDATE " + this.db.colsTableName + " SET Flags = Flags+\".UNIQ\"" + " WHERE Flags NOT LIKE \"%UNIQ%\" AND TableID=" + table.getTableID() + " AND ColName IN (";
                string8 = this.addCommaSeperatedStrings(string8, vector, ")");
                this.db.execSQL(string8, this.db.sysTrans);
                Vector vector2 = table.getColList();
                int n = 0;
                while (n < vector2.size()) {
                    column = (Column)vector2.elementAt(n);
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        this.matched.mark(vector.elementAt(n2));
                        String string9 = (String)this.matched.get("colName");
                        if (column.getName().equalsIgnoreCase(string9)) {
                            column.setBooleanProperty(2, true);
                        }
                        ++n2;
                    }
                    ++n;
                }
            }
        }
    }

    void compile_commit() throws SQLException {
        this.matched.setSearchDepth(0);
        if (this.matched.containsKey("COMMIT")) {
            this.trans.commit(this.trans.getSqlID());
        } else {
            this.db.journal.rollback(this.trans);
        }
    }

    void compile_create_index() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("indexName");
        String string2 = (String)this.matched.get("tableName");
        Vector vector = this.matched.getVector("colName");
        boolean bl = this.matched.containsKey("UNIQUE");
        if (vector.size() == 0) {
            throw new SQLException("No columns defined for index: " + string);
        }
        Table table = this.db.getTable(string2);
        if (table == null) {
            throw new SQLException("Table: " + string2 + ", not found");
        }
        table.lockTable(this.db.sysTrans, Transaction.WRITE);
        new indexTable(table, vector, string, bl, this.db.sysTrans, table.partitionNumber);
    }

    void compile_create_table() throws SQLException {
        Vector<String> vector;
        Object object;
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("tableName");
        Table table = null;
        int n = -1;
        if (this.matched.containsKey("PARTITION")) {
            n = this.matched.getInt("partitionNumber");
        }
        table = this.matched.containsKey("TEMPORARY") ? new Table(string, this.db, true, true) : new Table(string, this.db, this.db.sysTrans, n);
        Vector vector2 = this.matched.getVector("column_def");
        int n2 = 0;
        while (n2 < vector2.size()) {
            this.matched.mark(vector2.elementAt(n2));
            object = this.createColumn(table);
            ++n2;
        }
        this.matched.mark(null);
        object = new Vector(1, 1);
        if (this.matched.containsKey("table_constraint")) {
            Vector vector3 = this.matched.getVector("table_constraint");
            int n3 = 0;
            while (n3 < vector3.size()) {
                this.matched.mark(vector3.elementAt(n3));
                Vector vector4 = (Vector)this.matched.get("colName");
                if (vector4 != null) {
                    if (vector4.size() > 1 && this.matched.containsKey("REFERENCES")) {
                        throw new SQLException("Multiple column foreign keys not implemented yet.");
                    }
                    vector = new Vector<String>(5, 5);
                    int n4 = 0;
                    while (n4 < vector4.size()) {
                        this.matched.mark(vector4.elementAt(n4));
                        String string2 = (String)this.matched.get("colName");
                        Column column = table.getColByName(string2);
                        if (column == null) {
                            throw new SQLException("Column not found: " + string2);
                        }
                        this.matched.mark(vector3.elementAt(n3));
                        if (this.matched.containsKey("PRIMARY")) {
                            column.setBooleanProperty(1, true);
                        }
                        if (this.matched.containsKey("UNIQUE")) {
                            vector.addElement(string2);
                        }
                        this.getFKTableAndColName(column);
                        ++n4;
                    }
                    if (vector.size() > 0) {
                        ((Vector)object).addElement(vector);
                    }
                }
                ++n3;
            }
        }
        int n5 = 0;
        while (n5 < table.columnList.size()) {
            Column column = (Column)table.columnList.elementAt(n5);
            this.addFK(table, column);
            ++n5;
        }
        try {
            table.allColumnsAdded(this.db.sysTrans, false);
            int n6 = ((Vector)object).size();
            if (n6 > 0) {
                int n7 = 0;
                while (n7 < n6) {
                    vector = (Vector<String>)((Vector)object).elementAt(n7);
                    String string3 = String.valueOf(string) + "$uniq" + n7;
                    new indexTable(table, vector, string3, true, this.db.sysTrans, n);
                    ++n7;
                }
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception.toString());
        }
    }

    void compile_delete() throws SQLException {
        if (this.trans != null && !this.trans.obeysLocks()) {
            throw new SQLException("Transaction has read only access.");
        }
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        this.lockTableAndFKs(table, null);
        this.rowCount = 0;
        if (!this.matched.containsKey("WHERE")) {
            int n = table.getRowCount();
            int n2 = 1;
            while (n2 <= n) {
                if (!table.rowDeleted(n2)) {
                    table.deleteRow(n2, this.trans, null);
                    ++this.rowCount;
                }
                ++n2;
            }
        } else {
            int[] nArray;
            Vector<Table> vector = new Vector<Table>(1);
            vector.addElement(table);
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement(table.getTableName());
            Search search = new Search(this, vector, vector2, null, false);
            BitMap bitMap = new BitMap(table.rowCount + 1);
            while ((nArray = search.getRows()) != null) {
                bitMap.setBit(nArray[0]);
            }
            int n = -1;
            nArray = new int[1];
            while ((n = bitMap.nextBitSet(n)) >= 0) {
                nArray[0] = n;
                table.deleteRow(nArray[0], this.trans, null);
                ++this.rowCount;
            }
        }
    }

    void compile_drop_index() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("index");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Unable to drop unknown table: " + string);
        }
        if (!(table instanceof indexTable)) {
            throw new SQLException(String.valueOf(string) + " is not an index table");
        }
        table.lockTable(this.db.sysTrans, Transaction.WRITE);
        table.dropTable(this.db.sysTrans);
    }

    void compile_drop_table() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        if (table != null) {
            table.lockTable(this.db.sysTrans, Transaction.WRITE);
            table.dropTable(this.db.sysTrans);
        }
    }

    void compile_import() throws SQLException, IOException {
        Serializable serializable;
        if (!this.trans.obeysLocks()) {
            throw new SQLException("Transaction has read only access.");
        }
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        String string2 = (String)this.matched.get("filename");
        String string3 = (String)this.matched.get("schema");
        Importer importer = null;
        boolean bl = false;
        Table table = this.db.getTable(string);
        if (table == null) {
            table = new Table(string, this.db, this.trans, -1);
        } else {
            bl = true;
        }
        int n = 0;
        if (this.matched.containsKey("BUFFER")) {
            n = this.matched.getInt("rows");
        }
        importer = this.matched.containsKey("URL") ? new JdbcImporter(this.db, string2, string3, table, this.trans, this.db.dbProperties) : new FileImporter(table, string2, string3, this.trans, this.db);
        if (!bl) {
            serializable = this.db.sysTrans;
            synchronized (serializable) {
                try {
                    this.db.lockSystemTables(this.db.sysTrans);
                    table.allColumnsAdded(this.db.sysTrans, false);
                    this.db.sysTrans.commit(this.db.sysTrans.getSqlID());
                }
                catch (SQLException sQLException) {
                    this.db.journal.rollback(this.db.sysTrans);
                    throw sQLException;
                }
            }
        }
        if (n > 0) {
            table.rndFile.createWriteBuffer(n);
        }
        serializable = new Vector(table.getColCount());
        int n2 = 0;
        while (n2 < table.getColCount()) {
            ((Vector)serializable).addElement(intZero);
            ++n2;
        }
        int n3 = 1;
        while (importer.hasMoreRows()) {
            try {
                importer.getNextRow((Vector)serializable, n3);
                table.addRowAtRow((Vector)serializable, table.getRowCount() + 1, this.trans);
            }
            catch (Exception exception) {
                System.out.println("Error importing line " + n3);
                System.out.println(importer.getCurLine());
                exception.printStackTrace();
            }
            if (++n3 % 100 == 0 && Trace.traceIt(32)) {
                Trace.traceOut(String.valueOf(n3) + " rows imported");
            }
            if (n3 % this.db.transImports == 0) {
                this.trans.commit(this.trans.getSqlID());
            }
            Thread.yield();
        }
        this.rowCount = n3;
        if (n > 0) {
            table.rndFile.writeWriteBuffer(true);
        }
        importer.close();
    }

    void compile_insert() throws SQLException {
        if (!this.trans.obeysLocks()) {
            throw new SQLException("Transaction has read only access.");
        }
        this.matched.mark("insert_statement");
        this.matched.setSearchDepth(3);
        Object object = this.matched.getMark();
        String string = (String)this.matched.get("tableName");
        Hashtable hashtable = null;
        boolean bl = false;
        int n = 1;
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table not found: " + string);
        }
        table.lockTable(this.trans, Transaction.WRITE);
        Vector vector = table.getColList();
        Vector<Object> vector2 = new Vector<Object>(5, 5);
        Vector vector3 = this.matched.getVector("insert_item");
        if (vector3.size() != 0) {
            int n2 = 0;
            while (n2 < vector3.size()) {
                this.matched.mark(vector3.elementAt(n2));
                vector2.addElement(this.matched.get("value"));
                ++n2;
            }
        }
        this.matched.mark(object);
        this.matched.mark("insert_list");
        Vector vector4 = this.matched.getVector("colName");
        this.matched.mark(object);
        this.matched.setSearchDepth(0);
        if (this.matched.containsKey("select_statement")) {
            this.compile_select(null, null, null);
            if (this.rsTable.rowCount == 0) {
                return;
            }
            bl = true;
        }
        this.rowCount = 0;
        do {
            if (bl) {
                this.rsTable.getRow(n++, vector2);
            }
            if (vector4.size() > 0) {
                hashtable = new Hashtable(table.getColCount() * 2 + 1, 0.5f);
                if (bl) {
                    vector2.removeElementAt(0);
                }
                if (vector4.size() != vector2.size()) {
                    throw new SQLException("Incorrect number of values");
                }
                int n3 = 0;
                while (n3 < vector4.size()) {
                    String string2 = (String)vector4.elementAt(n3);
                    if (!table.checkColName(string2)) {
                        throw new SQLException("Unknown column : " + string2);
                    }
                    if (vector2.elementAt(n3) == null) {
                        vector2.setElementAt("NULL", n3);
                    }
                    hashtable.put(table.getColByName(string2).getName(), vector2.elementAt(n3));
                    ++n3;
                }
                table.addRow(hashtable, this.trans);
            } else {
                if (!bl) {
                    vector2.insertElementAt(intZero, 0);
                }
                if (vector.size() != vector2.size()) {
                    throw new SQLException("Incorrect number of values");
                }
                table.addRow(vector2, this.trans);
            }
            if (bl && n > this.rsTable.getRowCount()) {
                bl = false;
            }
            ++this.rowCount;
        } while (bl);
    }

    /*
     * Unable to fully structure code
     */
    Vector compile_select(Vector var1_1, Vector var2_2, int[] var3_3) throws SQLException {
        var9_4 = null;
        var11_5 = false;
        if (this.doingGroupSelect) {
            var11_5 = true;
        }
        if (this.isGroupBy) {
            this.matched.reset();
            this.matched.mark("group_condition");
        } else {
            this.matched.mark("select_statement");
        }
        var9_4 = this.matched.getMark();
        this.matched.setSearchDepth(1);
        if (!this.filterScan && !this.doingGroupSelect && this.matched.containsKey("group_condition")) {
            this.handleGroupBy();
            return null;
        }
        if (this.matched.containsKey("DISTINCT")) {
            var11_5 = true;
        }
        var12_6 = null;
        var13_7 = null;
        if (!this.doingGroupSelect) {
            var14_8 = (Vector<expression>)this.matched.get("table_ref");
            var15_9 = 0;
            if (var14_8 != null) {
                var15_9 = var14_8.size();
            }
            if (var1_1 != null) {
                this.outerTableCount = var1_1.size();
                var15_9 += var1_1.size();
            }
            this.minTableIndex = var15_9;
            var12_6 = new Vector<E>(var15_9);
            var13_7 = new Vector<E>(var15_9);
            if (var1_1 != null) {
                var16_12 = 0;
                while (var16_12 < var1_1.size()) {
                    var12_6.addElement(var1_1.elementAt(var16_12));
                    var13_7.addElement(var2_2.elementAt(var16_12));
                    ++var16_12;
                }
            }
            var16_12 = 0;
            while (var16_12 < var14_8.size()) {
                block68: {
                    var9_4 = this.matched.mark(var14_8.elementAt(var16_12));
                    if (this.matched.containsKey("select_statement")) {
                        var17_16 = new SQLProg(this.db, this.matched, this.trans);
                        var4_15 = (String)this.matched.get("pseudoTable");
                        var17_16.setResultSetTableName(var4_15);
                        try {
                            var17_16.compile_select(null, null, null);
                            break block68;
                        }
                        catch (Exception var18_23) {
                            var19_25 = this.db.getTable(var4_15);
                            if (var19_25 != null) {
                                this.db.removeTable(var19_25);
                            }
                            var20_33 = 0;
                            ** while (var20_33 < var12_6.size())
                        }
lbl-1000:
                        // 1 sources

                        {
                            var19_25 = (Table)var12_6.elementAt(var20_33);
                            if (var19_25.addToTableList) {
                                this.db.removeTable(var19_25);
                            }
                            ++var20_33;
                            continue;
                        }
lbl62:
                        // 1 sources

                        throw new SQLException(var18_23.toString());
                    }
                    if (this.matched.containsKey("join_spec")) {
                        this.matched.setSearchDepth(3);
                        this.matched.mark("join_item");
                        var4_15 = (String)this.matched.get("tableName");
                        this.addTableToList(var4_15, var12_6, var13_7);
                        this.matched.mark(var14_8.elementAt(var16_12));
                        this.matched.mark("join_item2");
                        var4_15 = (String)this.matched.get("tableName");
                        this.matched.setSearchDepth(2);
                    } else {
                        var4_15 = (String)this.matched.get("refTable");
                    }
                }
                this.addTableToList(var4_15, var12_6, var13_7);
                this.matched.mark(var9_4);
                ++var16_12;
            }
            this.db.lockTables(var12_6, this.trans, Transaction.READ);
        } else {
            var12_6 = new Vector<E>(1);
            var13_7 = new Vector<E>(1);
            var12_6.addElement(this.filterRS);
            var13_7.addElement(this.filterRS.getTableName());
        }
        var14_8 = new Vector<expression>(10, 5);
        this.matched.setSearchDepth(1);
        if (this.matched.containsKey("*") || this.filterScan) {
            var15_9 = 0;
            if (var1_1 != null) {
                var15_9 = var1_1.size();
            }
            var16_12 = var15_9;
            while (var16_12 < var12_6.size()) {
                var7_35 = (Table)var12_6.elementAt(var16_12);
                this.addAllCols(var12_6, var13_7, var14_8, var7_35, var16_12);
                ++var16_12;
            }
        } else {
            var15_10 = (Vector)this.matched.get("select_item");
            var16_12 = 0;
            while (var16_12 < var15_10.size()) {
                this.matched.mark(var15_10.elementAt(var16_12));
                var6_36 = (String)this.matched.get("pseudoCol");
                this.matched.mark("expr");
                this.matched.setSearchDepth(3);
                if (this.matched.containsKey("all_cols")) {
                    this.matched.mark("all_cols");
                    var17_16 = (String)this.matched.get("tableName");
                    var18_24 = 0;
                    while (var18_24 < var12_6.size()) {
                        var19_26 = (Table)var12_6.elementAt(var18_24);
                        var20_34 = var19_26.getTableName();
                        var21_38 = (String)var13_7.elementAt(var18_24);
                        if (var20_34.equalsIgnoreCase((String)var17_16) || var21_38.equalsIgnoreCase((String)var17_16)) {
                            this.addAllCols(var12_6, var13_7, var14_8, var19_26, var18_24);
                            break;
                        }
                        ++var18_24;
                    }
                } else {
                    var10_37 = new expression(this.matched, var12_6, var13_7, this.doingGroupSelect);
                    if (var6_36 != null) {
                        var10_37.setName(var6_36);
                    }
                    var14_8.addElement(var10_37);
                }
                ++var16_12;
            }
        }
        this.matched.mark(var9_4);
        var15_11 = var14_8.size();
        if (this.rsTable == null) {
            var16_12 = 0;
            var17_17 = true;
            if (this.rsTableName == null) {
                this.rsTableName = this.db.getTmpFile();
            } else {
                var16_12 = 1;
            }
            if (this.matched.containsKey("destTable") && !this.filterScan && !this.isGroupBy) {
                this.rsTableName = (String)this.matched.get("destTable");
                this.db.lockSystemTables(this.trans);
                var17_17 = false;
            }
            this.rsTable = new Table(this.rsTableName, this.db, var17_17, (boolean)var16_12);
            if (var12_6.size() == 1) {
                this.rsTable.fromTable = new GrowArray(this.rowCount);
                this.rsTable.underlyingTable = (Table)var12_6.elementAt(0);
            }
            this.rsTableName = null;
            var18_24 = 0;
            while (var18_24 < var15_11) {
                var10_37 = (expression)var14_8.elementAt(var18_24);
                var10_37.addToResultsSet(this.rsTable);
                var19_27 = var10_37.getMinTableIndex();
                if (var19_27 < this.minTableIndex) {
                    this.minTableIndex = var19_27;
                }
                ++var18_24;
            }
            try {
                this.rsTable.allColumnsAdded(this.trans, false);
            }
            catch (Exception var19_28) {
                throw new SQLException(var19_28.toString());
            }
        }
        if (!this.doingGroupSelect && !this.filterScan) {
            this.lastGroup = true;
        }
        this.matched.mark(var9_4);
        this.matched.setSearchDepth(1);
        if (this.matched.containsKey("ORDER") && this.lastGroup) {
            var16_13 = (Vector)this.matched.get("order_clause");
            var17_18 = 0;
            while (var17_18 < var16_13.size()) {
                this.matched.mark(var16_13.elementAt(var17_18));
                var18_24 = 0;
                if (this.matched.containsKey("DESC")) {
                    var18_24 = 1;
                }
                var19_29 = (String)this.matched.get("colName");
                var4_15 = null;
                if (this.matched.containsKey("tabName")) {
                    var4_15 = (String)this.matched.get("tabName");
                }
                this.rsTable.addOrderedField(var4_15, var19_29, (boolean)var18_24);
                ++var17_18;
            }
        }
        this.matched.mark(var9_4);
        this.matched.setSearchDepth(2);
        var16_14 = new Search(this, var12_6, var13_7, null, false);
        if (this.isGroupBy) {
            var16_14.isGroupBy = true;
            this.havingSearch = var16_14;
            this.havingExps = var16_14.getExps();
            var17_19 = this.havingExps.size();
            this.havingExpsCopy = new Vector<E>(var17_19);
            var18_24 = 0;
            while (var18_24 < var17_19) {
                var19_30 = (expression)this.havingExps.elementAt(var18_24);
                this.havingExpsCopy.addElement(var19_30.clone());
                ++var18_24;
            }
        } else if (this.doingGroupSelect) {
            var17_20 = 0;
            while (var17_20 < this.havingExps.size()) {
                var14_8.addElement((expression)this.havingExps.elementAt(var17_20));
                ++var17_20;
            }
        }
        if (var3_3 != null) {
            var16_14.setRows(var3_3);
        }
        if (this.doingGroupSelect && !this.isGroupBy) {
            var17_21 = new Vector<Object>(this.groupCols.size());
            var18_24 = 0;
            var19_31 = 0;
            while (var19_31 < this.groupCols.size()) {
                var10_37 = (expression)this.groupCols.elementAt(var19_31);
                var20_34 = var10_37.getColumn();
                if (var20_34 != null) {
                    var17_21.addElement(var20_34);
                    var16_14.rows[0].col = var20_34;
                    var18_24 = 1;
                }
                ++var19_31;
            }
            var20_34 = null;
            if (var18_24 != 0) {
                var16_14.rows[0].index = var20_34 = new indexTable(this.db, this.filterRS, var17_21);
                var16_14.rows[0].noCompare = true;
            }
            var11_5 = false;
            var21_39 = this.groupCols.size();
            var22_40 = this.groupTable.rowCount;
            var23_41 = new Vector<E>(var21_39 + 1);
            var24_42 = 1;
            while (var24_42 <= var22_40) {
                this.groupTable.getRow(var24_42, var23_41);
                var25_43 = 0;
                while (var25_43 < this.groupVals.length) {
                    this.groupVals[var25_43] = var23_41.elementAt(var25_43 + 1);
                    ++var25_43;
                }
                var16_14.setGroupConditions(this.groupCols, this.groupVals, (indexTable)var20_34);
                this.evaluateSelectExpressions(var14_8, var16_14, var15_11, var11_5, var12_6);
                this.havingSearch.resetExps(this.havingExps, this.havingExpsCopy);
                var16_14.reset();
                var16_14.done = false;
                var26_44 = 0;
                while (var26_44 < var14_8.size()) {
                    var10_37 = (expression)var14_8.elementAt(var26_44);
                    var10_37.reset();
                    ++var26_44;
                }
                ++var24_42;
            }
            this.lastGroup = true;
            this.minTableIndex = 0x7FFFFFFF;
        } else {
            this.evaluateSelectExpressions(var14_8, var16_14, var15_11, var11_5, var12_6);
        }
        if (this.lastGroup) {
            if (this.rsTable.numOrdered > 0 && this.rsTable.rowCount > 0) {
                this.rootNode.sortNoSwap();
            }
            var17_22 = this.rsTable.columnList;
            var18_24 = 1;
            while (var18_24 < var17_22.size()) {
                var10_37 = (expression)var14_8.elementAt(var18_24 - 1);
                var8_45 = (Column)var17_22.elementAt(var18_24);
                if (var10_37.exprClass == 1) {
                    var8_45.setBooleanProperty(5, var10_37.col.isAutoIncrement());
                    var8_45.notNull = var10_37.col.notNull;
                } else {
                    var8_45.readOnly = true;
                }
                ++var18_24;
            }
            if (var1_1 == null && !this.rsTable.addToTableList) {
                if (this.db.exportSQL != 0 && this.db.export != null) {
                    this.rsTable.exportText(this.originalSQL);
                } else {
                    this.rsTable.exportText(null);
                }
            }
            var19_32 = 0;
            while (var19_32 < var12_6.size()) {
                var20_34 = (Table)var12_6.elementAt(var19_32);
                if (var20_34.addToTableList) {
                    this.db.removeTable((Table)var20_34);
                }
                ++var19_32;
            }
        }
        return var14_8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void compile_set() throws SQLException {
        this.matched.setSearchDepth(0);
        String string = null;
        String string2 = null;
        string = (String)this.matched.get("date");
        if (string != null) {
            if (this.matched.containsKey("DATETIME")) {
                this.trans.dateTimeFormat = string;
                return;
            } else {
                this.trans.dateFormat = string;
            }
            return;
        }
        string = (String)this.matched.get("datetime");
        if (string != null) return;
        string = (String)this.matched.get("LITERALS");
        if (string != null) {
            string = (String)this.matched.get("STRICT_ON");
            this.db.strictLiterals = string != null;
            return;
        }
        string = (String)this.matched.get("DEFAULT_USERNAME");
        if (string != null) {
            this.db.defaultUsername = (String)this.matched.get("uname");
            if (!this.matched.containsKey("DEFAULT_PASSWORD")) return;
            this.db.defaultPassword = (String)this.matched.get("pword");
            return;
        }
        string = (String)this.matched.get("cur");
        if (string != null) {
            this.trans.currencySymbol = string.charAt(0);
            return;
        }
        string = (String)this.matched.get("dec");
        if (string != null) {
            this.trans.currencyDecimal = Integer.parseInt(string);
            return;
        }
        if (this.matched.containsKey("INCREMENT_BASE")) {
            String string3 = (String)this.matched.get("base");
            Long l = null;
            if (string3 != null) {
                l = new Long(string3);
            }
            if (this.matched.containsKey("ALL")) {
                int n = 0;
                while (n < this.db.tblList.size()) {
                    Table table = (Table)this.db.tblList.elementAt(n);
                    int n2 = 1;
                    while (n2 < table.columnList.size()) {
                        Column column = (Column)table.columnList.elementAt(n2);
                        if (column.isAutoIncrement()) {
                            column.setProperty(7, l);
                            try {
                                column.close(table.rndFile);
                            }
                            catch (IOException iOException) {
                                throw new SQLException(iOException.toString());
                            }
                        }
                        ++n2;
                    }
                    ++n;
                }
                return;
            }
            String string4 = (String)this.matched.get("table");
            String string5 = (String)this.matched.get("column");
            Table table = this.db.getTable(string4);
            if (table == null) {
                throw new SQLException("Table " + string4 + " not found");
            }
            Column column = table.getColByName(string5);
            if (column == null) {
                throw new SQLException("Table " + string4 + " column " + string5 + " not found");
            }
            column.setProperty(7, l);
            try {
                column.close(table.rndFile);
                return;
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.toString());
            }
        }
        string = (String)this.matched.get("INCREMENT");
        if (string != null) {
            String string6 = (String)this.matched.get("table");
            Table table = this.db.getTable(string6);
            if (table == null) {
                throw new SQLException("Table " + string6 + " not found");
            }
            table.autoIncOff = this.matched.containsKey("OFF");
            return;
        } else {
            string2 = (String)this.matched.get("filename");
            if (string2 == null) return;
            string = (String)this.matched.get("level");
            int n = 0;
            n = string == null ? 0 : Integer.parseInt(string);
            Trace trace = Trace.getTrace();
            trace.setExport(string2, n + 2048);
            trace.colHeaders = false;
            trace.csvDelimited = true;
            trace.printRowNumbers = false;
            trace.printDelRows = false;
            trace.printControlCol = false;
            trace.traceConsole = 0;
            trace.printSummaryHeader = false;
            trace.includeTime = false;
            if (this.matched.containsKey("SQL")) {
                this.db.exportSQL = 1;
            }
            if (this.matched.containsKey("NO")) {
                this.db.exportSQL = 0;
            }
            if (this.matched.containsKey("TIME")) {
                trace.includeTime = true;
            }
            if (this.matched.containsKey("CONSOLE")) {
                trace.traceConsole = 1;
            }
            if (this.matched.containsKey("COLNAMEHEADER")) {
                trace.colHeaders = true;
            }
            if (this.matched.containsKey("CSVDELIMITED")) {
                trace.csvDelimited = true;
                trace.delimiter = (char)44;
            }
            if (this.matched.containsKey("DELIMITED")) {
                trace.csvDelimited = true;
                string = (String)this.matched.get("delimiter");
                trace.delimiter = string.charAt(0);
            }
            if (this.matched.containsKey("FIXEDLENGTH")) {
                trace.csvDelimited = false;
            }
            if (this.matched.containsKey("ROWNUMBERS")) {
                trace.printRowNumbers = true;
            }
            if (this.matched.containsKey("CONTROLCOL")) {
                trace.printControlCol = true;
            }
            if (this.matched.containsKey("SUMMARYHEADER")) {
                trace.printSummaryHeader = true;
            }
            if (!this.matched.containsKey("QUOTE")) return;
            string = (String)this.matched.get("quoteChar");
            trace.setQuote(string.charAt(0));
        }
    }

    void compile_shutdown() throws SQLException {
        boolean bl = false;
        this.matched.setSearchDepth(0);
        if (this.matched.containsKey("NOWAIT")) {
            bl = true;
        }
        this.db.shutdown(this.originalSQL, bl);
    }

    void compile_update() throws SQLException {
        Object object;
        Object object2;
        Object object3;
        if (this.trans != null && !this.trans.obeysLocks()) {
            throw new SQLException("Transaction has read only access.");
        }
        this.matched.setSearchDepth(0);
        String string = (String)this.matched.get("table");
        Table table = this.db.getTable(string);
        if (table == null) {
            throw new SQLException("Table " + string + " not found");
        }
        table.lockTable(this.trans, Transaction.WRITE);
        Vector<Table> vector = new Vector<Table>(1);
        vector.addElement(table);
        Vector<String> vector2 = new Vector<String>(1);
        vector2.addElement(table.getTableName());
        Search search = new Search(this, vector, vector2, null, false);
        this.matched.setSearchDepth(0);
        Vector vector3 = (Vector)this.matched.get("assignment");
        expression[] expressionArray = new expression[vector3.size()];
        Column[] columnArray = new Column[vector3.size()];
        int[] nArray = new int[vector3.size()];
        int n = 0;
        while (n < vector3.size()) {
            this.matched.mark(vector3.elementAt(n));
            object3 = (String)this.matched.get("column");
            columnArray[n] = table.getColByName((String)object3);
            if (columnArray[n] == null) {
                throw new SQLException("Column: " + (String)object3 + ", not found");
            }
            nArray[n] = table.getRelColPosn((String)object3);
            if (this.matched.containsKey("NULL")) {
                expressionArray[n] = null;
            } else if (this.matched.containsKey("select_statement")) {
                this.matched.mark("select_statement");
                this.compile_select(null, null, null);
                if (this.rsTable.rowCount != 1 || this.rsTable.columnList.size() != 2) {
                    throw new SQLException("SET expression sub-query must return a single row and column");
                }
                object2 = (Column)this.rsTable.columnList.elementAt(1);
                this.rsTable = null;
                object = ((Column)object2).getByRow(1);
                expressionArray[n] = new expression(this.db, object);
            } else {
                this.matched.mark("expr");
                expressionArray[n] = new expression(this.matched, vector, vector2, new expression(columnArray[n], n));
            }
            ++n;
        }
        object2 = new BitMap(table.rowCount + 1);
        while ((object3 = search.getRows()) != null) {
            ((BitMap)object2).setBit(object3[0]);
        }
        this.rowCount = 0;
        object = new Vector<Object>(table.getColCount());
        int n2 = -1;
        object3 = new int[1];
        while ((n2 = ((BitMap)object2).nextBitSet(n2)) >= 0) {
            table.getRow(n2, (Vector)object);
            int n3 = 0;
            while (n3 < columnArray.length) {
                Object object4 = null;
                if (expressionArray[n3] != null) {
                    object3[0] = n2;
                    object4 = expressionArray[n3].evaluate((int[])object3);
                }
                ((Vector)object).setElementAt(columnArray[n3].toObject(object4), nArray[n3]);
                ++n3;
            }
            try {
                table.setUpdateFlags(true);
                table.deleteRow(n2, this.trans, (Vector)object);
                table.addRow(object, this.trans);
            }
            finally {
                Object var17_18 = null;
                table.setUpdateFlags(false);
            }
            ++this.rowCount;
        }
    }

    private Column createColumn(Table table) throws SQLException {
        int n;
        String string = (String)this.matched.get("colName");
        if (table.getColByName(string) != null) {
            throw new SQLException("Duplicate column name: " + string);
        }
        Column column = null;
        if (this.matched.containsKey("INT") || this.matched.containsKey("INTEGER") || this.matched.containsKey("SMALLINT")) {
            column = new IntegerColumn(table, string);
        } else if (this.matched.containsKey("CHAR") || this.matched.containsKey("VARCHAR") || this.matched.containsKey("VARCHAR2")) {
            int n2 = this.matched.getInt("length");
            column = new StringColumn(table, string, n2);
        } else if (this.matched.containsKey("SMALLCHAR")) {
            int n3 = this.matched.getInt("length");
            column = new Char1Column(table, string, n3);
        } else if (this.matched.containsKey("BYTE") || this.matched.containsKey("BIT") || this.matched.containsKey("BOOLEAN")) {
            column = new ByteColumn(table, string);
        } else if (this.matched.containsKey("TINYINT")) {
            column = new ByteColumn(table, string);
        } else if (this.matched.containsKey("LONG")) {
            column = new LongColumn(table, string);
        } else if (this.matched.containsKey("NUMERIC") || this.matched.containsKey("DECIMAL")) {
            int n4 = 108;
            int n5 = 0;
            n = 0;
            if (this.matched.containsKey("precision")) {
                n5 = this.matched.getInt("precision");
            }
            if (this.matched.containsKey("scale")) {
                n = this.matched.getInt("scale");
            }
            column = n != 0 ? new DoubleColumn(table, string) : (n5 == 0 || n5 > 9 ? new LongColumn(table, string) : new IntegerColumn(table, string));
        } else if (this.matched.containsKey("DATE")) {
            String string2 = (String)this.matched.get("formatString");
            if (string2 == null) {
                string2 = this.trans.dateFormat;
            }
            column = new DateColumn(table, string, string2);
        } else if (this.matched.containsKey("DATETIME") || this.matched.containsKey("TIME") || this.matched.containsKey("TIMESTAMP")) {
            String string3 = (String)this.matched.get("formatString");
            if (string3 == null) {
                string3 = this.trans.dateTimeFormat;
            }
            column = new DateColumn(table, string, string3);
        } else if (this.matched.containsKey("FLOAT") || this.matched.containsKey("SHORT") || this.matched.containsKey("SINGLE")) {
            column = new FloatColumn(table, string);
        } else if (this.matched.containsKey("CURRENCY")) {
            char c = this.trans.currencySymbol;
            String string4 = (String)this.matched.get("formatString");
            if (string4 != null) {
                c = string4.charAt(0);
            }
            column = new CurrencyColumn(table, string, c, this.trans.currencyDecimal);
        } else if (this.matched.containsKey("DOUBLE")) {
            column = new DoubleColumn(table, string);
        } else if (this.matched.containsKey("BINARY") || this.matched.containsKey("VARBINARY") || this.matched.containsKey("LONGVARBINARY") || this.matched.containsKey("IMAGE") || this.matched.containsKey("OLE")) {
            column = new BlobColumn(table, string, BlobColumn.BINARY_BLOB);
        } else if (this.matched.containsKey("TEXT") || this.matched.containsKey("LONGCHAR")) {
            column = new BlobColumn(table, string, BlobColumn.STRING_BLOB);
        } else {
            throw new SQLException("Unknown data type: " + this.matched.toString());
        }
        String string5 = (String)this.matched.get("default");
        if (string5 != null) {
            column.setProperty(4, string5);
        }
        if (this.matched.containsKey("CACHE")) {
            int n6 = this.matched.getInt("rows");
            n = 2;
            if (this.matched.containsKey("ROWS")) {
                n = 1;
            }
            column.setCacheCondition(n, n6);
        }
        if (this.matched.containsKey("NOT")) {
            column.setBooleanProperty(3, true);
        }
        if (this.matched.containsKey("AUTO")) {
            column.setBooleanProperty(5, true);
        }
        if (this.matched.containsKey("UNIQUE")) {
            column.setBooleanProperty(2, true);
        }
        if (this.matched.containsKey("PRIMARY")) {
            column.setBooleanProperty(1, true);
        }
        this.getFKTableAndColName(column);
        return column;
    }

    void evaluateSelectExpressions(Vector vector, Search search, int n, boolean bl, Vector vector2) throws SQLException {
        boolean bl2 = false;
        int n2 = 0;
        boolean bl3 = true;
        do {
            int[] nArray;
            if (++n2 % 100 == 0 && Trace.traceIt(32)) {
                Trace.traceOut(String.valueOf(n2) + " rows selected");
            }
            bl2 = false;
            boolean bl4 = true;
            this.distinctIndex = null;
            do {
                Object object;
                nArray = search.getRows();
                if (this.trans.timeoutExpired) {
                    this.trans.timeoutExpired = false;
                    throw new SQLException("Query: " + this.originalSQL + "\nis taking too long.");
                }
                Vector<Object> vector3 = new Vector<Object>(n + 1);
                vector3.addElement(intZero);
                boolean bl5 = false;
                if (nArray == null && bl3) {
                    bl5 = true;
                }
                bl3 = false;
                Object object2 = null;
                int n3 = 0;
                while (n3 < vector.size()) {
                    object = (expression)vector.elementAt(n3);
                    object2 = ((expression)object).evaluate(nArray);
                    if (!((expression)object).isConstant()) {
                        bl4 = false;
                    }
                    if (object2 == null) {
                        bl5 = true;
                    }
                    if (((expression)object).exprContainsFunc) {
                        bl2 = true;
                    } else if (!bl5 && n3 < n) {
                        vector3.addElement(object2);
                    }
                    ++n3;
                }
                if (bl5) continue;
                if (bl) {
                    if (this.distinctIndex == null) {
                        this.distinctIndex = new indexTable(this.db, this.rsTable, null);
                    }
                    if ((object = (Object)this.distinctIndex.lookupValue(vector3, true)) != null && this.distinctIndex.checkUnique((int)object[0], (int)object[1], vector3, true) != -1) {
                        bl5 = true;
                    }
                }
                if (!bl5 && this.doingGroupSelect && !this.isGroupBy) {
                    bl5 = this.havingSearch.evaluate(nArray) ^ true;
                    bl4 = true;
                }
                if (!bl5) {
                    int n4 = 0;
                    n4 = nArray != null ? this.rsTable.addRow(vector3, null, nArray[0]) : this.rsTable.addRow(vector3, null);
                    if (this.distinctIndex != null) {
                        this.distinctIndex.addRowToIndex(n4);
                    }
                    if (this.lastGroup && this.rsTable.numOrdered > 0) {
                        if (this.rsTable.rowCount == 1) {
                            this.rootNode = new BTree(this.rsTable, 0);
                        } else {
                            this.rootNode.add(n4 - 1);
                        }
                        if (this.rsTable.getValidRowCount() > this.maxRows && this.maxRows > 0) {
                            int n5 = this.rootNode.getMax();
                            this.rsTable.deleteRow(n5 + 1, null, null);
                            this.rsTable.minRowDeleted = this.rsTable.rowCount + 1;
                            this.rootNode = this.rootNode.deleteMax();
                            this.rsTable.underlyingTable = null;
                            this.rsTable.fromTable = null;
                            if (this.distinctIndex != null) {
                                this.distinctIndex.delRowFromIndex(n5 + 1);
                            }
                        }
                    }
                }
                if (this.rsTable.getValidRowCount() >= this.maxRows && this.maxRows > 0 && this.rsTable.numOrdered == 0) break;
            } while (!bl4 && nArray != null);
            search.reset();
        } while (bl2);
    }

    public void execute() throws SQLException {
        block40: {
            if (this.tokens.size() == 0) {
                return;
            }
            if (Trace.traceIt(2)) {
                if (this.tokens.parameterCount > 0) {
                    Trace.traceOut(this.tokens.getSQL(this.matched));
                } else {
                    Trace.traceOut(this.originalSQL);
                }
            }
            this.db.checkForShutdown();
            if (this.rsTable != null) {
                this.rsTable.dropTable(this.trans);
            }
            this.rsTable = null;
            this.rowCount = -1;
            if (this.tokens.mark() < this.tokens.size()) {
                if (Trace.traceIt(512)) {
                    Trace.traceOut(this.matched.toString());
                }
                StringBuffer stringBuffer = new StringBuffer(String.valueOf(this.originalSQL) + "\n Don't understand SQL after: \"" + this.tokens.getNext() + "\"");
                if (this.matched.depth > 0) {
                    stringBuffer.append("\n Expected: \"" + this.matched.expected + "\"");
                    stringBuffer.append(" found: \"" + this.matched.found + "\"");
                    if (this.matched.reservedWord) {
                        stringBuffer.append(" (reserved word)");
                    }
                }
                Trace.traceOut(stringBuffer.toString());
                throw new SQLException(stringBuffer.toString());
            }
            if (Trace.traceIt(512)) {
                Trace.traceOut(this.matched.toString());
            }
            this.matched.reset();
            this.matched.setSearchDepth(2);
            try {
                if (this.matched.containsKey("select_statement")) {
                    this.isGroupBy = false;
                    this.filterScan = false;
                    this.lastGroup = false;
                    this.doingGroupSelect = false;
                    this.compile_select(null, null, null);
                    break block40;
                }
                if (this.matched.containsKey("insert_statement")) {
                    this.compile_insert();
                    break block40;
                }
                if (this.matched.containsKey("update_statement")) {
                    this.compile_update();
                    break block40;
                }
                if (this.matched.containsKey("delete_statement")) {
                    this.compile_delete();
                    break block40;
                }
                if (this.matched.containsKey("set_statement")) {
                    this.compile_set();
                    break block40;
                }
                if (this.matched.containsKey("shutdown_statement")) {
                    this.compile_shutdown();
                    break block40;
                }
                if (this.matched.containsKey("commit_statement")) {
                    this.compile_commit();
                    break block40;
                }
                if (this.matched.containsKey("import_statement")) {
                    try {
                        this.compile_import();
                        break block40;
                    }
                    catch (Exception exception) {
                        if (Trace.traceIt(4)) {
                            exception.printStackTrace();
                        }
                        throw exception.fillInStackTrace();
                    }
                }
                Transaction transaction = this.db.sysTrans;
                synchronized (transaction) {
                    try {
                        this.trans.commit(this.trans.getSqlID());
                        this.db.sysTrans.setSQL(this.originalSQL);
                        this.db.lockSystemTables(this.db.sysTrans);
                        if (this.matched.containsKey("create_table_statement")) {
                            this.compile_create_table();
                        } else if (this.matched.containsKey("create_index_statement")) {
                            this.compile_create_index();
                        } else if (this.matched.containsKey("drop_index_statement")) {
                            this.compile_drop_index();
                        } else if (this.matched.containsKey("drop_table_statement")) {
                            this.compile_drop_table();
                        } else if (this.matched.containsKey("alter_table_statement")) {
                            this.compile_alter_table();
                        } else {
                            throw new SQLException("Invalid SQL: " + this.originalSQL);
                        }
                        this.db.sysTrans.commit(this.db.sysTrans.getSqlID());
                        Object var2_5 = null;
                        return;
                    }
                    catch (Exception exception) {
                        this.db.journal.rollback(this.db.sysTrans);
                        Trace.traceOut(exception.toString());
                        if (Trace.traceIt(4)) {
                            exception.printStackTrace();
                        }
                        throw exception.fillInStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                this.db.journal.rollback(this.trans);
                Trace.traceOut(throwable.toString());
                if (Trace.traceIt(4)) {
                    throwable.printStackTrace();
                }
                throw new SQLException(throwable.getMessage());
            }
        }
    }

    protected void finalize() throws Throwable {
        this.rsTable = null;
    }

    void getFKTableAndColName(Column column) {
        if (this.matched.containsKey("REFERENCES")) {
            column.fkTableName = (String)this.matched.get("refTable");
            column.fkColName = (String)this.matched.get("refColumn");
            column.fk_flags = this.parse_ref_spec();
            if (this.matched.containsKey("DEFERRED")) {
                column.fk_flags += 64;
            }
            if (this.matched.containsKey("deferrence")) {
                this.matched.mark("deferrence");
                if (this.matched.containsKey("NOT")) {
                    column.fk_flags += 128;
                }
            }
        }
    }

    public int getParameterCount() {
        return this.matched.getParameterCount();
    }

    public Object[] getParams() {
        return (Object[])this.matched.params.clone();
    }

    public Table getResultSet() {
        return this.rsTable;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    void handleGroupBy() throws SQLException {
        Object object = this.matched.getMark();
        String string = this.rsTableName;
        this.rsTableName = null;
        this.filterScan = true;
        this.compile_select(null, null, null);
        this.filterScan = false;
        this.filterRS = this.rsTable;
        this.rsTable = null;
        this.doingGroupSelect = true;
        this.isGroupBy = true;
        this.groupCols = this.compile_select(null, null, null);
        this.isGroupBy = false;
        this.havingSearch.isGroupBy = false;
        int n = this.groupCols.size();
        this.groupTable = this.rsTable;
        this.rsTable = null;
        int n2 = this.groupTable.rowCount;
        this.groupVals = new Object[n];
        this.rsTableName = string;
        this.matched.mark(object);
        this.lastGroup = true;
        this.compile_select(null, null, null);
        this.filterRS.dropTable(this.trans);
    }

    void lockTableAndFKs(Table table, Vector vector) throws SQLException {
        boolean bl = false;
        if (vector == null) {
            bl = true;
            vector = new Vector<Table>(2, 2);
        }
        if (vector.contains(table)) {
            return;
        }
        vector.addElement(table);
        if (table.hasFK) {
            Vector vector2 = table.columnList;
            int n = 0;
            while (n < vector2.size()) {
                Column column = (Column)vector2.elementAt(n);
                if (column.fkList != null) {
                    int n2 = 0;
                    while (n2 < column.fkList.size()) {
                        Column column2 = (Column)column.fkList.elementAt(n2);
                        this.lockTableAndFKs(column2.cTable, vector);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        if (bl) {
            this.db.lockTables(vector, this.trans, Transaction.WRITE);
        }
    }

    private int parse_ref_spec() {
        int n = 0;
        if (this.matched.containsKey("ref_spec")) {
            Object object;
            Object object2 = this.matched.mark("ref_spec");
            if (this.matched.containsKey("on_delete")) {
                object = this.matched.mark("on_delete");
                if (this.matched.containsKey("CASCADE")) {
                    ++n;
                } else if (this.matched.containsKey("NULL")) {
                    n += 2;
                } else if (this.matched.containsKey("DEFAULT")) {
                    n += 4;
                }
                this.matched.mark(object);
            }
            if (this.matched.containsKey("on_update")) {
                object = this.matched.mark("on_update");
                if (this.matched.containsKey("CASCADE")) {
                    n += 8;
                } else if (this.matched.containsKey("NULL")) {
                    n += 16;
                } else if (this.matched.containsKey("DEFAULT")) {
                    n += 32;
                }
                this.matched.mark(object);
            }
            this.matched.mark(object2);
        }
        return n;
    }

    public void setMaxRows(int n) {
        this.maxRows = n;
    }

    public void setParam(int n, Object object) throws SQLException {
        this.matched.setParam(n, object);
    }

    public void setParams(Object[] objectArray) {
        this.matched.params = objectArray;
    }

    void setResultSetTableName(String string) {
        this.rsTableName = string;
    }
}

