/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 2000 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xalan" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, Lotus
 * Development Corporation., http://www.lotus.com.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.xalan.xslt.extensions;

import org.w3c.dom.*;
import org.apache.xalan.xpath.MutableNodeListImpl;
import org.apache.xalan.xpath.XNodeSet;
import org.apache.xerces.dom.DOMImplementationImpl;

/**
*	Tokenizer class.
* 	This class is an extension implementing a set of tokenizing function.  I've found this functions especially usefull
*	when used with attribute nodes.
*	@author <a href="mailto:benoit.cerrina@writeme.com">Benoit Cerrina</a>
*/
public class Tokenizer
{
	/**
	*	Tokenize a string into a NodeList of text nodes.
	*	The main method for this class, it is used to turn a String and a token separator list into a Node-Set of Text nodes.
	*	@param iToTokenize
	*		The string which needs to be tokenized.
	*	@param iTokenSeparators
	*		The string which contains all the separators used during the tokenization process.
	*	@return
	*		A NodeList containing a text node with the appropriate value for each token in the string.
	*/
	public static NodeList tokenize(String iToTokenize, String iTokenSeparators)	
	{
		java.util.StringTokenizer lTokenizer = new java.util.StringTokenizer(iToTokenize, iTokenSeparators);
		MutableNodeListImpl lListImpl = new MutableNodeListImpl();
		Document lDoc = DOMImplementationImpl.getDOMImplementation().createDocument(null, "tmpDoc", null);
		for (;lTokenizer.hasMoreTokens();)
		{
			try
			{
				lListImpl.addNode(lDoc.createTextNode(lTokenizer.nextToken()));
			}
			catch (Exception e)
			{
				e.printStackTrace();
				return lListImpl;
			}
		}
		return lListImpl;
	}

	/**
	*	Tokenize a Nodelist into a NodeList of text nodes.
	*	Converts the NodeList into a string then calls the first method.
	*	@param iNodes
	*		The Node-Set which needs to be tokenized.
	*	@param iTokenSeparators
	*		The string which contains all the separators used during the tokenization process.
	*	@return
	*		A NodeList containing a text node with the appropriate value for each token in the string.
	*/
	public static NodeList tokenize(NodeList iNodes, String iTokenSeparators)	
	{
		return tokenize((new XNodeSet(iNodes)).str(), iTokenSeparators);
	}

	/**
	*	Tokenize a Nodelist into a NodeList of text nodes.
	*	Converts the NodeList into a string then calls the first method with space and commas as separators.
	*	@param iNodes
	*		The Node-Set which needs to be tokenized.
	*	@return
	*		A NodeList containing a text node with the appropriate value for each token in the string.
	*/
	public static NodeList tokenize(NodeList iNodes)	
	{
		return tokenize((new XNodeSet(iNodes)).str(), " \t\n\r");
	}
	/**
	*	Tokenize a Nodelist into a NodeList of text nodes.
	*	Calls the first method with space and commas as separators.
	*	@param iNodes
	*		The Node-Set which needs to be tokenized.
	*	@return
	*		A NodeList containing a text node with the appropriate value for each token in the string.
	*/
	public static NodeList tokenize(String iToTokenize)	
	{
		return tokenize(iToTokenize, " \t\n\r");
	}
}
