/*
 * Decompiled with CFR 0.152.
 */
package spin.demo.dispatcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import spin.Spin;
import spin.demo.Bean;
import spin.demo.BeanImpl;
import spin.demo.dispatcher.ConcealedDialogDispatcherFactory;
import spin.demo.dispatcher.RevealedDialogDispatcherFactory;
import spin.off.AWTReflectDispatcherFactory;
import spin.off.Dispatcher;
import spin.off.DispatcherFactory;
import spin.off.InternalOptionPaneDispatcherFactory;
import spin.off.SpinOffEvaluator;

public class DispatcherGUI
extends JPanel {
    private JLabel label = new JLabel("???");
    private JButton button = new JButton("Get");
    private JPanel dispatcherFactoryPanel = new JPanel();
    private ButtonGroup dispatcherFactoryGroup = new ButtonGroup();
    private SwitchableDispatcherFactory dispatcherFactory = new SwitchableDispatcherFactory();
    private Bean bean;

    public DispatcherGUI(Bean aBean) {
        Spin spin = new Spin(aBean, new SpinOffEvaluator(this.dispatcherFactory));
        this.bean = (Bean)spin.getProxy();
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Center");
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
        this.add((Component)this.button, "South");
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DispatcherGUI.this.label.setText("...");
                DispatcherGUI.this.button.setEnabled(false);
                String value = DispatcherGUI.this.bean.getValue();
                DispatcherGUI.this.label.setText(value);
                DispatcherGUI.this.button.setEnabled(true);
            }
        });
        this.dispatcherFactoryPanel.setLayout(new GridLayout(0, 1));
        this.dispatcherFactoryPanel.setBorder(new TitledBorder("Choose a dispatcher"));
        this.add((Component)this.dispatcherFactoryPanel, "North");
        Iterator iterator = this.dispatcherFactory.names();
        while (iterator.hasNext()) {
            final String name = (String)iterator.next();
            JRadioButton button = new JRadioButton(name);
            button.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    DispatcherGUI.this.dispatcherFactory.setCurrent(name);
                }
            });
            this.dispatcherFactoryGroup.add(button);
            this.dispatcherFactoryPanel.add(button);
            button.setSelected(true);
        }
    }

    public static void main(String[] args) {
        BeanImpl bean = new BeanImpl();
        DispatcherGUI dispatcherGUI = new DispatcherGUI(bean);
        JFrame frame = new JFrame("Dispatchers");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(dispatcherGUI);
        frame.pack();
        frame.setVisible(true);
    }

    private class SwitchableDispatcherFactory
    implements DispatcherFactory {
        private Map factories = new HashMap();
        private String current;

        private SwitchableDispatcherFactory() {
            this.factories.put("AWT Reflection", new AWTReflectDispatcherFactory());
            this.factories.put("Concealed Dialog", new ConcealedDialogDispatcherFactory());
            this.factories.put("Revealed Dialog", new RevealedDialogDispatcherFactory());
            this.factories.put("Internal OptionPane", new InternalOptionPaneDispatcherFactory());
        }

        public Iterator names() {
            return this.factories.keySet().iterator();
        }

        public void setCurrent(String name) {
            this.current = name;
        }

        public Dispatcher createDispatcher() {
            DispatcherFactory dispatcherFactory = (DispatcherFactory)this.factories.get(this.current);
            return dispatcherFactory.createDispatcher();
        }
    }
}

