package com.ibm.bsf.util;

/**
 * An <code>ObjInfo</code> object is used by a compiler to track the name and
 * type of a bean.
 * 
 * @author   Matthew J. Duftler
 */
public class ObjInfo
{
  static private String QUOTE_CHARS = "\'\"",
                        EXEC_CHARS  = "(=";
         public  String objName;
         public  Class  objClass;

  public ObjInfo(Class objClass, String objName)
  {
    this.objClass = objClass;
    this.objName  = objName;
  }

  public boolean isExecutable()
  {
    char[]  chars            = objName.toCharArray();
    char    openingChar      = ' ';
    boolean inString         = false,
            inEscapeSequence = false;

    for (int i = 0; i < chars.length; i++)
    {
      if (inEscapeSequence)
      {
        inEscapeSequence = false;
      }
      else if (QUOTE_CHARS.indexOf(chars[i]) != -1)
      {
        if (!inString)
        {
          openingChar = chars[i];
          inString = true;
        }
        else
        {
          if (chars[i] == openingChar)
          {
            inString = false;
          }
        }
      }
      else if (EXEC_CHARS.indexOf(chars[i]) != -1)
      {
        if (!inString)
        {
          return true;
        }
      }
      else if (inString && chars[i] == '\\')
      {
        inEscapeSequence = true;
      }
    }

    return false;
  }

  public boolean isValueReturning()
  {
    return (objClass != void.class && objClass != Void.class);
  }

  public String toString()
  {
    return StringUtils.getClassName(objClass) + " " + objName;
  }
}